/*****************************************************************/
/*                          GRABTEST.C                           */
/*****************************************************************/
/*
*  By:		Michel Pelletier
*		Matrox Electronic Systems ltd.
*
*  Date:	May 4, 1993
*
*  Synopsys:	This program demonstrates basic operations on the 
*		Image-Series, using Image-Shell functions.  A freshly
*		downloaded Image-Shell is assumed.
*
*  Copyright (C) 1993.  Matrox Electronic Systems, Ltd.
*  All rights reserved
*/
/*****************************************************************/

/************************/
/* Inclusion statements */
/************************/
#include <grabtest.h>

/*********************************/
/* Global and external variables */
/*********************************/
unsigned long	gain = I_GAIN1;
int		grabbing_mode = NORMAL;
int		OVRLocation, grab_source, grab_destination, handle;
int		process_flag = OFF;
short		screen_w, screen_h, roix, roiy, roi_posx, roi_posy, interlace;
short		board_type, asd_quantity, rtp_quantity, alu_quantity, opt_memory;
short		vga_ovrmode;
short		logcam = I_RS170_HI;
short		strap[4] ={I_LOUT_AIN_LOW, I_LOUT_AOUT_LOW, 
			I_LIN_AIN_LOW, I_LIN_AOUT_LOW};
unsigned long 	histogram_buffer[256];
int		xmem_size, ymem_size;
int		xdisp_pos = 0;
int		ydisp_pos = 0;
int		xdisp_zoom = 1;
int		ydisp_zoom = 1;
int		xovr_zoom = 1;
int		yovr_zoom = 1;
int		font_xsize = 8;
int		font_ysize = 16;
signed long	blackref = 44;
signed long	whiteref = 13;
char		*message_text[MAX_MESSAGE_LINES];
char		temp_buffer[MAX_CHARS_PER_LINE + 1];
int		num_message_lines  =  0;
int		max_message_width  = 10;
int     	wleft, wtop, wright, wbottom, wwidth, wheight;
long		exposure = 200000L;
long		transfer = 480000L;
int		mouse_present = NO;
int		mouse_type = TWO_BUTTON;
int		mouse_x_pos = 0;
int		mouse_y_pos = 0;
int		button_state = UP;
unsigned long	last_pressed;
unsigned char	last_overflow;

extern	BUTTON  button[];
extern	BUTTON  Sbutton[];
extern	LABEL 	label[];
extern	LABEL 	Slabel[];

void main( int argc, char *argv[] )
{
char   		finished;
int    		pbutton, i;
int    		ch;
int		xpos = 0, ypos = 0;
int		xcharsize;
int		fontnum, smoothing_state;
signed int	maxpan, maxscroll;
int		arg1, arg2;
char		font_spec[20];

/**************************/
/* Parse the command-tail */
/**************************/
arg1 = logcam;
arg2 = grabbing_mode;
switch( argc )
	{
	case 1:
	break;

	case 3:	arg2 = atoi( argv[2] );
	case 2:	arg1 = atoi( argv[1] );
	if( (arg2 >  0) && (arg2 <= MAX_MODE) &&
	    (arg1 >= 0) && (arg1 <= MAXCAM) )
		{
		logcam = arg1;
		grabbing_mode = arg2;
		break;
		}
	default:
	printf( "Improper parameter.\n" );
	printf( "Usage:  GRABTEST [logcam] [grabbing_mode]\n" );
	printf( "        Where [logcam] is the logical camera\n" );
	printf( "        number to use for grabbing images.\n" );
	printf( "                 default = [%d]\n", logcam );
	printf( "        And [grab_mode] is one of the following\n" );
	printf( "        values:         NORMAL [%d]\n", NORMAL );
	printf( "                      SOFTTRIG [%d]\n", SOFTTRIG );
	printf( "                  TTL_HARDTRIG [%d]\n", TTL_HARDTRIG );
	printf( "                 OPTO_HARDTRIG [%d]\n", OPTO_HARDTRIG );
	printf( "                 default = [%d]\n", grabbing_mode );
	exit( -1 );
	}

/***************************************************/
/* Open and initialise the Image-Series board-set. */
/***************************************************/
i = 0;
while( ((handle = ioopdevice(strap[i], 0)) == -1) && (i < 4) )
	{
	i++;
	}
if(i == 4)
	{
	printf( "Error communicating with your Image-Series board-set.\n" );
	exit( -1 );
	}
iosldevice( handle );
ioslmemdevice( handle );

/*****************/
/* Init hardware */
/*****************/
init_image_series();

/**************************************************/
/* Initialise the mouse driver and CTRL-C handler */
/**************************************************/
InitMouseDriver();
signal(SIGINT, CtrlC_Handler);

/********************************************/
/* Draw graphics menu in the overlay buffer */
/********************************************/
if( OVRLocation == IM_OVERLAY )
   {
   /******************************************************/
   /* Use Image-Shell graphics functions for drawing in  */
   /* the IM-1280 or IM-640 overlay frame buffer         */
   /******************************************************/
   lssfont( -4 );
   sctxssf( (FIXPT)1.0, (FIXPT)1.0 );
   }
else
   {
   /*****************************************************/
   /* Use Microsoft C graphics functions for drawing in */
   /* the VGA's frame buffer.                           */
   /*****************************************************/
   if( (fontnum = _registerfonts( FONTSPEC )) < 0 )
	{
	printf( "Cannot register font: %s\n", FONTSPEC );
	printf( "Press a key..." );
	getch();
	Termination();
	}
   sprintf( font_spec, "n%d w%d h%d", fontnum, font_xsize, font_ysize );
   _setfont( font_spec );
   }

/*===================================================*/
/* Change button and label information for F5 and F6 */
/* keys if grabbing_mode is different from NORMAL    */
/* This is because F5 and F6 keys have different     */
/* usages depending on the grabbing_mode.            */
 /*===================================================*/
if( grabbing_mode != NORMAL )
	{
	memcpy( (void *)&label[B_F5], (void *)&Slabel[0], sizeof( LABEL ) );
	memcpy( (void *)&label[B_F6], (void *)&Slabel[1], sizeof( LABEL ) );
	memcpy( (void *)&button[B_F5], (void *)&Sbutton[0], sizeof( BUTTON ) );
	memcpy( (void *)&button[B_F6], (void *)&Sbutton[1], sizeof( BUTTON ) );
	}

OVR_Draw3DRect(BX_BLACKBOARD, BY_BLACKBOARD,
                  BW_BLACKBOARD, BH_BLACKBOARD,
                  OVR_BRIGHTWHITE,
                  OVR_GRAY,
                  OVR_WHITE, OVR_WHITE,
                  OVR_GRAY,    
                  OVR_GRAY,  OVR_GRAY);

/* output the multi-colored title. */
if( OVRLocation == IM_OVERLAY )
   {
   /*******************************************************/
   /* Use Image-Series graphics functions for drawing in  */
   /* the IM-1280 or IM-640 overlay frame buffer          */
   /*******************************************************/
   sctxssf( (FIXPT)1.0, (FIXPT)3.0 );
   }
else
   {
   /*****************************************************/
   /* Use Microsoft C graphics functions for drawing in */
   /* the VGA's frame buffer.                           */
   /*****************************************************/
   sprintf( font_spec, "n%d w%d h%d", fontnum, font_xsize, font_ysize * 3 );
   _setfont( font_spec );
   }

xpos = DX_TITLE;
xcharsize = font_xsize + (font_xsize / 4);

OVR_Print( xpos, DY_TITLE,  DW_TITLE, DH_TITLE, xpos, DY_TITLE,        OVR_GREEN, OVR_BRIGHTWHITE, "G" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,    OVR_LIGHTCYAN, OVR_BRIGHTWHITE, "R" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,          OVR_RED, OVR_BRIGHTWHITE, "A" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE, OVR_LIGHTMAGENTA, OVR_BRIGHTWHITE, "B" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,        OVR_BROWN, OVR_BRIGHTWHITE, "T" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,    OVR_LIGHTBLUE, OVR_BRIGHTWHITE, "E" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,   OVR_LIGHTGREEN, OVR_BRIGHTWHITE, "S" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,         OVR_CYAN, OVR_BRIGHTWHITE, "T" );
xpos += xcharsize;
xpos += xcharsize;
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,        OVR_GREEN, OVR_BRIGHTWHITE, "E" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,    OVR_LIGHTCYAN, OVR_BRIGHTWHITE, "x" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,          OVR_RED, OVR_BRIGHTWHITE, "a" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE, OVR_LIGHTMAGENTA, OVR_BRIGHTWHITE, "m" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,        OVR_BROWN, OVR_BRIGHTWHITE, "p" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,    OVR_LIGHTBLUE, OVR_BRIGHTWHITE, "l" );
xpos += xcharsize;
OVR_Print( xpos, DY_TITLE, xcharsize, DH_TITLE, xpos, DY_TITLE,   OVR_LIGHTGREEN, OVR_BRIGHTWHITE, "e" );
if( OVRLocation == IM_OVERLAY )
   {
   /*******************************************************/
   /* Use Image-Series graphics functions for drawing in  */
   /* the IM-1280 or IM-640 overlay frame buffer          */
   /*******************************************************/
   sctxssf( (FIXPT)1.0, (FIXPT)1.0 );
   }
else
   {
   /*****************************************************/
   /* Use Microsoft C graphics functions for drawing in */
   /* the VGA's frame buffer.                           */
   /*****************************************************/
   sprintf( font_spec, "n%d w%d h%d", fontnum, font_xsize, font_ysize );
   _setfont( font_spec );
   }

OVR_PushButton(B_F1);
OVR_PushButton(B_F2);
OVR_PushButton(B_F3);
OVR_PushButton(B_F4);
OVR_PushButton(B_F5);
OVR_PushButton(B_F6);
OVR_PushButton(B_F7);
OVR_PushButton(B_F8);
OVR_PushButton(B_F9);
OVR_PushButton(B_F10);

/* output the function and cursor key titles */
OVR_Print(DX_TREF, DY_TREF, DW_TREF, DH_TREF,
             DX_TREF +7,   DY_TREF +7,
             OVR_RED, OVR_BRIGHTWHITE, "White/Black References");

/* output the white and black reference values */
OVR_Print(DX_WREF, DY_WREF, DW_WREF, DH_WREF,
             DX_WREF +7,   DY_WREF +7,
             OVR_BRIGHTWHITE, OVR_BLUE, "W:     %2d", whiteref);

OVR_Print(DX_BREF, DY_BREF, DW_BREF, DH_BREF,
             DX_BREF +7,   DY_BREF +7,
             OVR_BRIGHTWHITE, OVR_BLUE, "B:     %2d", blackref);

if( grabbing_mode != NORMAL )
	{
	OVR_Print(DX_TEXP, DY_TEXP, DW_TEXP, DH_TEXP,
	             DX_TEXP +7,   DY_TEXP +7,
	             OVR_RED, OVR_BRIGHTWHITE, "Exposure Duration");
	OVR_Print(DX_EXPOS, DY_EXPOS, DW_EXPOS, DH_EXPOS,
	             DX_EXPOS +7,   DY_EXPOS +7,
	             OVR_BRIGHTWHITE, OVR_BLUE, "X: %6ld", exposure);
	}

/*******************************************************************/
/* Ok.. This the the main loop used for processing keyboard input. */
/*******************************************************************/
//ShowTheMouse();	/* Mouse software not ready yet */

StartTheProcess();
finished = FALSE;
do	{
	while( kbhit() )
		{
	  	/* get input from user. */
	  	ch = ggetch();
	  	switch (ch) 
	    		{
			/******************************/
			/* F1 - Raise white reference */
			/* F2 - Lower white reference */
			/******************************/
	     		case F1:
	     		case F2:
			StopTheProcess();
	       		if (ch == F1) 
				{
	         		pbutton   = B_F1;
				whiteref++;
				whiteref = min( 63L, whiteref );
	       			} 
			else 
				{
	         		pbutton   = B_F2;
	            		whiteref--;
				whiteref = max( 0L, whiteref );
	       			}
			label[pbutton].state = ON;		/* update button state */
			label[pbutton].log_state ^= 1;

	       		OVR_PushButton(pbutton);
			OVR_Print(DX_WREF, DY_WREF, DW_WREF, DH_WREF,	/* update OVR 'user interface'. */
			        DX_WREF +7,   DY_WREF +7,
				OVR_BRIGHTWHITE, OVR_BLUE,
				"W:     %2d", whiteref);
			StartTheProcess();
	       		break;

			/******************************/
			/* F3 - Raise black reference */
			/* F4 - Lower black reference */
			/******************************/
	     		case F3:
	     		case F4:            
			StopTheProcess();
	       		if (ch == F3) 
				{
	         		pbutton   = B_F3;
				blackref++;
	            		blackref = min( 63L, blackref );
	       			}
			else 
				{
	         		pbutton   = B_F4;
				blackref--;
	            		blackref = max( 0L, blackref );
	       			}
			label[pbutton].state = ON;		/* update button state */
			label[pbutton].log_state ^= 1;

	       		OVR_PushButton( pbutton );
			OVR_Print(DX_BREF, DY_BREF, DW_BREF, DH_BREF,	/* update OVR 'user interface'. */
			        DX_BREF +7,   DY_BREF +7,
				OVR_BRIGHTWHITE, OVR_BLUE,
				"B:     %2d", blackref);
			StartTheProcess();
	       		break;

			/************************************************************/
			/* F5 - Automatic Calibration if( grabbing_mode == NORMAL ) */
			/* F5 - Increase exposure     if( grabbing_mode != NORMAL ) */
			/************************************************************/
	     		case F5:
			if( grabbing_mode == NORMAL )
				{
				StopTheProcess();
				RemoveHistogram();
				smoothing_state = label[B_F8].log_state;
				label[B_F8].log_state = DISABLED;	/* Disable Smoothing */
				Message("Automatic Calibration:  Please make  sure your camera, or input");
				Message("device, delivers a stable image containing both BLACK and WHITE");
				Message("components.");
				Message("Press any key to continue...");
				ShowMessage( WITHOUT_PAUSE );
				while( !kbhit() )
					{
					GrabImages( 1 );
					}
				ggetch();
				RemoveMessage();
				switch( AutomaticCalibration() )
					{
					case E_OK:
					break;

					case E_CANT_SET_PREAMP:
					Message("Cannot set Input Amplifier Gain." );
					Message("Operation aborted.");
					ShowMessage( WITH_PAUSE );
					break;

					case E_CANT_SET_WHITE:
					Message("Cannot set WHITE reference." );
					Message("Operation aborted.");
					ShowMessage( WITH_PAUSE );
					break;

					case E_CANT_SET_BLACK:
					Message("Cannot set BLACK reference." );
					Message("Operation aborted.");
					ShowMessage( WITH_PAUSE );
					break;

					default:
					Message("Unknown error during automatic calibration." );
					Message("Operation aborted.");
					ShowMessage( WITH_PAUSE );
					break;
					}
				/* output the white and black reference values */
				OVR_Print(DX_WREF, DY_WREF, DW_WREF, DH_WREF,
				             DX_WREF +7,   DY_WREF +7,
				             OVR_BRIGHTWHITE, OVR_BLUE, "W:    %2d", whiteref);
				OVR_Print(DX_BREF, DY_BREF, DW_BREF, DH_BREF,
				             DX_BREF +7,   DY_BREF +7,
				             OVR_BRIGHTWHITE, OVR_BLUE, "B:    %2d", blackref);
				label[B_F8].log_state = smoothing_state;	/* Restore smoothing state */
				StartTheProcess();
				}
			else
				{
				/*===================*/
				/* Increase exposure */
				/*===================*/
				StopTheProcess();
				exposure += 1000L;
				exposure = min( 999999L, exposure );
				label[B_F5].state = ON;
				label[B_F5].log_state ^= 1;
				OVR_PushButton( B_F5 );
				OVR_Print(DX_EXPOS, DY_EXPOS, DW_EXPOS, DH_EXPOS,
				             DX_EXPOS +7,   DY_EXPOS +7,
				             OVR_BRIGHTWHITE, OVR_BLUE, "X: %6ld", exposure);
				StartTheProcess();
				}
	       		break;

			/************************************************************/
			/* F6 - View Entire Image if( grabbing_mode == NORMAL ) */
			/* F6 - Decrease exposure if( grabbing_mode != NORMAL ) */
			/************************************************************/
	     		case F6:
			if( grabbing_mode == NORMAL )
				{
				maxpan = max( 0, roix - screen_w );
				maxscroll = max( 0, roiy - screen_h );
				/*===========*/
				/* Pan right */
				/*===========*/
				for( i = 0; i < maxpan; i++ )
					{
					lsdcstpzscroll( I_VDO_MFB, (long)i, 0L,
						xdisp_zoom, ydisp_zoom, I_VDO_NOMOS );
					}
				HostWait4All;
				/*=============*/
				/* Scroll down */
				/*=============*/
				for( i = 0; i < maxscroll; i++ )
					{
					lsdcstpzscroll( I_VDO_MFB, (long)maxpan, (long)i,
						xdisp_zoom, ydisp_zoom, I_VDO_NOMOS );
					}
				HostWait4All;
				/*===============*/
				/* Pan back left */
				/*===============*/
				for( i = maxpan; i; i-- )
					{
					lsdcstpzscroll( I_VDO_MFB, (long)i, (long)maxscroll,
						xdisp_zoom, ydisp_zoom, I_VDO_NOMOS );
					}
				HostWait4All;
				/*================*/
				/* Scroll back up */
				/*================*/
				for( i = maxscroll; i; i-- )
					{
					lsdcstpzscroll( I_VDO_MFB, 0L, (long)i,
						xdisp_zoom, ydisp_zoom, I_VDO_NOMOS );
					}
				HostWait4All;
				}
			else
				{
				/*===================*/
				/* Decrease exposure */
				/*===================*/
				StopTheProcess();
				exposure -= 1000L;
				exposure = max( 50000L, exposure );
				label[B_F6].state = ON;
				label[B_F6].log_state ^= 1;
				OVR_PushButton( B_F6 );
				OVR_Print(DX_EXPOS, DY_EXPOS, DW_EXPOS, DH_EXPOS,
				             DX_EXPOS +7,   DY_EXPOS +7,
				             OVR_BRIGHTWHITE, OVR_BLUE, "X: %6ld", exposure);
				StartTheProcess();
				}
	       		break;

			/*****************************************/
			/* F7 - Enable/Disable Histogram drawing */
			/*****************************************/
	     		case F7:
			StopTheProcess();
			label[B_F7].state = ON;		/* update button state */
			label[B_F7].log_state ^= 1;
	       		OVR_PushButton(B_F7);
			RemoveHistogram();
			StartTheProcess();
	       		break;

			/************************************************/
			/* F8 - Enable/Disable Smoothing while grabbing */
			/************************************************/
	     		case F8:
			StopTheProcess();
			label[B_F8].state = ON;		/* update button state */
			label[B_F8].log_state ^= 1;
	       		OVR_PushButton(B_F8);
			StartTheProcess();
	       		break;

			/********************************/
			/* F9 - Enable/Disable grabbing */
			/********************************/
	     		case F9:
			StopTheProcess();
			label[B_F9].state = ON;		/* update button state */
			label[B_F9].log_state ^= 1;
	       		OVR_PushButton(B_F9);
			StartTheProcess();
	       		break;

			/***********************************/
			/* F10 or ENTER_KEY - Exit Program */
			/***********************************/
	     		case F10:
			case ENTER_KEY:
			StopTheProcess();
			label[B_F10].state = ON;		/* update button state */
			label[B_F10].log_state ^= 1;
	       		OVR_PushButton(B_F10);
	       		finished = TRUE;
	       		break;
	     		}
		}
	for( i = 0; i < GetNumLabels(); i++ )	/* Make sure all buttons are up */
		{				/* if no key is pressed         */
		if( label[i].state == ON )
			{
			label[i].state = OFF;
			OVR_PushButton( i );
			}
		}
	if( process_flag == ON )
		{
		GrabImages( 1 );
		if( label[B_F7].log_state == ENABLED )
			{
			pcslsync( I_PROC_ALONE );
			pcstcond( 0, I_FOR, 1 );
			stcchist( grab_destination, I_PAL_IS_256, I_LUT_CLEAR );
			HostWait4Proc;
			lslmrdlut( I_LUT_STAT_24B, 512L );
			iogetbuf( (short *)histogram_buffer, 512 );
			DrawHistogram();
			}
		}
   	} while (finished == FALSE);
Termination();
}

