/*/
*   MEGA_16.C
*
*   ImInit Image-Series Utility Ver: 1.02es
*   Copyright (C) 1992, 1993.  Matrox Electronic Systems Ltd.
*
*   Date:   Tue Jan 25 1994
*   Time:   14:22:48
*
*   Target board: ASD Normal
*   Camera Type: Digital RS422, MONOSHOT grab.
*   Resolution: 1280H x 1024V
*   Pixel clock rate: 10.000 MHz
*
*   Target camera:
*
*   Camera mode:
*
*   Electrical interface:
*
*   Anything requiring clarification:
*
**/

#include "llashead.h"   /* Contains all defines used as parameters   */
#include "camera.h"     /* Contains camera structure definition      */
#include "i_head.h"

#define PIXELCLK  10.000              /* pixel clock frequency in MHz      */

#define DIGPIXCLK PIXELCLK * 1000     /* digitizer pixel clock in kHz      */

/* US_TO_PIX() macro can be used to specify horizontal timing in usec      */
/* instead of in number of pixels.                                         */
/* US_TO_PIX() should be used when no clock signal is included in the      */
/* camera-to-digitizer interface.                                          */

#define US_TO_PIX(p) (p)*PIXELCLK+0.5 /* macro definition that converts    */
                                      /* a usec value to a nb. of pixels.  */

CAMERA mega_16 = {

/* ------------------------ BASIC INFORMATION ----------------------------*/

        ASD_NORMAL,     /* target_board:                                */
                        /* logical camera format id                     */
                        /* #defines : ASD_NORMAL : Normal ASD (IM-ASD)  */
                        /*            ASD_H : High resolution ASD       */
                        /*                    (IM-ASD/H)                */

                 0,     /* hdigcomp:                      */
                        /* horizontal compensation factor */

       PROGRESSIVE,     /* scan_mode:                          */
                        /* scan mode                           */
                        /* #defines: INTERLACED, PROGRESSIVE   */
                        /*           LINEGRAB                  */

       STARTNEXTFD,     /* start_field:                                    */
                        /* start field                                     */
                        /* #defines: STARTNEXTFD (do not use), STARTEVENFD,*/
                        /*           NEXTFIELD, EVERYFD (obsolete),        */
                        /*           STARTODDFD, EVENFIELD (do not use),   */
                        /*           ODDFIELD (do not use)                 */

         DIGPIXCLK,     /* pixclk: Digitizer pixel clock                   */
                        /*         This parameter is defined using         */
                        /*         DIGPIXCLK.                              */

       ADR_HRES_ON,     /* adr_hres:                              */
                        /* adr hreset                             */
                        /* H defines: ADR_HRES_ON, ADR_HRES_OFF   */

       ADR_VRES_ON,     /* adr_vres:                              */
                        /* adr hreset                             */
                        /* H defines: ADR_VRES_ON, ADR_VRES_OFF   */

/*--------------------------- TIMING SECTION ------------------------------*/

                 7,     /* vblnkw:                 */
                        /* vertical blanking width */

   242 /* 0x1f0 */,     /* hblnkw:                    */
                        /* horizontal blanking width  */

17416 /* 0x4408 */,     /* vtotal:        */
                        /* vertical total */

  1776 /* 0x6f0 */,     /* htotal:          */
                        /* horizontal total */

    121 /* 0xf8 */,     /* hsync:                  */
                        /* horizontal sync width   */

             DUMMY,     /* psg_htotal:       */
                        /* PSG-1024 htotal   */
                        /* value or DUMMY    */

  1534 /* 0x500 */,     /* roi_hmax:            */
                        /* ROI maximum width    */

                 6,     /* vsync:               */
                        /* vertical sync width  */

  1033 /* 0x409 */,     /* psg_vtotal:       */
                        /* PSG-1024 vtotal   */
                        /* value or DUMMY    */

  1024 /* 0x400 */,     /* roi_vmax:            */
                        /* ROI maximum height   */

/*-----------------------  CLAMPING TIMING SECTION ------------------------*/

             DUMMY,     /* hsclmp:                 */
                        /* horizontal start clamp  */
                        /* value or DUMMY          */

             DUMMY,     /* clmpwidth:           */
                        /* clamping pulse width */
                        /* value or DUMMY       */

/*-------------------- PROGRAMMABLE TIMER SECTION -------------------------*/

             DUMMY,     /* trigger:                                  */
                        /* programmable timer mode                   */
                        /* H defines: HARDTRIG, TIMEBASETRIG, DUMMY  */
                        /*            SOFTTRIG                       */

             DUMMY,     /* exposure:      */
                        /* exposure time  */
                        /* value or DUMMY */

             DUMMY,     /* transfer:      */
                        /* transfer time  */
                        /* value or DUMMY */

/*-------------------------- ASD MODE SECTION -----------------------------*/

        FRAME_SCAN,     /* monoshot_mode:                                  */
                        /* PSG-1024 and ASD mode                           */
                        /* H defines : NO_MONOSHOT, NO_MONOSHOT_NIL,       */
                        /*             NO_MONOSHOT_MASTER, LINE_SCAN,      */
                        /*             FRAME_SCAN                          */

   INTL_FRAME_SCAN,     /* intl_frame_scan:                                */
                        /* monoshot single-field frame scan                */
                        /* H defines : INTL_FD_SCAN, INTL_FRAME_SCAN,      */
                        /*             DUMMY                               */

/*----------------- SYNCHRONISATION INTERFACE SECTION ---------------------*/

             DUMMY,     /* csync_fmt:                                      */
                        /* PSG-1024 output composite sync format           */
                        /* H defines : BLOCKSYNC, SERRTSYNC, SEREQUSYNC,   */
                        /*             DUMMY                               */

        RS422SYINT,     /* interface:                                      */
                        /* synchronization interface                       */
                        /* H defines: ANALOGSYINT, TTLSYINT, RS422SYINT,   */
                        /*            TTLINRSOUTSYINT, RSINTTLOUTSYINT,    */
                        /*            ANAINTTLOUTSYINT, ANAINRSOUTSYINT    */

            INT_IN,     /* int_dir:                            */
                        /* synchronization direction           */
                        /* H defines: INT_IN, INT_OUT, DUMMY   */

            HVSYNC,     /* sep_sync:                        */
                        /* digital interface sync. format   */
                        /* H defines: CSYNC, HVSYNC, DUMMY  */

             DUMMY,     /* sync_chan:                                      */
                        /* analog sync. channel                            */
                        /* H defines: CH0SYNC, CH1SYNC, CH2SYNC, CH3SYNC,  */
                        /*            DUMMY                                */

        PSGEXTSYNC,     /* psgmode:                            */
                        /* PSG-1024  mode                      */
                        /* H defines: PSGINTSYNC, PSGEXTSYNC   */

             DUMMY,     /* psghres:                            */
                        /* enable PSG-1024 input hreset        */
                        /* H defines: ENHRES, DISHRES, DUMMY   */

           LOSYPOL,     /* sync_pol:                                     */
                        /* sync. signal polarities                       */
                        /* 0 = low going edge                            */
                        /* 1 = high going edge                           */
                        /*       bit 0 : ASD input hsync polarity        */
                        /*       bit 1 : ASD input vsync polarity        */
                        /*       bit 2 : ASD input csync polarity        */
                        /*       bit 3 : ASD output hsync polarity       */
                        /*       bit 4 : ASD output vsync polarity       */
                        /*       bit 5 : ASD output csync polarity       */
                        /*       bit 6 : PSG-1024 input hreset polarity  */
                        /*       bit 7 : PSG-1024 input vreset polarity  */
                        /*       bit 8 : PSG-1024 output hsync           */
                        /*       bit 9 : PSG-1024 output vsync           */
                        /* H defines: HISYPOL : 0xbf                     */
                        /*            LOSYPOL : 0x80 (RS170/CCIR)        */

/*--------------------------- CLOCK SECTION -------------------------------*/

   DIRECT_EXTCLKIN,     /* clk_src:                                        */
                        /* clock source                                    */
                        /* H defines: PLLCLK, USERCLK, EBICLK,             */
                        /*            DIRECT_EXTCLKIN, EXTCLK,             */
                        /*            USERCLKOUT_EXTCLKIN,                 */
                        /*            EBICLKOUT_EXTCLKIN                   */

              DIV1,     /* div_fact:                           */
                        /* PSG-1024 clock division factor      */
                        /* H defines: DIV1, DIV2, DIV4, DIV8   */

        RS422CLKIN,     /* in_clk:                                   */
                        /* Enable digital input clock interface      */
                        /* H defines : RS422CLKIN, TTLCLKIN, NOCLKIN */

       RS422CLKOUT,     /* out_clk:                                     */
                        /* Enable digital output clock and exposure     */
                        /* signal interface.                            */
                        /* H defines : RS422CLKOUT, TTLCLKOUT, NOCLKOUT */

    INCLK_LOW_EDGE,     /* in_clk_pol:                                  */
                        /* PSG-1024 clock polarity.                     */
                        /* H defines: INCLK_HIGH_EDGE, INCLK_LOW_EDGE   */

/*------------------------- DATA PATH SECTION -----------------------------*/

           RS422DT,     /* data_src:                           */
                        /* Enable data interface               */
                        /* H defines: ANALOGDT, RS422DT, TTLDT */

             DUMMY,     /* chsrc:                                       */
                        /* Analog data channel select                   */
                        /* H defines: CH0DIG, CH1DIG, CH2DIG, CH3DIG,   */
                        /*            DUMMY                             */

           W16BITS,     /* buswidth:                           */
                        /* Digital data format select          */
                        /* H_defines: W8BITS, W16BITS, DUMMY   */

         MSK12BITS,     /* mask:                                        */
                        /* Iluts address bits coming from digital data. */
                        /* H_defines: MSK8BITS, MSK9BITS, MSK10BITS,    */
                        /*            MSK11BITS, MSK12BITS              */

                 0,     /* palette:                                        */
                        /* Lut initial palette number ranging from 0 to 15.*/

/*----------------------- GAIN, REFERENCES SECTION ------------------------*/

           GN_3_15,     /* gain:                                           */
                        /* Analog initial video gain select.               */
                        /* H defines: GN_3_15, GN_2_10, GN_1_40, GN_0_93,  */
                        /*            DUMMY                                */

                 0,     /* refplus0:   ref1+ ranging from 0 to 63          */
                 0,     /* repminus0:  ref1- ranging from 0 to 63          */

             DUMMY,     /* refplus1:   H_defines: DUMMY                    */
             DUMMY,     /* refminus1:  H_defines: DUMMY                    */

             DUMMY,     /* refplus2:   H_defines: DUMMY                    */
             DUMMY,     /* refminus2:  H_defines: DUMMY                    */

/*--------------------------- OTHER SECTION -------------------------------*/

          USER1_LO,     /* user1:                                 */
                        /* Initial TTL user1 bit level            */
                        /* H defines: USER1_HI, USER1_LO, DUMMY   */

         PSG_VSYNC,     /* vsyncsel:                        */
                        /* ADR-1024 vsync select            */
                        /* H defines: PSG_VSYNC, CAM_VSYNC  */

             DUMMY,     /* sethcnt:                      */
                        /* PSG-1024 preset hcount value  */
                        /* value or DUMMY                */

             DUMMY,     /* setvcnt:                      */
                        /* PSG-1024 preset vcount value  */
                        /* value or DUMMY                */

        };


