/*
    filename :  slmemdev.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* to be moved */
#define N_OF_FBORGS 15
#define N_OF_FBS    4
#define SA_EN_MASK 0x1F

#define HAAENBIT    0x10
#define RESETBIT    0x01

extern  I_IMGLOB    i_glob;

/* conversion tables to get base address and y factor from fborg and fb */
/* fborg use krhwsfborg() notation */
/* fb use krhwslcsurf() notation */
/* tables contain zero for illegal combinations */

unsigned long i_v_base_address_table[15][4] =

   {
      {0xEC000000L, 0xEC800000L, 0xED000000L, 0xED800000L, }, /* 4X1KX1KX8  */
      {0xEC000000L, 0xED000000L,          0L,          0L, }, /* 2X1KX1KX16 */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X1KX1KX32 */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X4KX1KX8  */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X2KX1KX16 */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X2KX2KX8  */
      {0xEC000000L, 0xED000000L,          0L,          0L, }, /* 2X2KX1KX8  */
      {0x70000000L,          0L,          0L,          0L, }, /* 1X2KX1KX8  */
      {0xEC000000L, 0xED000000L, 0xEE000000L, 0xEF000000L, }, /* 4X2KX1KX8  */
      {0xEC000000L, 0xEE000000L,          0L,          0L, }, /* 2X2KX1KX16 */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X2KX1KX32 */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X8KX1KX8  */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X2KX4KX8  */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X4KX2KX8  */
      {0xEC000000L,          0L,          0L,          0L, }, /* 1X2KX2KX16 */
   };            

unsigned short i_v_adrtable[N_OF_FBORGS][N_OF_FBS] = {

    {   0xE000, 0xE400, 0xE800, 0xEC00, },
    {   0xE000, 0xE800, 0,      0,      },
    {   0xE000, 0,      0,      0,      },
    {   0xE000, 0,      0,      0,      },
    {   0xE000, 0,      0,      0,      },
    {   0xE000, 0,      0,      0,      },
    {   0xE000, 0xE800, 0,      0,      },
    {   0x7000, 0,      0,      0,      },
    {   0xE000, 0xE800, 0xF000, 0xF800, },
    {   0xE000, 0xF000, 0,      0,      },
    {   0xE000, 0,      0,      0,      },
    {   0xE000, 0,      0,      0,      },
    {   0xE000, 0,      0,      0,      },
    {   0xE000, 0,      0,      0,      },
    {   0xE000, 0,      0,      0,      },
};

unsigned short i_v_factable[N_OF_FBORGS] = {
    1, 2, 4, 4, 4, 2, 2, 2, 2, 4, 8, 8, 2, 4, 4
};

/* pixel size table. Size in bytes is 1 << n */
unsigned short i_v_sizetable[N_OF_FBORGS] = {
    0, 1, 2, 0, 1, 0, 0, 0, 0, 1, 2, 0, 0, 0, 1
};

/*/     Function:   ioslmemdevice()
*       Synopsis:   select direct vram communication channel
*
*       Date:       May 5, 1990
*
*       Parameter:  short device
*                                               
*       Return value:   -1 if error otherwise 0
**/

#ifdef  ANSI
short FTYPE ioslmemdevice(int handle)
#else
short FTYPE ioslmemdevice(handle)
int handle;
#endif
{
#ifdef I_MS_DOS

    short device = (short)handle;

#ifndef PHAR_LAP
    char    reg;
	char    far *regptr;
#endif

#endif

#if defined(I_UNIX) || defined(I_OS2)
    short device;
#ifndef I_OS2
    char test;
#endif
#endif

#if defined(I_UNIX) || defined(I_OS2)

    /* find device index */
    for (device = 0; device < I_N_OF_DEVICES; device++)
        if ( i_glob.fd[device] == handle)
            break;

    if ( device == I_N_OF_DEVICES )
        return( -1 );

#endif

    /* SHey 94/03/07 Changed test for WATCOM compiler support */
    /* Always cast NULL for type to test */
    /* Check if new device was opened. */
    if ( i_glob.img_addr[device] == (IMGMAP *)NULL )
        return (-1);

    /* check if already selected */
    if (i_glob.vram == handle)
        return (0);

    /* ensure that a process can only select a single mem device */
    if (i_glob.vram != -1)
        iorlmemdevice(i_glob.vram);

#ifdef  I_UNIX

    ioctl(handle, IMG_SLMEMDEV, &test);

    if(!test)
        return(-1);

#endif

#ifdef  I_OS2

    if ( DosDevIOCtl( 0L,
                      0L,
                      (USHORT) I_SL_FBAREA,
                      (USHORT) 0x80,
                      (HFILE)  i_glob.board) )
       return(-1);

#endif

#ifdef  I_MS_DOS


#ifndef PHAR_LAP

    /* check for conflict with another board */
     regptr = &((( i_glob.img_addr[device] ) -> hra[ (( device - 1) & 1) ^ 1 ]).hctrl );
    reg = *regptr;

    /* is there another board sharing this HAA enabled ? */
    if  ((reg & HAAENBIT) && (!(reg & RESETBIT)))
        {
        /* is this really a board ? write & read back to make sure.     */
        /* N.B. as this memory regin is within the address range        */
        /* of the khown board, it can only be used by another IM-1280   */
        /* sharing the same address range */
        *regptr = 0;
        if ( *regptr == 0 )
            {
            /* there really is another board with HAA enabled. */
            /* restore register */
            *regptr = reg;
            /* return error message */
           return (-1);
           }
        }
#endif

    /* Send command to enable newly selected board */
    IMG_ENABLE(device);

#endif

    /* Change current board. */

    i_glob.vram = handle;

    i_glob.vram_dev  = device;
    i_glob.vrammap   = i_glob.img_addr[device];

#ifdef  I_MS_DOS
        i_glob.vram_unit = ( device - 1 ) & 1;
#endif
#ifdef  I_UNIX
        /* more magic numbers please */
        i_glob.vram_unit = (((device <= 7) && (device >= 1)) ||
         ((device <= 21) && (device >= 15))) ? 0 : 1;
#endif
#ifdef  I_OS2
        /* more magic numbers please */
        i_glob.vram_unit = (((device <= 7) && (device >= 1)) ||
         ((device <= 21) && (device >= 15))) ? 1 : 0;
#endif

    i_glob.vramhra = (IMGHRA *)&((i_glob.vrammap) -> hra[i_glob.vram_unit]);

    return( 0 );

} /* ioslmemdevice() */ 
