#
# make file to build the IM-1280 C-binding libraries under Microsoft C 5.1
#
# library made : image processing large model, im_l.lib

# Path for the destination libraries
LIBPATH = ..\..\library\msc

# Path for the sources
SRCPATH = ..\..\process

# Path for the include files
INC = ..\..\include

# Path for object files
OBJ = ..\..\obj\msc\process

# Librarie name
LIBNAME = im_l

# C compiler
CC = cl

# C compiler flags
CFLAGS = -c -Zp1 -AL -G2 /W3 /I$(INC)

# librarian
LIB = lib

# librarian flags
LFLAGS =

# objects modules for the image processing library
IMOBJ1 = $(OBJ)\alumap.obj \
         $(OBJ)\cclutext.obj \
         $(OBJ)\cclutsta.obj \
         $(OBJ)\cmccitt3.obj \
         $(OBJ)\cntsetdo.obj \
         $(OBJ)\cocv555.obj \
         $(OBJ)\cocvgrey.obj \
         $(OBJ)\codist.obj \
         $(OBJ)\cohsigra.obj \
         $(OBJ)\dcccitt3.obj

IMOBJ2 = $(OBJ)\dchlfct.obj \
         $(OBJ)\dcldvid.obj \
         $(OBJ)\dfker.obj \
         $(OBJ)\dfmker.obj \
         $(OBJ)\dfmstruc.obj \
         $(OBJ)\dfstruct.obj \
         $(OBJ)\digrab.obj \
         $(OBJ)\dildlcam.obj \
         $(OBJ)\dimgrab.obj \
         $(OBJ)\dislbrd.obj

IMOBJ3 = $(OBJ)\dislchan.obj \
         $(OBJ)\dislgain.obj \
         $(OBJ)\dislpal.obj \
         $(OBJ)\disngrab.obj \
         $(OBJ)\distbrit.obj \
         $(OBJ)\distclfm.obj \
         $(OBJ)\distcont.obj \
         $(OBJ)\distcosp.obj \
         $(OBJ)\distdbsc.obj \
         $(OBJ)\distexp.obj

IMOBJ4 = $(OBJ)\disthue.obj \
         $(OBJ)\disthpar.obj \
         $(OBJ)\distrefb.obj \
         $(OBJ)\distrefw.obj \
         $(OBJ)\dlstruct.obj \
         $(OBJ)\distsat.obj \
         $(OBJ)\dlutmap.obj \
         $(OBJ)\docmap.obj \
         $(OBJ)\docompla.obj \
         $(OBJ)\doconfig.obj

IMOBJ5 = $(OBJ)\doconv.obj \
         $(OBJ)\docorner.obj \
         $(OBJ)\dodist.obj \
         $(OBJ)\doerodil.obj \
         $(OBJ)\dofastth.obj \
         $(OBJ)\doizoom.obj \
         $(OBJ)\dolabel.obj \
         $(OBJ)\domarker.obj \
         $(OBJ)\domass.obj \
         $(OBJ)\domatch.obj

IMOBJ6 = $(OBJ)\domconv.obj \
         $(OBJ)\donpix.obj \
         $(OBJ)\doper.obj \
         $(OBJ)\dopoint.obj \
         $(OBJ)\dorank.obj \
         $(OBJ)\dorcdil.obj \
         $(OBJ)\dornoise.obj \
         $(OBJ)\dospix.obj \
         $(OBJ)\dothick.obj \
         $(OBJ)\dozone.obj

IMOBJ7 = $(OBJ)\dsatfilt.obj \
         $(OBJ)\fastcen.obj \
         $(OBJ)\fbcpbtob.obj \
         $(OBJ)\fbcpbtod.obj \
         $(OBJ)\gnluttra.obj \
         $(OBJ)\gnthinlu.obj \
         $(OBJ)\greythin.obj \
         $(OBJ)\gspfct.obj \
         $(OBJ)\gtfbstat.obj \
         $(OBJ)\iqstruct.obj 

IMOBJ8=  $(OBJ)\lmhlfct.obj \
	 $(OBJ)\mul16.obj \
         $(OBJ)\pcbinze.obj \
         $(OBJ)\pcfborg.obj \
         $(OBJ)\pcformat.obj \
         $(OBJ)\pciqsys.obj \
         $(OBJ)\pciqusr.obj \
         $(OBJ)\pccllst.obj 
        
IMOBJ9=	 $(OBJ)\pccrlst.obj \
	 $(OBJ)\pcexelst.obj \
         $(OBJ)\pcrmlst.obj \
         $(OBJ)\pcsccond.obj \
         $(OBJ)\pcscpag.obj \
         $(OBJ)\pcsctag.obj \
         $(OBJ)\pcslcam.obj \
         $(OBJ)\pcslproc.obj \
         $(OBJ)\pcslsync.obj \
         $(OBJ)\pcstcond.obj \
         $(OBJ)\pcstdir.obj 

IMOBJ10= $(OBJ)\pcstkcen.obj \
	 $(OBJ)\pcstlatt.obj \
         $(OBJ)\pcstmsk.obj \
         $(OBJ)\pcstooi.obj \
         $(OBJ)\pcstover.obj \
         $(OBJ)\pcstroi.obj \
         $(OBJ)\pcstssp.obj \
         $(OBJ)\rcerodil.obj \
         $(OBJ)\recthin.obj \
         $(OBJ)\solutmap.obj

IMOBJ11= $(OBJ)\stcchist.obj \
         $(OBJ)\stccprof.obj \
         $(OBJ)\stecount.obj \
         $(OBJ)\stfbstat.obj \
         $(OBJ)\stldlut.obj \
         $(OBJ)\tfilter.obj \
         $(OBJ)\thresh.obj \
         $(OBJ)\utcmlut.obj \
         $(OBJ)\utgnglut.obj \
         $(OBJ)\utlmfct.obj 

IMOBJ12= $(OBJ)\wlevel.obj \
         $(OBJ)\wtsum.obj 



# make the image processing library
$(LIBPATH)\$(LIBNAME).lib : $(IMOBJ1) $(IMOBJ2) $(IMOBJ3) $(IMOBJ4) $(IMOBJ5)\
                            $(IMOBJ6) $(IMOBJ7) $(IMOBJ8) $(IMOBJ9)\
                            $(IMOBJ10) $(IMOBJ11) $(IMOBJ12)

$(OBJ)\ALUMAP.obj   : $(SRCPATH)\ALUMAP.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\CCLUTEXT.obj : $(SRCPATH)\CCLUTEXT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\CCLUTSTA.obj : $(SRCPATH)\CCLUTSTA.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\CMCCITT3.obj : $(SRCPATH)\CMCCITT3.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\CNTSETDO.obj : $(SRCPATH)\CNTSETDO.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\COCV555.obj  : $(SRCPATH)\COCV555.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\COCVGREY.obj : $(SRCPATH)\COCVGREY.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\CODIST.obj   : $(SRCPATH)\CODIST.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;
                   
$(OBJ)\COHSIGRA.obj : $(SRCPATH)\COHSIGRA.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DCCCITT3.obj : $(SRCPATH)\DCCCITT3.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DCHLFCT.obj  : $(SRCPATH)\DCHLFCT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DCLDVID.obj  : $(SRCPATH)\DCLDVID.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DFKER.obj    : $(SRCPATH)\DFKER.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;
                   
$(OBJ)\DFMKER.obj   : $(SRCPATH)\DFMKER.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DFMSTRUC.obj : $(SRCPATH)\DFMSTRUC.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DFSTRUCT.obj : $(SRCPATH)\DFSTRUCT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DIGRAB.obj   : $(SRCPATH)\DIGRAB.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DILDLCAM.obj : $(SRCPATH)\DILDLCAM.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DIMGRAB.obj  : $(SRCPATH)\DIMGRAB.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISLBRD.obj  : $(SRCPATH)\DISLBRD.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISLCHAN.obj : $(SRCPATH)\DISLCHAN.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISLGAIN.obj : $(SRCPATH)\DISLGAIN.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISLPAL.obj  : $(SRCPATH)\DISLPAL.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISNGRAB.obj : $(SRCPATH)\DISNGRAB.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTBRIT.obj : $(SRCPATH)\DISTBRIT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTCLFM.obj : $(SRCPATH)\DISTCLFM.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTCONT.obj : $(SRCPATH)\DISTCONT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTCOSP.obj : $(SRCPATH)\DISTCOSP.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTDBSC.obj : $(SRCPATH)\DISTDBSC.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTEXP.obj  : $(SRCPATH)\DISTEXP.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTHPAR.obj  : $(SRCPATH)\DISTHPAR.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTHUE.obj  : $(SRCPATH)\DISTHUE.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTREFB.obj : $(SRCPATH)\DISTREFB.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTREFW.obj : $(SRCPATH)\DISTREFW.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DLSTRUCT.obj : $(SRCPATH)\DLSTRUCT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DISTSAT.obj  : $(SRCPATH)\DISTSAT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DLUTMAP.obj  : $(SRCPATH)\DLUTMAP.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOCMAP.obj   : $(SRCPATH)\DOCMAP.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;
                    
$(OBJ)\DOCOMPLA.obj : $(SRCPATH)\DOCOMPLA.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOCONFIG.obj : $(SRCPATH)\DOCONFIG.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOCONV.obj   : $(SRCPATH)\DOCONV.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOCORNER.obj : $(SRCPATH)\DOCORNER.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DODIST.obj   : $(SRCPATH)\DODIST.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOERODIL.obj : $(SRCPATH)\DOERODIL.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOFASTTH.obj : $(SRCPATH)\DOFASTTH.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOIZOOM.obj  : $(SRCPATH)\DOIZOOM.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOLABEL.obj  : $(SRCPATH)\DOLABEL.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOMARKER.obj : $(SRCPATH)\DOMARKER.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOMASS.obj   : $(SRCPATH)\DOMASS.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOMATCH.obj  : $(SRCPATH)\DOMATCH.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOMCONV.obj  : $(SRCPATH)\DOMCONV.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DONPIX.obj   : $(SRCPATH)\DONPIX.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOPER.obj    : $(SRCPATH)\DOPER.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOPOINT.obj  : $(SRCPATH)\DOPOINT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DORANK.obj   : $(SRCPATH)\DORANK.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DORCDIL.obj  : $(SRCPATH)\DORCDIL.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DORNOISE.obj : $(SRCPATH)\DORNOISE.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOSPIX.obj   : $(SRCPATH)\DOSPIX.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOTHICK.obj  : $(SRCPATH)\DOTHICK.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOZONE.obj   : $(SRCPATH)\DOZONE.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DSATFILT.obj : $(SRCPATH)\DSATFILT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\FASTCEN.obj  : $(SRCPATH)\FASTCEN.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\FBCPBTOB.obj : $(SRCPATH)\FBCPBTOB.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\FBCPBTOD.obj : $(SRCPATH)\FBCPBTOD.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\GNLUTTRA.obj : $(SRCPATH)\GNLUTTRA.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\GNTHINLU.obj : $(SRCPATH)\GNTHINLU.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\GREYTHIN.obj : $(SRCPATH)\GREYTHIN.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\GSPFCT.obj : $(SRCPATH)\GSPFCT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\GTFBSTAT.obj : $(SRCPATH)\GTFBSTAT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IQSTRUCT.obj : $(SRCPATH)\IQSTRUCT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\LMHLFCT.obj  : $(SRCPATH)\LMHLFCT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\MUL16.obj    : $(SRCPATH)\MUL16.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCBINZE.obj  : $(SRCPATH)\PCBINZE.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCFBORG.obj  : $(SRCPATH)\PCFBORG.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCFORMAT.obj : $(SRCPATH)\PCFORMAT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCIQSYS.obj  : $(SRCPATH)\PCIQSYS.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCIQUSR.obj  : $(SRCPATH)\PCIQUSR.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCCLLST.obj  : $(SRCPATH)\PCCLLST.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCCRLST.obj  : $(SRCPATH)\PCCRLST.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCEXELST.obj : $(SRCPATH)\PCEXELST.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCRMLST.obj  : $(SRCPATH)\PCRMLST.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSCCOND.obj : $(SRCPATH)\PCSCCOND.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSCPAG.obj  : $(SRCPATH)\PCSCPAG.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSCTAG.obj  : $(SRCPATH)\PCSCTAG.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSLCAM.obj  : $(SRCPATH)\PCSLCAM.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSLPROC.obj : $(SRCPATH)\PCSLPROC.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSLSYNC.obj : $(SRCPATH)\PCSLSYNC.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTCOND.obj : $(SRCPATH)\PCSTCOND.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTDIR.obj : $(SRCPATH)\PCSTDIR.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTKCEN.obj : $(SRCPATH)\PCSTKCEN.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTLATT.obj : $(SRCPATH)\PCSTLATT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTMSK.obj  : $(SRCPATH)\PCSTMSK.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTOOI.obj  : $(SRCPATH)\PCSTOOI.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTOVER.obj : $(SRCPATH)\PCSTOVER.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTROI.obj  : $(SRCPATH)\PCSTROI.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCSTSSP.obj  : $(SRCPATH)\PCSTSSP.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\RCERODIL.obj : $(SRCPATH)\RCERODIL.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\RECTHIN.obj  : $(SRCPATH)\RECTHIN.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\SOLUTMAP.obj : $(SRCPATH)\SOLUTMAP.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\STCCHIST.obj : $(SRCPATH)\STCCHIST.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\STCCPROF.obj : $(SRCPATH)\STCCPROF.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\STECOUNT.obj : $(SRCPATH)\STECOUNT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\STFBSTAT.obj : $(SRCPATH)\STFBSTAT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\STLDLUT.obj  : $(SRCPATH)\STLDLUT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\TFILTER.obj  : $(SRCPATH)\TFILTER.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\THRESH.obj   : $(SRCPATH)\THRESH.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\UTCMLUT.obj  : $(SRCPATH)\UTCMLUT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\UTGNGLUT.obj : $(SRCPATH)\UTGNGLUT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\UTLMFCT.obj  : $(SRCPATH)\UTLMFCT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\WLEVEL.obj   : $(SRCPATH)\WLEVEL.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\WTSUM.obj    : $(SRCPATH)\WTSUM.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

