/*
    filename :  opdev.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifdef PHAR_LAP

#include <dos.h>
#include "i_head.h"
#include "imseries.h"
#include "i_dll.h"
#include "imgreg.h"
#include "imdrv.h"

#define  FBW0            1
#define  FBW1            2
#define  OVLW            3
#define  DISABLE_ALL_WINDOW  0xfffe    /* for: CloseHighMapWindow() */


/* GLOBALS */

extern  I_IMGLOB    i_glob;
extern  unsigned long base_address_table[15][4];


/*/     Function:   OpenHighFBWindow()
*       Synopsis:   open frame buffer window in high map
*
*       Date:       90.01.16
*
*       Parameter:  unsigned short window_sel : FBW0, FBW1 or OVLW
*                   unsigned long fb : ID of frame buffer to map at window
*
*                                         I_FB0
*                                         I_FB1
*                                         I_FB2
*                                         I_FB3
*                                         I_FB01
*                                         I_FB23
*                                         I_FB0123
*       Return value: 0 or -1 if error
**/


unsigned long OpenHighFBWindow(unsigned short window_sel,unsigned long fb)

{
unsigned long buf, base_address;

switch (fb)    /* convert frame ID to index for base_address_table[] */
   {
   case I_FB0:
   case I_FB01:
   case I_FB0123:
      fb = 0;
      break;

   case I_FB1:
   case I_FB23:
      fb = 1;
      break;

   case I_FB2:
      fb = 2;
      break;

   case I_FB3:
      fb = 3;
      break;
   
   default:
      return(-1);

   }


base_address = base_address_table[i_glob.vramhra->tappt & I_TAPPT_FBORG_MSK][fb];

switch (window_sel)
   {
   case FBW0:

      /* set WINDSEL register */
      buf = i_glob.vramhra -> winsel;
      buf |= (1L <<  (i_glob.high_map >> 20));

     i_glob.vramhra -> winsel = buf;

      /* set WINDID register */
      buf = i_glob.vramhra -> windid;
      buf &= ~(3L << ((i_glob.high_map >> 20) <<1)); /* Nian nian ... */
      
     i_glob.vramhra -> windid = buf;

      /* set FBW0P register */
     i_glob.vramhra -> fbw0p= i_glob.high_map >> 20;

      /* set FBW0BA register */
      i_glob.vramhra -> fbw0ba= base_address >> 23;
      ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> fbw0ba));

      break;

   case FBW1:

      /* set WINDSEL register */
      buf = i_glob.vramhra -> winsel;
      buf |= (1L <<  (i_glob.high_map >> 20));

     i_glob.vramhra -> winsel = buf;

      /* set WINDID register */
      buf = i_glob.vramhra -> windid;

      buf &= ~(2L << ((i_glob.high_map >> 20) <<1));
      buf |= 1L << ((i_glob.high_map >> 20) <<1);
      /* Nian nian ... */

     i_glob.vramhra -> windid = buf;

      /* set FBW1P register */
     i_glob.vramhra -> fbw1p= i_glob.high_map >> 20;

      /* set FBW1BA register */
      i_glob.vramhra -> fbw1ba= base_address >> 23;
      ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> fbw1ba));

      break;

   case OVLW: 

      /* set WINDSEL register */
      buf = i_glob.vramhra -> winsel;
      buf |= (1L <<  (i_glob.high_map >> 20));

      /* set WINDID register */
      buf = i_glob.vramhra -> windid;


      buf &= ~(1L << ((i_glob.high_map >> 20) <<1));
      buf |= 2L << ((i_glob.high_map >> 20) <<1);
      /* Nian nian ... */

     i_glob.vramhra -> windid = buf;

      /* set OBWPBA register */

      buf = i_glob.high_map >> 20;

      buf += (base_address >> (23 - 4)) & 0x1f0;

      i_glob.vramhra -> obwpda= buf; /* changed obwpba to obwpda */
      ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> obwpda));

      break;

   }

return (0L);
}



/***********************************************************************/
/*/ 
* Function name:  CloseHighMapWindow()
*/


unsigned long   CloseHighMapWindow(unsigned short window_sel)

{
unsigned short  buf;


   /* set WINDSEL register */
   buf = i_glob.vramhra -> winsel;
   buf &= ~window_sel;
   i_glob.vramhra -> winsel = buf;

return (0L);
}

/*****************************************************************************
*
*       Function: AllocSegment()
*       Synopsis: Allocate a segment and map physical memory
*                 specified onto it.
*       Date: 91.01.17
*
*       parameters: unsigned long PhysicalAddress
*
*                       Physical base address of segment. Must be
*                       a multiple of 4K. If not, it will
*                       be converted down to the next lowest
*                       multiple of 4K.
*
*                   unsigned long size
*
*                       Number of 4K blocks to allocate.
*
*       return value: 0 if error
*                     _far base pointer of allocated segment
*
*****************************************************************************/


_far unsigned long *AllocSegment(unsigned long PhysicalAddress,
                                                      unsigned long size)

{
union REGS regs;
struct SREGS sregs;
unsigned long SegmentSelector;
_far unsigned long *phar_ptr;
struct overlay
   {
   int off;
   short seg;
   };


/* allocate a new segment and obtain its selector */
regs.h.ah = 0x48;
regs.x.bx = 0L;  /* allocate 0 pages */

intdos(&regs,&regs); /* call INT21 function 48H */

if (regs.x.cflag) /* if error */
   {
   puts("ERROR : Could not allocate segment for physical map of device\n");
   if (regs.x.ax == 8)
      puts("        Insufficient memory or LDT is maximum size\n");
   printf("        Number of free pages of memory available: %08lXH\n",
                                                                  regs.x.bx);
   return(0);
   }

else
   SegmentSelector = regs.x.ax;

/* map physical memory to new segment */

regs.x.ax = 0x250A;              /* subtract any remainder */
regs.x.bx = PhysicalAddress - (unsigned long)PhysicalAddress%0x1000;
regs.x.cx = size;
sregs.es = SegmentSelector;

int86x(0x21,&regs,&regs,&sregs);

((struct overlay *)&phar_ptr) -> seg = SegmentSelector;
((struct overlay *)&phar_ptr) -> off = 0;

return(phar_ptr);
}


#endif /* PHAR_LAP */
