// FMSETREG.C
// This program first initializes the FM Synthesizer chip, then
// uses the fmSetRegister() function to set the chip wave select. 
// It then uninitializes the chip.

#include <stdlib.h>
#include "cvxfmsy.h"

VOID main( VOID ) 
{
   _FM_INIT_DATA   fmInitData;    // Initialization structure

   // Set the port to port A( 338h )
   fmInitData.port = _FM_PORT_A;

   // Initialize the FM libraries
   if( fmInit( ( _FM_INIT_DATA * )&fmInitData ) )
   { 
      // Turn off the wave select. This will cause the 
      // voices to default to sine wave.
      fmSetRegister( _TEST, _WAVE_SELECT_ON );

      // Uninitialize the FM system
      if( fmUninit() )
         printf( "ERROR : fmUninit() not successful.\n" );
   }
   else
      printf( "ERROR : fmInit() not successful.\n" );
} 




