//	The following line denies outside code access to certain
//	member functions of class vga.
#define __s3_h
#include "vga.h"

//	s3.h
//
//	Contains class definitions for S3 Vision86x & TrioXX video boards
//
//	requires reference to "vga.h"

class _S3 : public vga	{
protected:
	int sdac;	//	boolean variable, SDAC present?
	double _PLL( uchar M, uchar N, uchar R ); //	Calculate MCLK frequency
	void mclk_help( void );	//	Puts help message in msg.temp
	message _ramtype( uchar mask );
		// Returns RAM information (EDO/RAM), depending on mask's bit
		// settings
public:
	_S3( vga_info info );
	void _mclk( int cmd );	//	MCLK for SDAC only!
	void _fxn1( int cmd );	//	Write Wait State Control, enable fast/WR
	void _fxn2( int cmd );	//   Decode Wait Control (local-bus)
	void _fxn3( int cmd );	//   Read wait control
	void _fxn4( int cmd );	//	Read ahead cache
//	void _fxn5( int cmd );
};


class _805i : public _S3	{
protected:
public:
	_805i( vga_info info ) : _S3( info )
		{;};	//	Null constructor
	void _fxn5( int cmd );	//	Enable memory interleaving
};


class _864 : public _S3 {
protected:
public:
	_864( vga_info info ) : _S3( info )
		{;};	//	Null constructor
	message _info( void );	//	S3 misc/setup information (EDO/RAM?)
	void _fxn1( int cmd );	//	Write Wait State Control
	void _fxn2( int cmd );	//	Enable Fast Write Buffer (local-bus)
	void _fxn3( int cmd );	//	Write latching delay (VL-BUS only)
	void _fxn4( int cmd );	//	RAS' precharge timing control
	void _fxn5( int cmd );	//	RAS' low timing cntrol
};


class _868 : public _864 {
protected:
public:
	message _info( void );	//	S3-868 setup information (EDO/RAM?)
	_868( vga_info info ) : _864( info )
		{;};	//	Null constructor
};


class _964 : public _864 {
protected:
public:
	message _info( void );	//	S3-964 misc information (EDO/RAM?)
	void _fxn1( int cmd );	//	Write Wait State Control & SAM
	_964( vga_info info ) : _864( info )
		{;};	//	Null constructor
};


class _968 : public _964 {	//	Will add some more features later...
protected:
public:
	message _info( void );	//	S3-968 misc/setup info (EDO/burst RAM)
	_968( vga_info info ) : _964( info )
		{;};	//	Null constructor
};



class _Trio : public _864	{
protected:
	void read_PLL( uchar &M, uchar &N, uchar &R); //	Read PLL registers
public:
	_Trio( vga_info info ) : _864( info )
		{ };	//	constructor
	void _fxn3( int cmd );	//	RAS' timing control
	void _fxn4( int cmd );	//	3MCLK/2MCLK memory writes, v0.84
	void _fxn5( int cmd )	//	nothing, for now
		{
			strcpy(msg.text,"5  function NOT available\n");
		};
	void _mclk( int cmd );	//	Trio MCLK programming

};


class _Triov : public _Trio	{
public:
	message _info( void );	//	Trio64V setup information (EDO/RAM?)
	_Triov( vga_info info ) : _Trio( info )
		{ };	//	constructor
};


class _Virge : public _Triov	{
public:
	message _info( void );	//	Virge setup information (no FPM DRAM)
	_Virge( vga_info info ) : _Triov( info )
		{ };	//	constructor
};


class _VirgeVX : public _Virge	{
public:
//	message _info( void );	//	VirgeVX info...no RAM detection yet
	_VirgeVX( vga_info info ) : _Virge( info )
		{ };	//	constructor
	void _mclk( int cmd );	//	Virge MCLK programming
};
