/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Module      @CH375  **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* Uļдģ, ӷʽ: ģSPIʱ+ѯ */
/* MCS-51ƬCʾ */
/* ΪʹUļдģʹUļӳ,ռýٵĵƬԴ,ʹ89C51Ƭ */

#pragma	NOAREGS
#include <reg51.h>
#include <absacc.h>
#include <string.h>
#include <stdio.h>

#define MAX_PATH_LEN			32		/* ·,бָܷСԼ·00H,CH375ģֵֵ֧64,Сֵ13 */
#include "..\CH375HM.H"

/* ·ӷʽ,4+1SPI,SCSɹSPI
   Ƭ    ģ
    P1.0  =  SDI
    P1.1  =  SDO
    P1.2  =  SCK
    P1.3  =  SCS
    INT0  =  INT#  ȻӵINT0,ǱֻǲѯģINT#״̬,ԿP1ڵͨI/OŴINT0
*/
sbit	P10					=	P1^0;
sbit	P11					=	P1^1;
sbit	P12					=	P1^2;
sbit	P13					=	P1^3;
#define	CH375HM_SPI_SDI			P10		/* ٶCH375ģSDIӵƬP10 */
#define	CH375HM_SPI_SDO			P11		/* ٶCH375ģSDOӵƬP11 */
#define	CH375HM_SPI_SCK			P12		/* ٶCH375ģSCKӵƬP12 */
#define	CH375HM_SPI_SCS			P13		/* ٶCH375ģSCSӵƬP13 */
#define CH375HM_INT_WIRE		INT0	/* ٶCH375ģINT#ӵƬINT0 */

/* ٶļݻ: ExtRAM: 0000H-7FFFH */
unsigned char xdata DATA_BUF[ 512 * 32 ] _at_ 0x0000;	/* ⲿRAMļݻ,ӸõԪʼĻȲСһζдݳ,Ϊ512ֽ */

unsigned char xdata *buffer;			/* ݻָ,ڶдݿ */

CMD_PARAM		mCmdParam;				/* Ĭ¸ýṹռ64ֽڵRAM,޸MAX_PATH_LEN,޸Ϊ32ʱ,ֻռ32ֽڵRAM */

sbit	LED_OUT		=	P1^4;			/* P1.4 ͵ƽLEDʾ,ڼʾĽ */

/* ԺΪλʱ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* һֽݸCH375ģ,ͬʱһֽ,SPIģʽ0ʽ(SPI_SCKĬΪ0) */
unsigned char	mSpiExchange( unsigned char c )
{
	unsigned char	i, d;
	d = 0;
	CH375HM_SPI_SCK = 0;
	for ( i = 8; i != 0; i -- ) {  /* 8λ */
		if ( c & 0x80 ) CH375HM_SPI_SDI = 1;  /* ģSDI */
		else CH375HM_SPI_SDI = 0;
		d <<= 1;
		if ( CH375HM_SPI_SDO ) d ++;  /* ģSDOΪߵƽλ1 */
		CH375HM_SPI_SCK = 1;  /* SPIʱأģݲ */
		c <<= 1;
		CH375HM_SPI_SCK = 0;
	}
/* ƬϿʹmSpiExchangeӳִʱ10uSǴ1MHzӲSPIӿڣô˴Ӧüʱȷӳڴ10uS */
/* ģ鵥ƬΪ18.432MHzģ鵥ƬƵʼӱôʱҪӦüһ */
/* ͨMCS51ƬģSPIӿڽκʱ */
	return( d );
}

#if 0
/* һֽݸCH375ģ,ͬʱһֽ,SPIģʽ3ʽ(SPI_SCKĬΪ1) */
unsigned char	mSpiExchange3( unsigned char c )
{
	unsigned char	i, d;
	d = 0;
	for ( i = 8; i != 0; i -- ) {   /* 8λ */
		CH375HM_SPI_SCK = 0;
		if ( c & 0x80 ) CH375HM_SPI_SDI = 1;  /* ģSDI */
		else CH375HM_SPI_SDI = 0;
		d <<= 1;
		if ( CH375HM_SPI_SDO ) d ++;  /* ģSDOΪߵƽλ1 */
		CH375HM_SPI_SCK = 1;  /* SPIʱأģݲ */
		c <<= 1;
	}
/* ʱҪͬmSpiExchangeӳSPIģʽ0 */
	return( d );
}
#endif

/* ִ */
unsigned char	ExecCommand( unsigned char cmd, unsigned char len )
/* ,ز״̬,ͷزCMD_PARAMṹ */
{
	unsigned char		i, j, status;
	CH375HM_SPI_SCS = 0;  /* SPIƬѡ */
	mSpiExchange( cmd );  /* д */
	mSpiExchange( len );  /* дĳ */
	if ( len ) {  /* в */
		for ( i = 0; i != len; i ++ ) mSpiExchange( mCmdParam.Other.mBuffer[ i ] );  /* д */
	}
	CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
	while ( 1 ) {  /* ݴ,ֱɲ˳ */
		while ( CH375HM_INT_WIRE );  /* ȴģɲ͵ƽж,ѼⷽʽǶģINT#źŽ½رؼ */
		CH375HM_SPI_SCS = 0;  /* SPIƬѡ */
		status = mSpiExchange( 0xFF );  /* д0xFFΪЧ(Ӧдֵ),ģ״̬ */
#if 0
/* δINT#ţȥwhile ( CH375HM_INT_WIRE )ôʹSPIƵѯ */
		if ( status == 0xFF ) {  /* ģδ,ҲINT#ûжϲ */
			CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
			mDelaymS( 1 );
			continue;  /* ȴģɲ */
		}
#endif
		if ( status == ERR_SUCCESS ) {  /* ɹ */
			i = mSpiExchange( 0 );  /* ؽݵĳ,д0û,κֵ */
			if ( i ) {  /* н */
				j = 0;
				do {  /* ʹdo+whileṹΪЧʸfor */
					mCmdParam.Other.mBuffer[ j ] = mSpiExchange( 0 );  /* սݲ浽ṹ,д0û */
					j ++;
				} while ( -- i );
			}
			CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
			break;  /* ɹ */
		}
		else if ( status == USB_INT_DISK_READ ) {  /* ڴU̶ݿ,ݶ */
			i = 64;
			do {
				*buffer = mSpiExchange( 0 );  /* ν64ֽڵ */
				buffer ++;  /* յݱ浽ⲿ */
			} while ( -- i );
		}
		else if ( status == USB_INT_DISK_WRITE ) {  /* Uдݿ,д */
			i = 64;
			do {
				mSpiExchange( *buffer );  /* η64ֽڵ */
				buffer ++;  /* ͵ⲿ */
			} while ( -- i );
		}
		else if ( status == USB_INT_DISK_RETRY ) {  /* дݿʧ,Ӧ޸Ļָ */
			i = mSpiExchange( 0 );  /* ģʽΪظָֽĸ8λ,Сģʽôյǻظָֽĵ8λ */
			status = mSpiExchange( 0 );  /* ģʽΪظָֽĵ8λ,Сģʽôյǻظָֽĸ8λ */
			buffer -= ( (unsigned short)i << 8 ) + status;  /* ǴģʽµĻظָ,Сģʽ,Ӧ( (unsigned short)status << 8 ) + i */
		}
		else {  /* ʧ */
			CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
			if ( status == ERR_DISK_DISCON || status == ERR_USB_CONNECT ) mDelaymS( 100 );  /* U̸ոӻ߶Ͽ,Ӧʱʮٲ */
			break;  /* ʧܷ */
		}
		CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
	}
	return( status );
}

#if 0
/* CH375ģжϷ,ʹüĴ1,Ϊ½ж */
/* U̲֪ͨôڼģжϣжϷ֪U̲¼
   ִExecCommandǰȲѯǷжϣûرģжϣִɺڳʱж */
#define CH375HM_INT_NO			0		/* CH375жϺ */
unsigned char	IntStatus;
void	CH375HMInterrupt( ) interrupt CH375HM_INT_NO using 1
{
	CH375HM_SPI_SCS = 0;  /* SPIƬѡ */
	IntStatus = mSpiExchange( 0xFF );  /* д0xFFΪЧ(Ӧдֵ),ģ״̬ */
	CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
}
#endif

/* ״̬,ʾ벢ͣ,Ӧ滻ΪʵʵĴʩ */
void	mStopIfError( unsigned char iError )
{
	unsigned char	led;
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X\n", (unsigned short)iError );  /* ʾ */
	led=0;
	while ( 1 ) {
		LED_OUT = led&1;  /* LED˸ */
		mDelaymS( 100 );
		led^=1;
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

main( ) {
	unsigned char	i, c, SecCount;
	unsigned long	OldSize;
	unsigned short	NewSize, count;
	LED_OUT = 0;  /* LEDһʾ */
	mDelaymS( 250 );  /* ʱ500,CH375ģϵҪ500ҵĸλʱ */
	mDelaymS( 250 );
	LED_OUT = 1;
	mInitSTDIO( );
	printf( "Start\n" );
	while ( 1 ) {  /* ѭ */
		printf( "Wait\n" );
		while ( 1 ) {  /* ʹòѯʽUǷ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus >= DISK_CONNECT ) break;  /* UѾ */
			mDelaymS( 100 );  /* ڴдUʱٲѯ,ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */
		LED_OUT = 0;  /* LED */
/* UǷ׼,U̲Ҫһ,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 5; i ++ ) {
			mDelaymS( 100 );
			printf( "Ready ?\n" );
			if ( ExecCommand( CMD_DiskReady, 0 ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
/* ȡԭļ */
		printf( "Open\n" );
		memcpy( mCmdParam.Open.mPathName, "\\C51\\CH375HFT.C", MAX_PATH_LEN );  /* ļ,ļC51Ŀ¼ */
		i = ExecCommand( CMD_FileOpen, MAX_PATH_LEN );  /* ļ,Ϊֵ,ʡټ */
		if ( i == ERR_MISS_DIR || i == ERR_MISS_FILE ) {  /* ERR_MISS_DIR˵ûҵC51Ŀ¼,ERR_MISS_FILE˵ûҵļ */
/* гĿ¼µļ */
			printf( "List file \\*\n" );
			for ( c = 0; c < 255; c ++ ) {  /* ǰ255ļ */
/*				memcpy( mCmdParam.Enumer.mPathName, "\\C51\\CH375*", MAX_PATH_LEN );*/  /* C51Ŀ¼CH375ͷļ,*Ϊͨ */
				memcpy( mCmdParam.Enumer.mPathName, "\\*", MAX_PATH_LEN );  /* ļ,*Ϊͨ,ļĿ¼ */
/*				i = strlen( mCmdParam.Enumer.mPathName );*/  /* ļĳ */
				for ( i = 0; i < MAX_PATH_LEN - 1; i ++ ) if ( mCmdParam.Enumer.mPathName[ i ] == 0 ) break;  /* ָļĽ */
				mCmdParam.Enumer.mPathName[ i ] = c;  /* 滻Ϊ,0255 */
				i = ExecCommand( CMD_FileEnumer, i+1 );  /* öļ,ļкͨ*,Ϊļ,ĳȺܺü */
				if ( i == ERR_MISS_FILE ) break;  /* Ҳƥļ,Ѿûƥļ */
				if ( i == ERR_SUCCESS || i == ERR_FOUND_NAME ) {  /* ͨƥļ,ļ· */
					printf( "  match file %03d#: %s\n", (unsigned int)c, mCmdParam.Enumer.mPathName );  /* ʾźƥļĿ¼ */
					continue;  /* һƥļ,´ʱŻ1 */
				}
				else {  /*  */
					mStopIfError( i );
					break;
				}
			}
			strcpy( DATA_BUF, "Note: \nԭǴ㽫/C51/CH375HFT.CļеСдĸתɴддµļ,Ҳļ\n" );
			OldSize = 0;
			NewSize = strlen( DATA_BUF );  /* ļĳ */
			SecCount = ( NewSize + 511 ) >> 9;  /* (NewSize+511)/512, ļ,ΪдΪλ */
		}
		else {  /* ҵļ\C51\CH375HFT.C߳ */
			mStopIfError( i );
			printf( "Query\n" );
			i = ExecCommand( CMD_FileQuery, 0 );  /* ѯǰļϢ,û */
			mStopIfError( i );
			printf( "Read\n" );
			OldSize = mCmdParam.Modify.mFileSize;  /* ԭļĳ */
			if ( OldSize > (unsigned long)(64*512) ) {  /* ʾõ62256ֻ32Kֽ */
				SecCount = 64;  /* ʾõ62256ֻ32Kֽ,ֻȡ64,Ҳǲ32768ֽ */
				NewSize = 64*512;  /* RAMƳ */
			}
			else {  /* ԭļС,ôʹԭ */
				SecCount = ( OldSize + 511 ) >> 9;  /* (OldSize+511)/512, ļ,ΪдΪλ */
				NewSize = (unsigned short)OldSize;  /* ԭ */
			}
			printf( "Size=%ld, Len=%d, Sec=%d\n", OldSize, NewSize, (unsigned short)SecCount );
			mCmdParam.Read.mSectorCount = SecCount;  /* ȡȫ,60ֻȡ60 */
			buffer = & DATA_BUF;  /* ݵĻʼַ,CH375ģжϷ */
			i = ExecCommand( CMD_FileRead, 1 );  /* ļȡ */
			mStopIfError( i );
/*
			ļȽϴ,һζ,CMD_FileReadȡ,ļָԶƶ
			while ( ʣδ ) {
				mCmdParam.Read.mSectorCount = 32;
				ExecCommand( CMD_FileRead, 1 );   ļָԶ
				TotalLength += 32*512;  ۼļܳ
			}

		    ϣָλÿʼд,ƶļָ
			mCmdParam.Locate.mSectorOffset = 3;  ļǰ3ʼд
			i = ExecCommand( CMD_FileLocate, 4 );  ĳ4sizeof( mCmdParam.Locate.mSectorOffset )
			mCmdParam.Read.mSectorCount = 10;
			ExecCommand( CMD_FileRead, 1 );   ֱӶȡļĵ(512*3)ֽڿʼ,ǰ3

			ϣӵԭļβ,ƶļָ
			i = ExecCommand( CMD_FileOpen, (unsigned char)( strlen( mCmdParam.Open.mPathName ) + 1 ) );
			mCmdParam.Locate.mSectorOffset = 0xffffffff;  Ƶļβ,Ϊλ,ԭļ3ֽ,512ֽڿʼ
			i = ExecCommand( CMD_FileLocate, sizeof( mCmdParam.Locate.mSectorOffset ) );
			mCmdParam.Write.mSectorCount = 10;
			ExecCommand( CMD_FileWrite, 1 );   ԭļĺ
*/
			printf( "Close\n" );
			mCmdParam.Close.mUpdateLen = 0;
			i = ExecCommand( CMD_FileClose, 1 );  /* رļ */
			mStopIfError( i );

/*			i = DATA_BUF[200];*/
/*			DATA_BUF[200] = 0;  ַ־,ʾ200ַ */
/*			printf( "Line 1: %s\n", DATA_BUF );*/
/*			DATA_BUF[200] = i;  ָԭַ */
			for ( count=0; count < NewSize; count ++ ) {  /* ļеСдַתΪд */
				c = DATA_BUF[ count ];
				if ( c >= 'a' && c <= 'z' ) DATA_BUF[ count ] = c - ( 'a' - 'A' );
			}
		}
/* ļ */
		printf( "Create\n" );
/*		memcpy( mCmdParam.Create.mPathName, "\\NEWFILE.TXT", MAX_PATH_LEN );*/
		memcpy( mCmdParam.Create.mPathName, "\\˫Ұ.TXT", MAX_PATH_LEN );  /* ļ,ڸĿ¼ */
		i = ExecCommand( CMD_FileCreate, MAX_PATH_LEN );  /* ½ļ,ļѾɾ½ */
		mStopIfError( i );
		printf( "Write\n" );
		mCmdParam.Write.mSectorCount = 0x1;  /* дһ512ֽ */
		buffer = & DATA_BUF;  /* ݵĻʼַ,CH375ģжϷд */
		i = ExecCommand( CMD_FileWrite, 1 );  /* ļд */
		mStopIfError( i );
		if ( SecCount > 1 ) {  /* Ϊݲ255,ܹһд,Ϊʾ,д */
			mCmdParam.Write.mSectorCount = SecCount - 1;
/*	buffer = & DATA_BUF + 512;  Ÿղŵд,ûʼַ */
			i = ExecCommand( CMD_FileWrite, 1 );  /* ļд */
			mStopIfError( i );
		}
		printf( "Modify\n" );
		mCmdParam.Modify.mFileAttr = 0xff;  /* : µļ,Ϊ0FFH޸ */
		mCmdParam.Modify.mFileTime = 0xffff;  /* : µļʱ,Ϊ0FFFFH޸,ʹ½ļĬʱ */
		mCmdParam.Modify.mFileDate = ( (2004-1980)<<9 ) + ( 5<<5 ) + 18;  /* : µļ: 2004.05.18 */
		mCmdParam.Modify.mFileSize = NewSize;  /* : ԭļС,ôµļԭļһ,RAM */
		i = ExecCommand( CMD_FileModify, 4+2+2+1 );  /* ޸ĵǰļϢ,޸ںͳ,Ϊsizeof(mCmdParam.Modify.mFileSize)+... */
		mStopIfError( i );
		printf( "Close\n" );
		mCmdParam.Close.mUpdateLen = 0;  /* ҪԶļ,Զ,ôó512ı */
		i = ExecCommand( CMD_FileClose, 1 );
		mStopIfError( i );

/* ɾĳļ */
		printf( "Erase\n" );
		memcpy( mCmdParam.Create.mPathName, "\\OLD", MAX_PATH_LEN );  /* ɾļ,ڸĿ¼ */
		i = ExecCommand( CMD_FileErase, MAX_PATH_LEN );  /* ɾļر */
/*		mStopIfError( i );*/

/* ѯϢ */
/*		printf( "Disk\n" );
		i = ExecCommand( CMD_DiskQuery, 0 );
		mStopIfError( i );
		i = mCmdParam.Query.mDiskFat;
		if ( i == 1 ) i = 12;
		else if ( i == 2 ) i = 16;
		else if ( i == 3 ) i = 32;
		printf( "FatCode=FAT%d, TotalSector=%ld, FreeSector=%ld\n", (unsigned short)i, mCmdParam.Query.mTotalSector, mCmdParam.Query.mFreeSector );*/
/* ȴU̶Ͽ */
		printf( "Take_out\n" );
		while ( 1 ) {  /* ʹòѯʽUǷϿ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus <= DISK_DISCONNECT ) break;  /* UѾϿ */
			mDelaymS( 100 );  /* ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		LED_OUT = 1;  /* LED */
	}
}
