// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"



XGLLINK void XGLCALL grTexDownloadTable(uint32 tmu, uint32 type, void *data) {
	vlog("Called grTexDownloadTable");

	int i;

	if (tmu) return;

	switch (type) {
	case XGLTEXTABLE_PALETTE:
		for (i=0; i<256; i++) {
			Voodoo.palette[i].peRed = uint8((((uint32 *)data)[i] >> 16) & 0xFF);
			Voodoo.palette[i].peGreen = uint8((((uint32 *)data)[i] >> 8) & 0xFF);
			Voodoo.palette[i].peBlue = uint8((((uint32 *)data)[i]) & 0xFF);
			Voodoo.palette[i].peFlags = 0;
		}
		break;
	case XGLTEXTABLE_NCC0:
		for (i=0; i<256; i++) {
			Voodoo.palette[i].peRed = 0;
			Voodoo.palette[i].peGreen = 0;
			Voodoo.palette[i].peBlue = 0;
			Voodoo.palette[i].peFlags = 0;
		}
//		log("Error: NCC textures not supported.\n");
		break;
	case XGLTEXTABLE_NCC1:
		for (i=0; i<256; i++) {
			Voodoo.palette[i].peRed = 0;
			Voodoo.palette[i].peGreen = 0;
			Voodoo.palette[i].peBlue = 0;
			Voodoo.palette[i].peFlags = 0;
		}
//		log("Error: NCC textures not supported.\n");
		break;
	}

	Voodoo.palnum++;

	// Force a texture reload to make sure the palette was assigned
	// May not be needed.
	_exebuffer->ForceTex(Voodoo.curtex);
}

XGLLINK void XGLCALL grTexNCCTable(uint32 tmu, uint32 table) {
	vlog("Called grTexNCCTable");

}




XGLLINK uint32 XGLCALL grTexCalcMemRequired(uint32 lodmin, uint32 lodmax, uint32 aspect, uint32 fmt) {
	vlog("Called grTexCalcMemRequired");

	return 1024;
}


XGLLINK uint32 XGLCALL grTexTextureMemRequired(uint32 mipmap, void *info) {
	vlog("Called grTexTextureMemRequired");

	return 1024;
}


XGLLINK void XGLCALL grTexDownloadMipMap(uint32 tmu, uint32 address, uint32 mipmap, XGLTexture *tex) {
	vlog("Called grTexDownloadMipMap");

	_texlist->AddTex(address, *tex);

}


XGLLINK void XGLCALL grTexDownloadMipMapLevel(uint32	tmu, 
											  uint32	address, 
											  uint32	curlod, 
											  uint32	largelod, 
											  uint32	aspect, 
											  uint32	format, 
											  uint32	mipmap, 
											  uchar		*data) {
	vlog("Called grTexDownloadMipMapLevel");

	XGLTexture tex;

	// Only top-level mipmaps supported currently
	if (curlod != largelod) return;

	tex.smalllod = curlod;
	tex.largelod = curlod;
	tex.aspect = aspect;
	tex.format = format;
	tex.data = data;

	_texlist->AddTex(address, tex);

}

XGLLINK void XGLCALL grTexDownloadMipMapLevelPartial(uint32		tmu,
													 uint32		address,
													 uint32		curlod,
													 uint32		largelod,
													 uint32		aspect,
													 uint32		format,
													 uint32		mipmap,
													 void		*data,
													 uint32		start,
													 uint32		end ) {
	vlog("Called grTexDownloadMipMapLevelPartial");

	log("  Error, unsupported function: grTexDownloadMipMapLevelPartial");

}

XGLLINK uint32 XGLCALL grTexMinAddress(uint32 tmu) {
	vlog("Called grTexMinAddress: tmu=" << tmu << "  address=" << 0);

	return 0;
}


XGLLINK uint32 XGLCALL grTexMaxAddress(uint32 tmu) {
	vlog("Called grTexMaxAddress: tmu=" << tmu << "  address=" << (MAX_TEXTURES-1));

	return (MAX_TEXTURES-1)*1024;
}


XGLLINK void XGLCALL grTexLodBiasValue(uint32 tmu, float bias) {
	vlog("Called grTexLocalBiasValue");
	vlog("  tmu=" << tmu);
	vlog("  bias=" << bias);

	log("  Error, unsupported function: grTexLodBiasValue");

}


XGLLINK void XGLCALL grTexClampMode(uint32 tmu, uint32 uclamp, uint32 vclamp) {
	vvlog("Called grTexClampMode");
	vvlog("  tmu=" << tmu);
	vvlog("  uclamp=" << uclamp);
	vvlog("  vclamp=" << vclamp);

	_exebuffer->SetAddressMode(
		uclamp == XGLTADDRESS_WRAP ? D3DTADDRESS_WRAP : D3DTADDRESS_CLAMP,
		vclamp == XGLTADDRESS_WRAP ? D3DTADDRESS_WRAP : D3DTADDRESS_CLAMP);



}

XGLLINK void XGLCALL guTexCombineFunction(uint32 tmu, uint32 func) {
	vlog("Called guTexCombineFunction");
	vlog("  tmu=" << tmu);
	vlog("  func=" << func);

	switch (func) {
	case XGLTEXCOMBINE_DECAL:    guColorCombineFunction(XGLCC_TEXTURE); break;
	default: log("  Error: unsupported guTexCombineFunction: " << func);
	}



//	log("  Error, unsupported function: guTexCombineFunction");

}

XGLLINK void XGLCALL grTexMipMapMode(uint32 tmu, uint32 temp1, uint32 temp2) {
	vvlog("Called grTexMipMapMode");
}


XGLLINK void XGLCALL grTexFilterMode(uint32 tmu, uint32 minfilter, uint32 magfilter) {
	vvlog("Called grTexFilterMode:");
	vvlog("  tmu=" << tmu);
	vvlog("  minfilter=" << minfilter);
	vvlog("  magfilter=" << magfilter);

	_exebuffer->Flush();

//	_exebuffer->SetTexFilterMode(

	switch(minfilter) {
	case XGLFILTER_NEAREST:
		DX.D3DD->SetTextureStageState(tmu, D3DTSS_MINFILTER, D3DTFG_POINT);
		break;
    case XGLFILTER_LINEAR:
		DX.D3DD->SetTextureStageState(tmu, D3DTSS_MINFILTER, D3DTFG_LINEAR);
		break;
	}

	switch(magfilter) {
	case XGLFILTER_NEAREST:
		DX.D3DD->SetTextureStageState(tmu, D3DTSS_MAGFILTER, D3DTFG_POINT);
		break;
    case XGLFILTER_LINEAR:
		DX.D3DD->SetTextureStageState(tmu, D3DTSS_MAGFILTER, D3DTFG_LINEAR);
		break;
	}
}

XGLLINK void XGLCALL grTexDetailControl(uint32 tmu, uint32 temp1, uint32 temp2, uint32 temp3) {
	log("  Error, unsupported function: grTexDetailControl");

}




XGLLINK void XGLCALL grTexSource(uint32 tmu, uint32 address, uint32 mipmap, XGLTexture *tex) {
	vvlog("Called grTexSource");

	_exebuffer->SetTex(_texlist->GetTex(address, *tex));
}


XGLLINK uint32 XGLCALL guTexAllocateMemory(uint32 tmu,
										   uint32 temp1,
										   uint32 temp2, 
										   uint32 temp3,
										   uint32 temp4,
										   uint32 temp5,
										   uint32 temp6, 
										   uint32 temp7,
										   uint32 temp8,
										   uint32 temp9,
										   uint32 temp10,
										   uint32 temp11,
										   uint32 temp12,
										   uint32 temp13,
										   uint32 temp14) {
	vlog("Called guTexAllocateMemory");

	log("  Error, unsupported function: guTexAllocateMemory");

	return 0;
}

XGLLINK void XGLCALL guTexDownloadMipMap(uint32 temp1, uint32 temp2, uint32 temp3) {
	vlog("Called guTexDownloadMipMap");

	log("  Error, unsupported function: guTexDownloadMipMap");

}

XGLLINK void XGLCALL guTexSource(uint32 tex) {
	vlog("Called guTexSource");

//	log("  Error, unsupported function guTexSource: tex=" << tex);

	// For compatibility with some games that specify a texture id of less than 0 to disable texturing
	if (*(int *)&tex < 0) _exebuffer->SetTex(0);
}


XGLLINK void XGLCALL grTexCombine(uint32 tmu,
								  uint32 color_func,
								  uint32 color_factor,
								  uint32 alpha_func,
								  uint32 alpha_factor,
								  uint32 color_invert,
								  uint32 alpha_invert) {

	vlog("Called grTexCombine: (" << tmu << ", " << color_func << ", " << color_factor << ", " << alpha_func << ", " << alpha_factor << ", " << color_invert << ", " << alpha_invert << ")");
	vlog("  Error, unsupported function grTexCombine");

	_exebuffer->Flush();

}


XGLLINK void XGLCALL grTexCombineFunction(uint32 tmu, uint32 func) {
	log("Called grTexCombineFunction: (" << tmu << ", " << func << ")");
	
}



