/* Create An Icon For the Auxiliary control program */
/* Dependencies:                                    */
/*     AUXCTL.EXE in Audiodd directory              */
/*     AUXCTL.ICO  in Audiodd directory             */
/*     RexxUtils Installed                          */

/* Load REXXUTIL */
/* The following lines are checking for the bootdrive           */
/* They also load the extended REXX libraries to enable      */
/* the creation of objects.                                               */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs      /* this line installs the REXX utils */
call sysloadfuncs                                                    /* along with this one                 */
os2driv=SysSearchPath('PATH','MINSTALL.EXE')
if (os2driv=' ') then os2drive='C'
   else os2drive = substr(os2driv,1,1)

parse source . . filename .                              /* gets the path of the addicon.cmd file        */
parse UPPER var filename  letter ':' .                   /* for ease of parsing we convert the string to upper */
                                                         /* case before wer parse it for the letter. */
parse UPPER var filename . ':' dirs '\ADDICON.CMD' .     /* gets the path w/o the drive and the \setup.cmd at the end */
drive=letter":"                                          /* gets the proper drive representation */
dirs=dirs"\TITLE.TXT"
titlepath=drive""dirs
titlewin=linein(drive'\TITLE.TXT',1,1)
result=SysDestroyObject("<AUX_CONTROL>")
classname='WPProgram'                                    /* Specifies what type is the new object */
title= titlewin                                          /*  This is the name that appears in Desktop */
location='<MWAVEFLDR>'                                   /* Object Id of the MWAVEOS2 Folder       */
setup='OBJECTID=<AUX_CONTROL>;'||,                       /*  Object Id for the Auxiliary control prog. */
      'EXENAME='OS2Drive':\MMOS2\MWAVE\AUXCTL.EXE;'||,   /*  The executable path              */
      'ICONFILE='OS2Drive':\MMOS2\MWAVE\AUXCTL.ICO;'||,  /*  The icon od the object            */
      'MINWIN=HIDE;'                                     /* minimize button hides object ctl esc to see */


Call BldObj                                              /* calls the build objects subroutine just in case of future */
                                                         /* executable programs.                               */

/**** Build Object ****/
BldObj:                                                  /* routine label   */

/* Build object using REPLACE as duplicateflag */

result = SysCreateObject(classname, title, location, setup, 'R')

/* the following returns control to the parent program  */
Return

