/***********************************************************/
/* LIBRARY 2.00 source code copyright (c) 1993 by M. Kimes */
/*                          all rights reserved            */
/* code may not be used without prior written permission   */
/***********************************************************/

#include "doorskel.h"
#include "library.h"

#ifdef OS2
  #define LIBEDITCMD "LIBEDIT.CMD"
  #define LIBUPCMD   "LIBUP.CMD"
#else
  #define LIBEDITCMD "LIBEDIT.BAT"
  #define LIBUPCMD   "LIBUP.BAT"
#endif


void _fastcall maintenance (void) {

  register int lines = 0;
  char         command;
  static char  s[10][80];
  static char  dostring[1001];
  char         newsect[33];
  char        *p;
  int          x,y,hDir;
  FILE        *infile;
  DOORFINDBUF  f;
  struct stat  st;

  for(;;) {
    strcpy(newsect,section[cursec]);
    DoorPrintGraphics(make_ansi(PC_LIGHTBLUE,PC_BLACK,NULL));
    DoorPrintf("\r\n\r\n  Maintenance ** Current: #%u",cursec + 1);
    DoorPrintGraphics(make_ansi(PC_YELLOW,PC_BLACK,NULL));
    DoorPrintf(" \"%s\"",newsect);
    DoorPrintGraphics(make_ansi(PC_LIGHTBLUE,PC_BLACK,NULL));
    DoorPrintf(" ** %01u documents",numfiles);
    if (*section[cursec] == '_') {
      DoorPrintGraphics(make_ansi(PC_DARKCYAN,PC_BLACK,NULL));
      DoorPuts("ANSI Graphics are required in this section.\r\n");
    }
    DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
    if(!menus)
      print_maint_menu();
    else
      DoorPuts("\r\n[A,B,C,D,E,F,H,J,K,L,M,N,P,Q,R,S,T,U,$,+,!,@,#,%,<>,?]");
    DoorPrintGraphics(make_ansi(PC_DARKCYAN,PC_BLACK,NULL));
    DoorPrintf("\r\n  %ld mins: ",DoorMinsLeft());
    DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));

    command = *DoorGenericInput(1,0,1,1,ALLL,NULL,NULL);
    DoorPuts("\r\n");
    switch (toupper(command)) {
      case '?':   if(menus) {
                    print_maint_menu();
                    break;
                  }
                  /* intentional fallthru */
      case 'H':   if((p = DoorSearchPath("LIBSUBOP.HLP")) != NULL)
                    DoorReadText(p,1);
                  else
                    DoorPuts("\r\nSorry, no help for maintenance available.\r\n");
                  break;
      case 'B':   if(numsecs == MAXSECTIONS) {
                    DoorPuts("\r\nNo room for another section.\r\n");
                    break;
                  }
                  strcpy(newsect,DoorGenericInput(32,0,0,0,FLE,
                                 "\r\nFilename for new section (no extension):\r\n -> ",
                                 NULL));
                  newsect[31] = 0;
                  if((p = strchr(newsect,'.')) != NULL)
                    *p = 0;
                  if(!newsect)
                    break;
                  sprintf(dostring,"%s /C ZOO a:I %s < %s > %s",
                          getenv("COMSPEC"),newsect,tmpin,tmpout);
                  goto DoIt1;
      case 'M':   sprintf(dostring,"%s /C ZOO a:PMI %s < %s > %s",
                          getenv("COMSPEC"),newsect,tmpin,tmpout);
                  goto DoIt1;
      case 'A':
                  sprintf(dostring,"%s /C ZOO a:PI %s < %s > %s",
                          getenv("COMSPEC"),newsect,tmpin,tmpout);
DoIt1:
                  DoorPuts("\r\nYou may specify up to 9 files to add.");
DoIt2:
                  DoorPuts("  [Enter] on a blank line when done.");
                  x = 0;
                  while(x < 10) {
Over:
                    DoorPrintf("\r\n%u: ",x + 1);
                    if(command == 'P' || command == 'C') {
                      strcpy(s[x],DoorGenericInput(75,0,0,0,ALLL,NULL,NULL));
                      DoorLStrip(s[x]);
                      DoorRStrip(s[x]);
                    }
                    else {
                      if(maint == 1 || command == 'D' || command == 'E')
                        strcpy(s[x],DoorGenericInput(32,0,0,0,FLEW,NULL,NULL));
                      else
                        strcpy(s[x],DoorGenericInput(75,0,0,0,FLEPW,NULL,NULL));
                      if(command == 'D' || command == 'E') {
                        if(atoi(s[x]) > 0 && atoi(s[x]) <= numfiles) {
                          for(y = 0;y < strlen(s[x]);y++)
                            DoorPuts(BACKSPACE);
                          strcpy(s[x],document[atoi(s[x]) - 1]);
                          DoorPuts(s[x]);
                        }
                        else if(*s[x]) {
                          if(strchr(s[x],'*') || strchr(s[x],'?')) {

                            word matched = 0;

                            for(y = 0;y < numfiles;y++) {
                              if(name_match(s[x],document[y])) {
                                DoorPrintf("\r\nMatches \"%s\"",document[y]);
                                matched++;
                              }
                            }
                            if(!matched) {
                              DoorPrintf("\r\n%s doesn't match any files in this section\r\n",
                                      s[x]);
                              continue;
                            }
                          }
                          else {

                            word matched = 0;

                            for(y = 0;y < numfiles;y++) {
                              if(!stricmp(s[x],document[y])) {
                                matched++;
                                break;
                              }
                            }
                            if(!matched) {
                              DoorPrintf("\r\n%s isn't a file in this section.\r\n",
                                      s[x]);
                              continue;
                            }
                          }
                        }
                      }
                    }
                    if(!*s[x])
                      break;
                    if(command == 'A' || command == 'M' || command == 'B') {
                      hDir = HDIR_CREATE;
                      if(!DoorFindFirst(&hDir,s[x],&f,FILE_ARCHIVED |
                         FILE_READONLY | FILE_NORMAL)) {
                        DoorPrintf("\r\nCan't find \"%s\".\r\n",s[x]);
                        continue;
                      }
                      do {
                        DoorPrintf("\r\nMatches %s (%ld bytes)",
                                f.achName,f.cbFile);
                        if(DoorStristr(f.achName,".ZOO") ||
                           DoorStristr(f.achName,".EXE") ||
                           DoorStristr(f.achName,".COM")) {
                          DoorPrintf("\r\nI don't think \"%s\" is gonna work...\r\n",
                                  s[x]);
                          goto Over;
                        }
                      } while(!DoorFindNext(hDir,&f));
                      DoorFindClose(hDir);
                    }
                    x++;
                  }
                  DoorPuts("\r\n");
                  if(!x || !*s[0])
                    break;
                  infile = DoorFsopen(tmpin,"wt",SH_DENYWR);
                  if(!infile) {
                    DoorPuts("\r\nCouldn't open input file\r\n");
                    break;
                  }
                  for(y = 0;y < x;y++) {
                    if(command != 'E' && command != 'D') {
                    if(command == 'A' || command == 'M' ||
                       command == 'B' && (strchr(s[y],'*') ||
                       strchr(s[y],'?'))) {
                      hDir = HDIR_CREATE;
                      if(DoorFindFirst(&hDir,s[y],&f,FILE_ARCHIVED |
                         FILE_READONLY | FILE_NORMAL)) {
                        continue;
                      }
                      p = strrchr(s[y],'\\');
                      if(!p)
                        p = strrchr(s[y],':');
                        if(p) {
                          p++;
                          *p = 0;
                        }       /* s[y] now == path to file */
                        do {
                          if(DoorStristr(f.achName,".ZOO") ||
                             DoorStristr(f.achName,".EXE") ||
                             DoorStristr(f.achName,".COM"))
                            continue;
                          fprintf(infile,"%s%s\n",s[y],f.achName);
                        } while(!DoorFindNext(hDir,&f));
                        DoorFindClose(hDir);
                      }
                      else
                        fprintf(infile,"%s\n",s[y]);
                    }
                    else {
                      strcat(dostring,s[y]);
                      strcat(dostring," ");
#ifndef OS2
                      if(strlen(dostring) >= 115) {
#else
                      if(strlen(dostring) >= 970) {
#endif
                        DoorPuts("\r\nCommand line overflow; not all files may be affected.\r\n");
                        break;
                      }
                    }
                  }
                  if(command == 'P' || command == 'C')
                    if(stricmp(s[x - 1],"/END"))
                      fprintf(infile,"/END\n");
                  fclose(infile);
                  if(command == 'E' || command == 'D') {
#ifndef OS2
                  dostring[114] = 0;
#else
                  dostring[969] = 0;
#endif
                  strcat(dostring," > ");
                  strcat(dostring,tmpout);
                }
                DoorPrintf("\r\n\"%s\"",dostring);
                DoorPuts("\r\n   Do it? (Y/n) ");
                  if(*DoorGenericInput(1,0,1,1,YESNO,NULL,NULL)=='N') {
                    remove(tmpin);
                    remove(tmpout);
                    DoorPuts("\r\n");
                    break;
                  }
                  DoorPuts("\r\nWorking...please wait.\r\n");
                  DoorSpawn(dostring);
                  if(DoorGetBaudVar())
                    DoorCheckCarrier();
                  remove(tmpin);
                  DoorReadText(tmpout,1);
                  remove(tmpout);
                  sprintf(dostring,"%s.BAK",newsect);
                  remove(dostring);
                  if(command == 'B') {
                    sprintf(dostring,"%s.ZOO",newsect);
                    if(!stat(dostring,&st)) {
                      section[numsecs] = strdup(newsect);
                      if(!section[numsecs])
                        break;
                      numsecs++;
                      cursec = numsecs - 1;
                      list_zoo(cursec,0,0,NULL);
                    }
                  }
                  if(command == 'D' || command == 'A' || command == 'M')
                    list_zoo(cursec,0,0,NULL);
                  break;
      case 'P':   sprintf(dostring,"%s /C ZOO cA %s < %s > %s",
                          getenv("COMSPEC"),newsect,tmpin,tmpout);
                  goto DoIt3;
      case 'C':   if(!quick)
                    quick_list();
                  strcpy(s[0],DoorGenericInput(32,0,0,0,FLE,
                              "\r\nFile Name or # on which to comment: ",
                              NULL));
                  if(!*s[0])
                    break;
                  if(atoi(s[0]) > 0 && atoi(s[0]) <= numfiles) {
                    for(x = 0;x < strlen(s[0]);x++)
                      DoorPuts(BACKSPACE);
                    strcpy(s[0],document[atoi(s[0]) - 1]);
                    DoorPuts(s[0]);
                  }
                  DoorPuts("\r\n");
                  sprintf(dostring,"%s /C ZOO c %s %s < %s > %s",
                          getenv("COMSPEC"),newsect,s[0],tmpin,tmpout);
DoIt3:
                  DoorPuts("\r\nYou may enter up to 9 comment lines.");
                  goto DoIt2;
      case 'D':   sprintf(dostring,"%s /C ZOO DP %s ",getenv("COMSPEC"),
                          newsect);
                  if(!quick)
                    quick_list();
                  DoorPuts("\r\nYou may enter up to 9 file names or #'s to delete.\r\n");
                  goto DoIt2;
      case 'E':   sprintf(dostring,"%s /C ZOO eOd %s ",getenv("COMSPEC"),
                          newsect);
                  if(!quick)
                    quick_list();
                  DoorPuts("\r\nYou may enter up to 9 file names or #'s to extract.");
                  goto DoIt2;
      case 'K':   if(maint == 1)
                    strcpy(s[0],DoorGenericInput(32,0,0,0,FLEW,
                                "\r\nFilename to remove?\r\n-> ",
                                NULL));
                  else
                    strcpy(s[0],DoorGenericInput(75,0,0,0,FLEPW,
                                "\r\nFilename to remove?\r\n-> ",
                                NULL));
                  DoorPuts("\r\n");
                  if(*s[0]) {
                    hDir = HDIR_CREATE;
                    if(DoorFindFirst(&hDir,s[0],&f,FILE_ARCHIVED |
                       FILE_READONLY | FILE_NORMAL))
                      DoorPrintf("%s not found.\r\n",s[0]);
                    else {
                      do {
                        DoorPrintf("\r\nMatches %s (%lu bytes)",
                                f.achName,f.cbFile);
                        if(DoorStristr(f.achName,".ZOO")) {
                          DoorPuts("\r\nUse [R]emove Section instead.\r\n");
                          goto Avoid;
                        }
                      } while(!DoorFindNext(hDir,&f));
                      DoorFindClose(hDir);
                    }
                    DoorPuts(" Do it? (Y/n) ");
                    if(*DoorGenericInput(1,0,1,1,YESNO,NULL,NULL)!='N') {
                      if(!remove(s[0]))
                        DoorPuts("File deleted.\r\n");
                      else
                        DoorPuts("File not deleted (didn't exist?)\r\n");
                    }
                  }
Avoid:
                  break;
      case 'L':   strcpy(s[0],DoorGenericInput(75,0,0,0,FBATCHW,
                              "\r\nArgument for list ([Enter]=all)\r\n-> ",
                              NULL));
                  sprintf(dostring,"%s /C ZOO VcCd/ %s %s > %s",
                          getenv("COMSPEC"),newsect,s[0],tmpout);
                  DoorPrintf("\r\n\"%s\"",dostring);
                  DoorPuts("\r\nGetting list...\r\n");
                  DoorSpawn(dostring);
                  if(DoorGetBaudVar())
                    DoorCheckCarrier();
                  DoorReadText(tmpout,1);
                  remove(tmpout);
                  break;
      case 'R':   DoorPrintf("\r\nRemove this section (%s)? (y/N) ",newsect);
                  if(*DoorGenericInput(1,0,1,1,YESNO,NULL,NULL) != 'Y')
                    break;
                  else {
                    sprintf(dostring,"%s.ZOO",newsect);
                    if(!remove(dostring)) {
                      DoorPuts("\r\nSection removed.\r\n");
                      if(cursec == (numsecs - 1)) {
                        free(section[cursec]);
                        cursec--;
                        numsecs--;
                      }
                      else {
                        free(section[cursec]);
                        for( x= cursec;x < (numsecs - 1);x++)
                          section[x] = section[x + 1];
                      }
                      list_zoo(cursec,0,0,NULL);
                    }
                    else
                      DoorPuts("\r\nError--not removed.\r\n");
                  }
                  break;
      case 'T':   sprintf(dostring,"%s /C ZOO -test %s >%s",
                          getenv("COMSPEC"),newsect,tmpout);
                  DoorPrintf("\r\n\"%s\"",dostring);
                  DoorPrintf("\r\nTesting %s...please wait.\r\n",newsect);
                  DoorSpawn(dostring);
                  if(DoorGetBaudVar())
                    DoorCheckCarrier();
                  DoorReadText(tmpout,1);
                  remove(tmpout);
                  break;
      case 'J':   common('J');
                  break;
      case 'N':   common('L');
                  break;
      case 'S':   common('S');
                  break;
      case '$':   if(maint < 2)
                    p = DoorGenericInput(32,0,0,0,FLEW,
                        "\r\nMask: [*.*]\r\n-> ",NULL);
                  else
                    p = DoorGenericInput(74,0,0,0,FLEPW,
                        "\r\nMask: [*.*]\r\n-> ",NULL);
                  if(!*p) {
                    p="*.*";
                    DoorPuts("*.*");
                  }
                  DoorPuts("\r\n");
                  hDir = HDIR_CREATE;
                  if(DoorFindFirst(&hDir,p,&f,FILE_ARCHIVED |
                     FILE_READONLY | FILE_NORMAL)) {
                    DoorPuts("\r\nNone matching.\r\n");
                    break;
                  }
                  lines = 1;
                  do {
                    DoorPrintf("%-32s  %02u/%02u/%02u  %02u:%02u:%02u  %7ld  [",
                            f.achName,(f.fdateLastWrite.year + 80) % 100,
                            f.fdateLastWrite.month,f.fdateLastWrite.day,
                            f.ftimeLastWrite.hours,f.ftimeLastWrite.minutes,
                            f.ftimeLastWrite.twosecs * 2,f.cbFile);
                    for(x = 0;x < 8;x++) {
                      y = 1;
                      y = y << x;
                      (f.attrFile & y) ? DoorPuts("X") : DoorPuts ("-");
                    }
                    DoorPuts("]\r\n");
                  } while(!DoorFindNext(hDir,&f));
                  DoorFindClose(hDir);
                  if (DoorGetLength())
                    if (lines > DoorGetLength() - 13)
                      DoorHitReturn();
                  break;
      case '!':   if(maint < 2)
                    p = DoorGenericInput(32,0,0,0,FLE,
                        "\r\nFile to read:\r\n-> ",
                        NULL);
                  else
                    p = DoorGenericInput(76,0,0,0,FLEP,
                        "\r\nFile to read:\r\n-> ",
                        NULL);
                  DoorPuts("\r\n");
                  if(!*p)
                    break;
                  if(DoorReadText(p,(grapharea == 0)) > 0) {
                    if(grapharea == 0) {
                      sprintf(dostring,"\x1b[%d;1H",DoorGetLength());
                      DoorModemPuts(dostring);
                      DoorANSIPrintf("\x1b[%d;1H",DoorGetMaxy());
                      if(!DoorInkey(60000L))
                        DoorHitReturn();
                    }
                  }
                  break;
      case '@':   common('R');
                  break;
      case 'U':
                  if(DoorGetBaudVar() && DoorSearchPath(LIBUPCMD)) {
                    p = DoorGenericInput(32,0,0,0,FLEW,
                        "\r\nFile to send: ",
                        NULL);
                    DoorPuts("\r\n");
                    if(!*p)
                      break;
                    sprintf(dostring,"%s /C %s %s %u %u",
                            getenv("COMSPEC"),DoorSearchPath(LIBUPCMD),p,
                            DoorGetBaudVar(),DoorGetCommHandle());
                    DoorPrintf("\r\n\"%s\"\r\n  Do it? (Y/n) ");
                    if(!*DoorGenericInput(1,0,1,1,YESNO,NULL,NULL) == 'N') {
                      DoorPuts("\r\n");
                      break;
                    }
                    else {
                      DoorPuts("\r\nEnter SEND mode...\r\n");
                      DoorSpawn(dostring);
                      if(DoorGetBaudVar())
                        DoorCheckCarrier();
                    }
                    break;
                  }
                  else {
                    if(!DoorSearchPath(LIBUPCMD))
                      DoorPrintf("\r\nNo upload batch file %s available.",LIBUPCMD);
                    if(!DoorGetBaudVar())
                      DoorPuts("\r\nYou're local; why upload?");
                    DoorPuts("\r\n");
                  }
                  break;
      case '#':   if(DoorSearchPath(LIBEDITCMD)) {
                    if(maint < 2)
                      p = DoorGenericInput(32,0,0,0,FLE,
                          "\r\nFile to edit:\r\n-> ",
                          NULL);
                    else
                      p = DoorGenericInput(76,0,0,0,FLEP,
                          "\r\nFile to edit:\r\n-> ",
                          NULL);
                    DoorPuts("\r\n");
                    if(!*p)
                      break;
                    sprintf(dostring,"%s /C %s %s %u %u",
                            getenv("COMSPEC"),LIBEDITCMD,p,DoorGetBaudVar(),DoorGetCommHandle());
                    DoorPrintf("\"%s\"\r\n  Do it? (Y/n) ");
                    if(*DoorGenericInput(1,0,1,1,YESNO,NULL,NULL) == 'N') {
                      DoorPuts("\r\n");
                      break;
                    }
                    else {
                      DoorPuts("\r\nLoading editor...\r\n");
                      DoorSpawn(dostring);
                      if(DoorGetBaudVar())
                        DoorCheckCarrier();
                    }
                    break;
                  }
                  else
                    DoorPrintf("\r\nNo edit batch file %s available.\r\n",LIBEDITCMD);
                  break;
        case '%': DoorPrintf("\r\n (%u docs) Trim to how many documents? ",
                          numfiles);
                  strcpy(s[0],DoorGenericInput(5,0,0,0,NUM,NULL,NULL));
                  DoorPuts("\r\n");
                  x = atoi(s[0]);
                  if(numfiles <= x || !x)
                    break;
                  if(*DoorGenericInput(1,0,1,1,YESNO,
                     "\r\nAre you sure? (Y/n) ",NULL) == 'N')
                    break;
                  trim_section(cursec,x);
                  quick_list();
                  break;
      case '+':   common('B');
                  break;
      case '*':   DoorPrintf("\r\nNew name for section \"%s\"? ",newsect);
                  strcpy(s[0],DoorGenericInput(9,0,0,0,FLE,NULL,NULL));
                  DoorPuts("\r\n");
                  if((p = strchr(s[0],'.')) != NULL)
                    *p = 0;
                  if(!*s[0])
                    break;
                  DoorPrintf("\r\nRename \"%s\" to \"%s\"? (Y/n) ",newsect,s[0]);
                  if(*DoorGenericInput(1,0,1,1,YESNO,NULL,NULL) != 'N') {
                    sprintf(s[1],"%s.ZOO",newsect);
                    sprintf(s[2],"%s.ZOO",s[0]);
                    if(rename(s[1],s[2]))
                      DoorPuts("\r\nRename failed.");
                    else
                      strcpy(section[cursec],s[0]);
                  }
                  DoorPuts("\r\n");
                  break;
      case '&':   if(maint == 1) {
                    DoorPuts("\r\nSecurity level not high enough.\r\n");
                    break;
                  }
                  p = DoorGenericInput(76,0,0,0,ALLL,
                      "\r\nEnter ZOO command line.  I'll prepend \'ZOO \' to it.\r\n-> ",
                      NULL);
                  DoorPuts("\r\n");
                  if(!*p)
                    break;
                  sprintf(dostring,"%s /C ZOO %s",getenv("COMSPEC"),p);
                  strcat(dostring," > ");
                  strcat(dostring,tmpout);
                  DoorPrintf("\r\n\"%s\"",dostring);
                  DoorPuts("\r\n   Do it? (Y/n) ");
                  if(*DoorGenericInput(1,0,1,1,YESNO,NULL,NULL) == 'N') {
                    remove(tmpout);
                    DoorPuts("\r\n");
                    break;
                  }
                  DoorPuts("\r\nWorking...please wait.\r\n");
                  DoorSpawn(dostring);
                  if(DoorGetBaudVar())
                    DoorCheckCarrier();
                  DoorReadText(tmpout,1);
                  remove(tmpout);
                  sprintf(dostring,"%s.BAK",newsect);
                  remove(dostring);
                  list_zoo(cursec,0,0,NULL);
                  break;
      case 'Q':   return;
      default:    if(!common(toupper(command))) {
                    DoorRemoteBell();
                    if (menus)
                      print_maint_menu();
                    break;
                  }
    }
  }
}



void _fastcall print_maint_menu (void) {

  if(maintmenu)
    DoorReadText("LIBMAINT.MNU",0);
  else {
    DoorPuts("\r\n[A]dd documents to section [B]uild a new section   [C]omment on document"
             "\r\n[D]elete documents         [E]xtract documents     [F]ull list toggles"
             "\r\n[J]ump to another section  [K]ill file(s)          [L]ist files"
             "\r\n[M]ove docs into section   [N]umbered list of docs [P]ut in section comment"
             "\r\n[Q]uit Maintenance         [R]emove a section      [S]ection listings"
             "\r\n[T]est section  [&]Zoo Cmd [U]pload file           [$]Directory"
             "\r\n[!]Read file  [+]Find Key  [@]Read document        [#]Edit file"
             "\r\n[%]Trim section to # docs  [*]Rename a section     [H]elp [?]Help/Full Menu");
  }
}



int _fastcall name_match (char *mask,char *name) { /* Handle wildcards */

  char *m,*n;

  n = name;
  m = mask;

  if(!*mask || !mask)
    return 1;

  while(*m) {
    if(*m == '?');
    else if (*m == '*') {
      if(strchr(n,'.')) {
        n = strchr(n,'.');
        if(strchr(m,'.'))
          m = strchr(m,'.');
        else
          return 0;
      }
      else if(!strchr(m,'.'))
        return 1;
      else
        return 0;
    }
    else if(toupper(*m) != toupper(*n))
      return 0;
    m++;
    n++;
  }
  return 1;
}


int _fastcall trim_section (word secnum,word howmany) {

  register word x;
  static char dostring[1001] = "";

  DoorPuts("\r\nTrimming section...please wait.\r\n");
  for(x = 0;x < (numfiles - howmany);x++) {
    sprintf(dostring,"%s.BAK",section[secnum]);
    remove(dostring);
    sprintf(dostring,"%s /C ZOO D %s %s",getenv("COMSPEC"),section[secnum],
            document[x]);
    DoorPrintf("\r\n\"%s\"\r\n",dostring);
    DoorSpawn(dostring);
  }
  if(*dostring) {
    sprintf(dostring,"%s /C ZOO PE %s",getenv("COMSPEC"),section[secnum]);
    DoorPrintf("\r\n\"%s\"\r\n",dostring);
    DoorSpawn(dostring);
  }
  if(DoorGetBaudVar())
    DoorCheckCarrier();
  DoorPuts("\r\n");
  list_zoo(secnum,0,0,NULL);
  return 0;
}
