#!/bin/sh
PATH=/sbin:/usr/sbin:/bin:/usr/bin
/sbin/swapon -a
/sbin/update &

# Test to see if the root partition is read-only, like it ought to be.
READWRITE=no
if echo -n >> "Testing filesystem status"; then
 rm -f "Testing filesystem status"
 READWRITE=yes
fi

# Check the integrity of all filesystems
if [ ! $READWRITE = yes ]; then
 /sbin/fsck -A -a
 # If there was a failure, drop into single-user mode.
 if [ $? -gt 1 ] ; then
  echo "**************************************"
  echo "fsck returned error code - REBOOT NOW!"
  echo "**************************************"
  /bin/login 
 fi
fi
 # Remount the root filesystem in read-write mode
 echo "Remounting root device with read-write enabled."
 /bin/mount -w -n -o remount /

/bin/rm -f /etc/mtab* /etc/nologin /etc/shutdownpid 

/bin/mount -avt nonfs

/bin/rm -f /var/run/utmp /var/run/*.pid
cat /dev/null > /var/run/utmp

# insmod psaux
# insmod lp io=0x378
# insmod 8390
# insmod ne io=0x320
# insmod slhc
# insmod ppp

