/*
 *    term.c  --  simple split mode terminal
 *
 *    
 *    Copyright (C) 2005 Gnther Montag, most of code taken from 
 *    MT63 code by Pawel Jalocha, SP9VRC, tnx!
 *
 *
 *    free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MT63; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <string.h>
#include <curses.h>
#include <stdarg.h>
#include "term.h"
#include "piano.h"

void Close(int err)
{ 
    if(Init) { 
	if (! err) erase(); 
	refresh(); endwin(); Init=0; 
    }
    exit (err); 
}

int Preset(int TxLines)
{
  if(Init) endwin();
  initscr(); cbreak(); noecho(); nonl(); //raw(); 
  nodelay(stdscr, TRUE);
  intrflush(stdscr,FALSE); keypad(stdscr,TRUE);
  scrollok(stdscr,TRUE);
  erase();

    if (has_colors())
    {
        start_color();
        init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_BLACK);
        init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_BLACK);
        init_pair(COLOR_RED, COLOR_RED, COLOR_BLACK);
        init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_BLACK);
        init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
        init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
        init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_BLACK);
        init_pair(COLOR_YELLOW, COLOR_YELLOW, COLOR_BLACK);
	init_pair(10,  COLOR_BLACK, COLOR_GREEN);
	init_pair(11,  COLOR_BLACK, COLOR_RED);
	init_pair(12,  COLOR_BLACK, COLOR_BLUE);
        init_pair(13,  COLOR_BLACK, COLOR_WHITE);
        init_pair(14,  COLOR_MAGENTA, COLOR_WHITE);
    }

  Init=1;

  Width=COLS; Height=LINES;
  TxLen=TxLines;
  if(TxLen==0) { RxLen=Height-TxLen-2; }
	  else { RxLen=Height-TxLen-4; }
  RxPos=1;
  TxPos=RxPos+RxLen+2;

  StatPos[0]=0;
  StatPos[1]=RxPos+RxLen;
  StatPos[2]=RxPos+RxLen+1;
  StatPos[3]=TxPos+TxLen;

  RxCurX=0; RxCurY=RxPos; RxAct=0;
  TxCurX=0; TxCurY=TxPos; TxAct=0;

  refresh();

  return 0;
}

void ChOut(char ch)
{ int x,y;
  if(ch=='\0') return;
  //attrset(A_NORMAL);
  if((ch&0x80)||(ch>=' ')||(ch==0x08)||(ch==0x09)) addch(ch);
  else if(ch=='\n') { getyx(stdscr,y,x); if(x>0) addch(ch); }
  else if(ch=='\r') { addch('\n'); }
  else { attrset(A_REVERSE); addch(ch+'@'); }
}

void RxOut(char ch)
{ if(!RxAct)
  { setscrreg(RxPos,RxPos+RxLen-1);
    move(RxCurY,RxCurX); RxAct=1; TxAct=0; }
  ChOut(ch); getyx(stdscr,RxCurY,RxCurX); refresh(); }

void RxStr(char *str)
{ if(!RxAct)
  { setscrreg(RxPos,RxPos+RxLen-1);
    move(RxCurY,RxCurX); RxAct=1; TxAct=0; }
  //attrset(A_NORMAL); 
  addstr(str);
  getyx(stdscr,RxCurY,RxCurX); refresh(); }

void TxOut(char ch)
{ if(!TxAct)
  { setscrreg(TxPos,TxPos+TxLen-1);
    move(TxCurY,TxCurX); TxAct=1; RxAct=0; }
  ChOut(ch); getyx(stdscr,TxCurY,TxCurX); refresh(); }

void TxStr(char *str)
{ if(!TxAct)
  { setscrreg(TxPos,TxPos+TxLen-1);
    move(TxCurY,TxCurX); TxAct=1; RxAct=0; }
  //attrset(A_NORMAL); 
  addstr(str);
  getyx(stdscr,TxCurY,TxCurX); refresh(); }

void Status(int Stat, char *Str)
{ int i,y=StatPos[Stat];
  RxAct=0; TxAct=0; move(y,0);
  //attrset(A_REVERSE);
  attrset(COLOR_PAIR(13));
  for(i=0; Str[i]; i++) addch(Str[i]);
  for(   ; i<Width-1; i++) addch(' ');
  attrset(A_NORMAL); 
  refresh(); }

void info(const char *fmt, ...)
{
	char info[2056];
        va_list args;

        memset(info, 0, sizeof(info));
        va_start(args, fmt);
        vsprintf(info, fmt, args );
        va_end(args);
	attrset(COLOR_PAIR(COLOR_YELLOW));
	TxStr(info);
	attrset(A_NORMAL);
}

void warninfo(const char *fmt, ...)
{
	char info[1024];
        va_list args;

	memset(info, 0, sizeof(info));
        va_start(args, fmt);
        vsprintf(info, fmt, args);
        va_end(args);
	attrset(COLOR_PAIR(COLOR_RED));
	TxStr(info);
	attrset(A_NORMAL);
}

void verbinfo(const char *fmt, ...)
{
	char info[1024];
        va_list args;

	if (! verboselevel) return;
	memset(info, 0, sizeof(info));
        va_start(args, fmt);
        vsprintf(info, fmt, args);
        va_end(args);
	attrset(COLOR_PAIR(COLOR_MAGENTA));
	TxStr(info);
	attrset(A_NORMAL);
}

void statusinfo(int statusline, const char *fmt, ...)
{
	char info[COLS];
	char string[COLS];
	char space [COLS];
        int i, border;
	va_list args;
	
	memset(info, 0, sizeof(info));
	memset(string, 0, sizeof(string));
	memset(space, 0, sizeof(string));

        va_start(args, fmt);
        vsprintf(string, fmt, args);
        va_end(args);
	border = COLS - strlen(string);
	if (border < 0) warninfo("info string too long.\n");
	for (i = 0; i < border/2; i++) {
	    space[i] = ' ';
	}
	sprintf(info, "%s%s", space, string);
	Status(statusline, info);
}
