<?xml version="1.0"?>


<!DOCTYPE overlay SYSTEM "chrome://global/locale/xml/prettyprint.dtd">

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="http://www.w3.org/1999/xhtml">

  <xsl:output method="xml"/>

  <xsl:template match="/">
    <link href="chrome://global/content/xml/XMLPrettyPrint.css" type="text/css" rel="stylesheet"/>
    <link title="Monospace" href="chrome://global/content/xml/XMLMonoPrint.css" type="text/css" rel="alternate stylesheet"/>
    <div id="header">
      <p>
        &xml.nostylesheet;
      </p>
    </div>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="*">
    <div class="indent">
      <span class="markup">&lt;</span>
      <span class="start-tag"><xsl:value-of select="name(.)"/></span>
      <xsl:apply-templates select="@*"/>
      <span class="markup">/&gt;</span>
    </div>
  </xsl:template>

  <xsl:template match="*[node()]">
    <div class="indent">
      <span class="markup">&lt;</span>
      <span class="start-tag"><xsl:value-of select="name(.)"/></span>
      <xsl:apply-templates select="@*"/>
      <span class="markup">&gt;</span>

      <span class="text"><xsl:value-of select="."/></span>

      <span class="markup">&lt;/</span>
      <span class="end-tag"><xsl:value-of select="name(.)"/></span>
      <span class="markup">&gt;</span>
    </div>
  </xsl:template>

  <xsl:template match="*[* or processing-instruction() or comment() or string-length(.) &gt; 50]">
    <table>
      <tr>
        <xsl:call-template name="expander"/>
        <td>
          <span class="markup">&lt;</span>
          <span class="start-tag"><xsl:value-of select="name(.)"/></span>
          <xsl:apply-templates select="@*"/>
          <span class="markup">&gt;</span>

          <div class="expander-content"><xsl:apply-templates/></div>

          <span class="markup">&lt;/</span>
          <span class="end-tag"><xsl:value-of select="name(.)"/></span>
          <span class="markup">&gt;</span>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="@*">
    <xsl:text> </xsl:text>
    <span class="attribute-name"><xsl:value-of select="name(.)"/></span>
    <span class="markup">=</span>
    <span class="attribute-value">"<xsl:value-of select="."/>"</span>
  </xsl:template>

  <xsl:template match="text()">
    <xsl:if test="normalize-space(.)">
      <div class="indent text"><xsl:value-of select="."/></div>
    </xsl:if>
  </xsl:template>

  <xsl:template match="processing-instruction()">
    <div class="indent pi">
      <xsl:text>&lt;?</xsl:text>
      <xsl:value-of select="name(.)"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="."/>
      <xsl:text>?&gt;</xsl:text>
    </div>
  </xsl:template>

  <xsl:template match="processing-instruction()[string-length(.) &gt; 50]">
    <table>
      <tr>
        <xsl:call-template name="expander"/>
        <td class="pi">
          &lt;?<xsl:value-of select="name(.)"/>
          <div class="indent expander-content"><xsl:value-of select="."/></div>
          <xsl:text>?&gt;</xsl:text>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="comment()">
    <div class="comment indent">
      <xsl:text>&lt;!--</xsl:text>
      <xsl:value-of select="."/>
      <xsl:text>--&gt;</xsl:text>
    </div>
  </xsl:template>

  <xsl:template match="comment()[string-length(.) &gt; 50]">
    <table>
      <tr>
        <xsl:call-template name="expander"/>
        <td class="comment">
          <xsl:text>&lt;!--</xsl:text>
          <div class="indent expander-content"><xsl:value-of select="."/></div>
          <xsl:text>--&gt;</xsl:text>
        </td>
      </tr>
    </table>
  </xsl:template>
  
  <xsl:template name="expander">
    <td class="expander">&#x2212;<div class="spacer"/></td>
  </xsl:template>

</xsl:stylesheet>
