/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
*/


const nsIDialogParamBlock = Components.interfaces.nsIDialogParamBlock;
const nsIPKIParamBlock    = Components.interfaces.nsIPKIParamBlock;
const nsIX509Cert         = Components.interfaces.nsIX509Cert;

var dialogParams;
var pkiParams;
var cert;

function onLoad()
{
  pkiParams    = window.arguments[0].QueryInterface(nsIPKIParamBlock);
  dialogParams = pkiParams.QueryInterface(nsIDialogParamBlock);

  var isupport = pkiParams.getISupportAtIndex(1);
  cert = isupport.QueryInterface(nsIX509Cert);

  var bundle = document.getElementById("newserver_bundle");

  var intro = bundle.getFormattedString(
    "newserver.intro", [cert.commonName]);

  var reason3 = bundle.getFormattedString(
    "newserver.reason3", [cert.commonName]);

  var question = bundle.getFormattedString(
    "newserver.question", [cert.commonName]);

  setText("intro", intro);
  setText("reason3", reason3);
  setText("question", question);
  
  // Focus the accept button explicitly, because the dialog onLoad handler
  // focuses the first focusable element in the dialog, which is the "View
  // Certificate" button.
  // Never explicitly focus buttons on OS X, as this breaks default focus
  // handling, outlined in dialog.xml
//@line 79 "/mnt/hda10/work/mozilla/security/manager/pki/resources/content/newserver.js"
  document.documentElement.getButton("accept").focus();
//@line 81 "/mnt/hda10/work/mozilla/security/manager/pki/resources/content/newserver.js"
}

function doOK()
{
  var selectedID = document.getElementById("whatnow").selectedItem.id;

  if (selectedID == "refuse") {
    dialogParams.SetInt(1,0);
  }
  else {
    dialogParams.SetInt(1,1);

    // 0 = accept perm, 1 = accept for this session
    var userchoice = 1;
    
    if (selectedID == "remember") {
      userchoice = 0;
    }

    dialogParams.SetInt(2, userchoice);
  }

  return true;
}

function doCancel()
{
  dialogParams.SetInt(1,0);
  return true;
}

function viewCert()
{
  viewCertHelper(window, cert);
}
