
function nsResetPref() {
}

nsResetPref.prototype = {
    // Turn this on to get debugging messages.
    debug: false,

    // nsICmdLineHandler interface
    get commandLineArgument() { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get prefNameForStartup()  { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get chromeUrlForTask()    {
        try {
            // We trust that this has been called during command-line handling during
            // startup from nsAppRunner.cpp.

            // We get the command line service and from that the -resetPref argument.
            var cmdLine  = Components.classes[ "@mozilla.org/app-startup/commandLineService;1" ]
                             .getService( Components.interfaces.nsICmdLineService );
            var prefList = cmdLine.getCmdLineValue( "-resetPref" ).split( "," );

            // Get pref service.
            var prefs    = Components.classes[ "@mozilla.org/preferences-service;1" ]
                             .getService( Components.interfaces.nsIPrefService );

            // For each pref specified on the cmd line, reset the user pref value.
            for ( i in prefList ) {
                var pref = prefs.getBranch( prefList[ i ] );
                try {
                    pref.clearUserPref( "" );
                } catch( e ) {
                }
            }
        } catch( e ) {
            this.dump( "exception: " + e );
        }

        // Return an error (so nsAppRunner doesn't think we've opened a window).
        throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
    },
    get helpText()            { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get handlesArgs()         { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get defaultArgs()         { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get openWindowWithArgs()  { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },

    // nsISupports interface

    // This "class" supports nsICmdLineHandler and nsISupports.
    QueryInterface: function (iid) {
        if (iid.equals(Components.interfaces.nsICmdLineHandler) ||
            iid.equals(Components.interfaces.nsISupports))
            return this;

        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    },

    // Dump text (if debug is on).
    dump: function( text ) {
        if ( this.debug ) {
            dump( "nsResetPref: " + text + "\n" );
        }
    },

    // This Component's module implementation.  All the code below is used to get this
    // component registered and accessible via XPCOM.
    module: {
        // registerSelf: Register this component.
        registerSelf: function (compMgr, fileSpec, location, type) {
            var compReg = compMgr.QueryInterface( Components.interfaces.nsIComponentRegistrar );
            compReg.registerFactoryLocation( this.cid,
                                             "Pref Reset Component",
                                             this.contractId,
                                             fileSpec,
                                             location,
                                             type );
        },

        // getClassObject: Return this component's factory object.
        getClassObject: function (compMgr, cid, iid) {
            if (!cid.equals(this.cid))
                throw Components.results.NS_ERROR_NO_INTERFACE;

            if (!iid.equals(Components.interfaces.nsIFactory))
                throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

            return this.factory;
        },

        /* CID for this class */
        cid: Components.ID("{15ABFAF7-AD4F-4450-899B-0373EE9FAD95}"),

        /* Contract ID for this class */
        contractId: "@mozilla.org/commandlinehandler/general-startup;1?type=resetPref",

        /* factory object */
        factory: {
            // createInstance: Return a new nsResetPref object.
            createInstance: function (outer, iid) {
                if (outer != null)
                    throw Components.results.NS_ERROR_NO_AGGREGATION;

                return (new nsResetPref()).QueryInterface(iid);
            }
        },

        // canUnload: n/a (returns true)
        canUnload: function(compMgr) {
            return true;
        }
    }
}

// NSGetModule: Return the nsIModule object.
function NSGetModule(compMgr, fileSpec) {
    return nsResetPref.prototype.module;
}
