
function nsKillAll() {
}

nsKillAll.prototype = {

    // nsICmdLineHandler interface
    get commandLineArgument() { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get prefNameForStartup()  { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },

    get chromeUrlForTask()    {

      // turn off server mode

      var wasMozillaAlreadyRunning = false;
      var appStartup = Components.classes["@mozilla.org/toolkit/app-startup;1"]
                         .getService(Components.interfaces.nsIAppStartup);
      var nativeAppSupport = {isServerMode: false};
      try {
        nativeAppSupport = appStartup.nativeAppSupport;
      } catch ( ex ) {
      }

      var originalServerMode = false;
      if (nativeAppSupport.isServerMode) {
        originalServerMode = true;
        wasMozillaAlreadyRunning = true;
        nativeAppSupport.isServerMode = false;
      }

      // stop all applications

      var gObserverService = Components.classes["@mozilla.org/observer-service;1"]
                             .getService(Components.interfaces.nsIObserverService);
      if (gObserverService) {
        try {
          gObserverService.notifyObservers(null, "quit-application", null);
        } catch (ex) {
          // dump("no observer found \n");
        }
      }

      // close down all windows

      var windowManager =
        Components.classes['@mozilla.org/appshell/window-mediator;1']
        .getService(Components.interfaces.nsIWindowMediator);
      var enumerator = windowManager.getEnumerator(null);
      while(enumerator.hasMoreElements()) {
        wasMozillaAlreadyRunning = true;
        var domWindow = enumerator.getNext();
        if (("tryToClose" in domWindow) && !domWindow.tryToClose()) {
          // user pressed cancel in response to dialog for closing an unsaved window
          nativeAppSupport.isServerMode = originalServerMode
          // Return NS_ERROR_ABORT to inform caller of the "cancel."
          throw Components.results.NS_ERROR_ABORT;
        }
        domWindow.close();
      }

      // exit without opening a new window

      if (wasMozillaAlreadyRunning) {
        // Need to exit appshell in this case.
        appStartup.quit(Components.interfaces.nsIAppStartup.eAttemptQuit);
      }

      // We throw NS_ERROR_NOT_AVAILABLE which will be interpreted by the caller
      // to mean that the command line handler is indicating that this should be a
      // silent command and not cause any windows to open.
      throw Components.results.NS_ERROR_NOT_AVAILABLE;
    },

    get helpText()            { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get handlesArgs()         { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get defaultArgs()         { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
    get openWindowWithArgs()  { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },

    // nsISupports interface

    // This "class" supports nsICmdLineHandler and nsISupports.
    QueryInterface: function (iid) {
        if (iid.equals(Components.interfaces.nsICmdLineHandler) ||
            iid.equals(Components.interfaces.nsISupports))
            return this;

        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    },

    // This Component's module implementation.  All the code below is used to get this
    // component registered and accessible via XPCOM.
    module: {
        // registerSelf: Register this component.
        registerSelf: function (compMgr, fileSpec, location, type) {
            var compReg = compMgr.QueryInterface( Components.interfaces.nsIComponentRegistrar );
            compReg.registerFactoryLocation( this.cid,
                                             "Kill All Component",
                                             this.contractId,
                                             fileSpec,
                                             location,
                                             type );
        },

        // getClassObject: Return this component's factory object.
        getClassObject: function (compMgr, cid, iid) {
            if (!cid.equals(this.cid))
                throw Components.results.NS_ERROR_NO_INTERFACE;

            if (!iid.equals(Components.interfaces.nsIFactory))
                throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

            return this.factory;
        },

        /* CID for this class */
        cid: Components.ID("{F1F25940-4C8F-11d6-A651-0010A401EB10}"),

        /* Contract ID for this class */
        contractId: "@mozilla.org/commandlinehandler/general-startup;1?type=killAll",

        /* factory object */
        factory: {
            // createInstance: Return a new nsKillAll object.
            createInstance: function (outer, iid) {
                if (outer != null)
                    throw Components.results.NS_ERROR_NO_AGGREGATION;

                return (new nsKillAll()).QueryInterface(iid);
            }
        },

        // canUnload: n/a (returns true)
        canUnload: function(compMgr) {
            return true;
        }
    }
}

// NSGetModule: Return the nsIModule object.
function NSGetModule(compMgr, fileSpec) {
    return nsKillAll.prototype.module;
}
