/* $Id: EVENTS.C 1.3 1999/01/09 06:03:29 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/EVENTS.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include <time.h>

#include "config.h"
#include "stdio.h"
#include "protocol.h"
#include "data.h"
#include "mem.h"

/************************************************************************/
/* comparen
*  Take n bytes and return identical (true=1) or not identical (false=0)
*
*  Could be written in assembler for improved performance
*/
int	neterror;

comparen(s1,s2,n) 
     uint8 *s1,*s2;
     register int n;
{

  while (n--)
    if (*s1++ != *s2++)
      return(0);

  return(1);

}

/*************************************************************************/
/* neteventinit
 *  load up the pointers for the event queue
 *  makes a circular list to follow, required for error messages
 */
neteventinit()
{
  int i;

  for (i=0; i < NEVENTS; i++)
    nnq[i].next = i+1;

  nnq[NEVENTS-1].next = -1;

  nnefirst = 0;
  nnelast = 0;
  nnefree = 1;
}


/************************************************************************/
/*  netposterr
 *   place an error into the event q
 *   Takes the error number and puts it into the error structure
 */
netposterr(num)
     int num;
{
  neterror = num;
  if (netputevent(ERRCLASS,ERR1,num))

    netputuev(ERRCLASS,ERR1,501);			/* only if we lost an event */
}

/***********************************************************************/
/*  netgetevent
 *   Retrieves the next event (and clears it) which matches bits in
 *   the given mask.  Returns the event number or -1 on no event present.
 *   Also returns the exact class and the associated integer in reference
 *   parameters.
*
*   The way the queue works:
*     There is always a dummy record pointed to by nnelast.
*     When data is put into the queue, it goes into nnelast, then nnelast
*        looks around for another empty one to obtain.
*        It looks at nnefree first, then bumps one from nnefirst if necessary.
*     When data is retrieved, it is searched from nnefirst to nnelast.
*        Any freed record is appended to nnefree.
*/
netgetevent(mask,retclass,retint)
     uint8 mask;
     int *retclass,*retint;
{
  int i,j;

  i = nnefirst;

  while (i != nnelast) {
    if (mask & nnq[i].eclass) {
      if (i == nnefirst) 
	nnefirst = nnq[nnefirst].next;		/* step nnefirst */
      else 
	nnq[j].next = nnq[i].next;			/* bypass record i */

      nnq[i].next = nnefree;
      nnefree = i;							/* install in free list */
      *retint = nnq[i].idata;
      *retclass = nnq[i].eclass;
      return(nnq[i].event);
    }
    j = i;
    i = nnq[i].next;
  }

  return(0);

}

/***********************************************************************/
/*  netputevent
 *   add an event to the queue.
 *   Will probably get the memory for the entry from the free list.
 *   Returns 0 if there was room, 1 if an event was lost.
*/
netputevent(class,what,dat)
     int class,what,dat;
{
  int i;

  i = nnelast;
  nnq[i].eclass = class;					/* put data in */
  nnq[i].event = what;
  nnq[i].idata = dat;

  if (nnefree >= 0) {						/* there is a spot in free list */
    nnq[i].next = nnelast = nnefree;
    nnefree = nnq[nnefree].next;		/* remove from free list */
    return(0);
  }
  else {
    nnq[i].next = nnelast = nnefirst;
    nnefirst = nnq[nnefirst].next;		/* lose oldest event */
    return(1);
  }
}

/***************************************************************************/
/*  netputuev
 *   put a unique event into the queue
 *   First searches the queue for like events
 */
netputuev(class,what,dat)
     int class,what,dat;
{
  int i;

  i = nnefirst;
  while (i != nnelast) {
    if (nnq[i].idata == dat && nnq[i].event == what &&
	nnq[i].eclass == class)
      return(0);
    i = nnq[i].next;
  }

  return(netputevent(class,what,dat));

}


/************************************************************************/
/*  neterrstring
 *   returns the string associated with a particular error number
 *
 *   error number is formatted %4d at the beginning of the string
 */
static char *errs[] = {
  "   0 Error unknown",
  " 100 Network jammed, probable break in wire",
  " 101 Could not initialize hardware level network driver",
  " 102 ERROR: The conflicting machine is using the same IP number",
  " 103 RARP request failed, an IP number is required",
  " 300 Bad IP checksum",
  " 301 IP packet not for me",
  " 302 IP packet with options received",
  " 303 IP: unknown higher layer protocol",
  " 304 IP: fragmented packet received, frags not supported",
  " 400 TCP: bad checksum",
  " 401 ACK invalid for TCP syn sent",
  " 403 TCP in unknown state",
  " 404 Invalid port for TCPsend",
  " 405 TCP connection reset by other host",
  " 406 Null port specified for ackandtrans",
  " 407 Packet received for invalid port -- reset sent",
  " 500 No internal TCP ports available",
  " 501 Warning: Event queue filled, probably non-fatal",
  " 504 Local host or gateway not responding",
  " 505 Memory allocation error, cannot open port",
  " 506 Not allowed to connect to broadcast address",
  " 507 Reset received: syn sent, host is refusing connection",
  " 600 ICMP:	Echo reply",
  " 603 ICMP:	Destination unreachable",
  " 604 ICMP:	Source Quench",
  " 605 ICMP:	Redirect, another gateway is more efficient",
  " 608 ICMP:	Echo requested (ping requested)",
  " 611 ICMP:	Time Exceeded on Packet",
  " 612 ICMP:	Parameter problem in IP",
  " 613 ICMP:	Timestamp request",
  " 614 ICMP:	Timestamp reply",
  " 615 ICMP:	Information request",
  " 616 ICMP:	Information reply",
  " 699 ICMP: Checksum error",
  " 700 Bad UDP checksum",
  " 800 Domain: Name request to server failed",
  " 801 Domain: Using default domain",
  " 802 Domain: name does not exist",
  " 803 Domain: UDP name server did not resolve the name",
  " 804 Domain: name server failed, unknown reason",
  " 805 Host machine not in configuration file",
  " 806 Missing IP number, requires domain lookup",
  " 900 Session: Cannot find or open configuration file",
  " 901 Session: Cannot allocate memory for processing",
  " 902 Session: Invalid keyword in configuration file",
  " 903 Session: Element too long (>200), maybe missing quote",
  " 904 Session: Probable missing quote marks, a field must be on one line",
  " 905 Session: 'name' field required before other machine entries",
  " 906 Session: Syntax error, invalid IP number",
  " 907 Session: Syntax error, Subnet mask invalid",
  " 908 Session: Syntax error, IP address for this PC is invalid",
  " 912 Configfile: Warning, this version not compiled with Clock Support",
  " 913 Configfile: Information, Timezone Arg not needed in clock statement",
  " 914 Configfile: Syntax Error. Check the documentation for proper format",
  ""};

static char errspace[80];		/* room for user-defined errors */
char *neterrstring(errno)
     int errno;
{
  int i;
  char s[10];

  if (errno < 0) 
    return(errspace);

  sprintf(s,"%4d",errno);
  i = 0;
  do {
    if (!strncmp(errs[i],s,4))
      return(errs[i]+5);			/* pointer to error message  */
    i++;

  } while (*errs[i] || i > 100);			/* until NULL found */

  return(errs[0]+5);					/* error unknown */
}

/* End of events.c */
