/* $Id: confile.c 1.15 2000/04/11 04:11:02 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/confile.c $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <ctype.h>
#include <string.h>

#include "config.h"
#include "whatami.h"
#include "hostform.h"
#include "windat.h"
#include "newwin.h"
#include "mem.h"

/* #define XDEBUG 1 */
/* #define DEBUG 1 */

/* #define CONSOLE_VERBOSE 1 */

#ifdef	CLOCK
int	clockmode=24;
#endif
char 							/* special function types */
			*neterrstring();
int32 time();					/* don't forget this sucker! */
SOUNDS	bell_sound[]={
	{4,1200},
       {0,0}
};

SOUNDS badkey_sound[]={
	{6,1500},
       {6,700},
       {0,0}
};

SOUNDS ftp_sound[]={
	{6,600},
       {6,0},
       {6,2400},
       {0,0}
};

SOUNDS margin_sound[]={
	{17,2000},
       {0,0}
};

SOUNDS	*sounds[MAX_SOUNDS]={bell_sound,
			    badkey_sound,
			    ftp_sound,
			    margin_sound
};
#define	MAX_STEPS	8	/* number of freq step changes */
static struct machinfo *Smachlist,*Smptr;
struct machinfo *Sns=NULL;

int (*usr_init)(char *name, char *value) = NULL;

struct config Scon = {
  0,0,0,0,	/* netmask */
  0,		/* havemask */
  66,79,79,84,	/* myipnum: default ip address "BOOT" for bootp */
  "",		/* hostname */
  "",		/* username */
  0,		/* ftp */
  0,		/* rcp */
  7,1,0x70,	/* color[3] */
  "DEC-VT100",	/* termtype */
  NULL,		/* domainpath */
  NULL,		/* capture file */
  NULL,		/* passfile */
  SMINRTO,	/* retrans */
  CONNWAITTIME,	/* conto */
  DEFWINDOW,	/* window */
  DEFSEG,	/* maxseg */
  TSENDSIZE,	/* mtu */
  4,		/* domto */
  3,		/* ndom */
  0		/* sys_flags */
};

char	*env_config;

static int
  mno=0,	/* how many machines in host file */
  gateways,	/* number of gateways defined */
  nameservers,	/* number of nameservers defined */
  lineno,	/* line number in hosts file */
  position,	/* position for scanning string */
  constate,	/* state for config file parser */
  inquote;	/* flag, inside quotes now */

/* States for config file reading state machine.  One for each type of
 * keyword and some for controlling.  */

#define CONUNKNOWN 100
#define CONNAME    101
#define CONHOST    102
#define CONHOSTIP  103
#define CONBKSP    104
#define CONBKSC    105
#define CONDUP     106
#define CONWRAP    107
#define CONWIDE    108
#define CONCLMODE  109

#define NUMSPECS 109
static unsigned char *Smachfile = {"tcp.cfg"},
  Sflags[NUMSPECS-95],	/* which parms we have or have not */
  *Sspace;
/*
*  above this line are per machine entries, below are configuration entries
*/
#define CONIP      110
#define CONMYIP    111
#define CONMASK    112
#define CONNS      113
#define CONGATE    114
#define CONDOMPATH 115
#define CONMYHOST  116
#define CONMYUSER  117
#define CONFTP     118
#define CONRCP     119
#define CONPASS    120

#define CONRETR    121
#define CONTO      122
#define CONWIND    123
#define CONSEG     124
#define CONMTU     125
#define CONDOMTO   126
#define CONNDOM    127
#define CONCAP     128
#define CONTTYPE   129
#define CONFROM    130
#define CONARPTO   131
#define CONCLOCK   132     /* clock control */
#define CONKEYMAP  133     /* set the keymap file name */
#define CONFLAGS   134     /* set flags into machine structure */
#define CONNOARPME 135
#define CONVISBELL 136
#define CONSOUND   137
#define CONCOLORS  138
#define CONINCLUDE 139

char *Skeyw[] = {
  "",			/* used for user_init */
  "name",               /* name of session */
  "host",               /* name of host */
  "hostip",             /* IP number */
  "erase",              /* value to use for backspace */
  "scrollback",         /* how many lines to backscroll */
  "duplex",             /* half duplex for IBM machines */
  "vtwrap",             /* should VT wrap? */
  "vtmargin",           /* margin to ring bell at */
  "clearsave",          /* clear screen saves lines */
  /*
   *  following are one-time entries, above are part of the data structure
   */
  "ip",                 /* local machine's IP # */
  "my_ip",              /* local machine's IP # */
  "netmask",            /* subnetting mask */
  "nameserver",         /* name server */
  "gateway",            /* gateway */
  "domainslist",        /* domain search path   */
  "hostname",           /* host name */
  "username",           /* user name */
  "ftpd.enable",        /* enable ftp? */
  "rcpd.enable",        /* enable rcp? */
  "ftpd.passfile",      /* password file name */
  "retrans",            /* initial retrans time */
  "contime",            /* timeout for opening connection */
  "rwin",               /* window to allow for this host */
  "mss",                /* maximum transfer size (in) */
  "mtu",                /* transfer unit (out) */
  "domaintime",         /* time-out for DOMAIN */
  "domainretry",        /* # of retries */
  "lxtelnet.capfile",   /* capture file name */
  "lxtelnet.termtype",  /* terminal type */
  "copyfrom",           /* copy from another machine */
  "arptime",            /* time-out for ARPs */
  "lxtelnet.clock",     /* control clock */
  "lxtelnet.keymap",    /* the keymap */
  "flags",              /* raw flags control */
  "noarpme",            /* set if we are not supposed to arp ourselves */
  "lxtelnet.visbell",   /* visual bell */
  "sound",              /* sounds... */
  "lxtelnet.colors",    /* console colors */
  "include",            /* include file */
  ""
};

extern int no_arpme;

#define	MAX_FILES	3

/************************************************************************/
/*  Sgetconfig
*   copy the configuration information into the user's data structure
*   directly.  The user can do with it what he feels like.
*/
Sgetconfig(cp)
     struct config *cp;
{

  movebytes(cp,&Scon,sizeof(struct config));
  return(0);

}

static char
Env_read(unsigned int *token)
{
  static	char	*currbuff;
  char	ask_buff[20];
  static	unsigned char	curr_token = 0;
  char	c;

  if(!*token) {
    if(currbuff = getenv("$CUTCP1")) {
      *token = 0x100;
      curr_token = 1;
    }
    else if(env_config) {
      currbuff = env_config;
      *token = 0xf000;
      curr_token = 0xf0;
      env_config = NULL;
    }
    return(0);
  }
  if(curr_token != (*token >> 8)) {
    sprintf(ask_buff,"$CUTCP%d",curr_token);
    if(!(currbuff = getenv(ask_buff))) {
      if(env_config) {
	currbuff = env_config;
	env_config = NULL;
      }
      else				
	return(EOF);
    }
    curr_token = *token >> 8;
  }
  if(!(c = *(currbuff + (*token & 0xFF)))) {
    *token = (*token &  0xff00) + 0x100;
    return('\n');
  }
  (*token)++;
  return((c == '~') ? '=' : c);
}

/************************************************************************/
/*  Sreadhosts
*   read in the hosts file into our in-memory data structure.
*   Handle everything by keyword, see docs for specifications about file.
*/
Sreadhosts()
{
  FILE 	*fp[MAX_FILES+1];
  int	lines[MAX_FILES+1];
  int	file_stack=0;
  int i,c,retval,env_read=0;
  unsigned int	token=0;
  
  retval = mno = 0;
  
  for (i=0; i<NUMSPECS-99; i++)
    Sflags[i] = 0;

  /* Create the default entry */
  Smachlist = (struct machinfo *)mem_calloc(sizeof(struct machinfo),1);
  Smptr = Smachlist;
  Smptr->sname = "default";
  Smptr->hname = NULL;
  Scopyfrom("==");	/* to make sure 'default' gets set */
  Smptr->destport = 0;
  Smptr->flags = 0;
  Smptr->command = NULL;
  Smptr->keymap = NULL;
  Smptr->next = NULL;
  Smptr->mno = ++mno;				/* new machine number */
  Sflags[1] = 1;

  Sspace = mem_malloc(256);		/* get room for gathering stuff */
  if (Sspace == NULL) {
    Serrline(901);
    return(1);
  }
  Env_read(&token);
 restart:;
  position = constate = inquote = lineno = 0;   /* state vars */
  retval = 0;
  if (NULL == (fp[file_stack] = fopen(Smachfile,"r"))) {
#ifdef	XDEBUG
    fprintf(stderr,"Sreadhost %s\n",Smachfile);
#endif
    Serrline(900);
    nprintf(CONSOLE,"Couldn't open config file %s\n",Smachfile);
    if(!file_stack)
      return(1);
    else {
      file_stack--;
      lineno = lines[file_stack];
    }
  }
 rescan:;
  while (!retval) {
    if(env_read && !file_stack) {
      c = Env_read(&token);
#ifdef	XDEBUG
      fprintf(stderr,"Envread %c\n",c);
#endif
    }
    else {
      c = fgetc(fp[file_stack]);
#ifdef	XDEBUG
      fprintf(stderr,"%c",c);
#endif
    }
    if (((c == '#') || (c == ';')) && !inquote) {
      while (c != EOF && c != '\n' && c != '\r')	/* skip to EOL */
	c = fgetc(fp[file_stack]);
    }
    if (c == '\n' || c == '\r') {
      lineno++;
      inquote = 0;
    }
    if(c == EOF) {
      if(file_stack) {
	fclose(fp[file_stack]);
	file_stack--;
	lineno = lines[file_stack];
	continue;
      }
      if( (token && !env_read))
	break;
    }
    retval = Scontoken(c);		/* add character to token */
  }
  if(retval == CONINCLUDE)  {
    if(file_stack < MAX_FILES) {
      lines[file_stack] = lineno;
      file_stack++;
      goto restart;
    }
    else {
      nprintf(CONSOLE,"File include stack limit of %d exceeded\n",MAX_FILES);
      goto rescan;
    }
  }
  if(!env_read) {
    fclose(fp[file_stack]);
    if(token) {
      env_read = 1;
      goto rescan;
    }
  }
  mem_free(Sspace);
  
  if (retval == EOF)				/* EOF is normal end */
    return(0);
  else {
#ifdef	DEBUG
    fprintf(stderr,"retval is %x\n",retval);
#endif
    return(retval);
  }
}


/************************************************************************/
/*  ncstrcmp
*   No case string compare.
*   Only returns 0=match, 1=no match, does not compare greater or less
*   There is a tiny bit of overlap with the | 32 trick, but shouldn't be
*   a problem.  It causes some different symbols to match.
*/
ncstrcmp(sa,sb)
     char *sa,*sb;
{
  
  while (*sa && *sa < 33)		/* don't compare leading spaces */
    sa++;
  while (*sb && *sb < 33)
    sb++;
  
  while (*sa && *sb) {
    if ((*sa != *sb) && ((*sa | 32) != (*sb | 32)))
      return(1);
    sa++;sb++;
  }
  if (!*sa && !*sb)		/* if both at end of string */
    return(0);
  else
    return(1);
}

/************************************************************************/
/*  Serrline
*   prints the line number of the host file error and posts the event
*   for the line number error and posts the hosts file error.
*/

Serrline(n)
     int n;
{
  char *p;
  nprintf(CONSOLE,"Config file: error in line %4d\n",lineno+1);
  nprintf(CONSOLE,"%s\n",neterrstring(n));
}

/************************************************************************/
/* Scontoken
*  tokenize the strings which get passed to Sconfile.
*  Handles quotes and uses separators:  <33, ;:=
*/
Scontoken(c)
     int c;
{
  int retval;
  
  if (c == EOF) {
    Sspace[position++] = '\0';
    Sconfile(Sspace);
    if (!Sflags[0]) {			/* make sure last entry gets copied */
      if (ncstrcmp("default",Smptr->sname))
	Scopyfrom("default");
    }
    return(-1);
  }
  
  if (!position && Sissep(c))		/* skip over junk before token */
    return(0);
  
  if (inquote || !Sissep(c)) {
    
    if (position > 200) {
      Serrline(903);
      return(1);
    }
    /*
     *  check for quotes, a little mixed up here, could be reorganized
     */
    if (c == '"' ) {
      if (!inquote) {			/* beginning of quotes */
	inquote = 1;
	return(0);
      }
      else
	inquote = 0;		/* turn off flag and drop through */
      
    }
    else {						
      if (c == '\n') {			/* check for EOL inside quotes */
	Serrline(904);
	return(1);
      }
      Sspace[position++] = c;    /* include in current string */
      return(0);
    }
    
  }
  
  Sspace[position++] = '\0';
  
  retval = Sconfile(Sspace);			/* pass the token along */
  
  position = 0;
  inquote = 0;
  Sspace[0] = '\0';
  
  return(retval);
}

/************************************************************************/
/*  Sconfile
*   take the characters read from the file and parse them for keywords
*   which require configuration action.
*/
Sconfile(s)
     char *s;
{
  int i,a,b,c,d;
  char	*cp;
  unsigned int destport;
  struct machinfo *m;
  
  static char * keyword;

  switch (constate) {
  case 0:						/* lookup keyword */
    if (!(*s))						/* empty token */
      return(0);
    
    
    for (i=1; *Skeyw[i] && ncstrcmp(Skeyw[i],s); i++)
      ;

    if (!(*Skeyw[i])) {		/* not in list */
      keyword = s;		/* save the keyword */
      constate = CONUNKNOWN;	/* pass it on the the user's function */
      return(0);
    }
    constate = 100+i;	/* change to state for keyword */
    /* check if this is a machine specific parm without a machine to
     * give it to.  "name" being the only machine specific parm
     * allowed, of course */
    if (Smptr == NULL && constate > 101 && constate <= NUMSPECS) {
      Serrline(905);
      return(1);
    }
    break;
    
  case CONUNKNOWN:
    /* if the user has registered a function, then call it */
    if ( usr_init && (*usr_init)(keyword, s) )
      Serrline(914);
    constate = 0;
    return(0);

  case CONNAME:
    /* make sure previous entry gets copied */
    if (!Sflags[0]) {
      if (ncstrcmp("default",Smptr->sname))
	Scopyfrom("default");
    }
    /* Check if the entry already exists. */
    if (NULL == (m = Shostlook(position))) {
      /* allocate space for upcoming parameters */
      Smptr->next = 
	(struct machinfo *)mem_calloc(sizeof(struct machinfo),1);
      Smptr = Smptr->next;
      Smptr->destport = 0;    /* never copy this */
      Smptr->flags = 0;
      Smptr->command = NULL;
      Smptr->keymap = NULL;
      Smptr->next = NULL;
      Smptr->hname = NULL;			/* guarantee to be null */
      Smptr->sname = mem_malloc(position);	/* size of name string */
      strcpy(Smptr->sname,s);			/* keep name field */
      for (i=0; i<NUMSPECS-99; i++)
	Sflags[i] = 0;				/* we have no parms */
      Smptr->mno = ++mno;				/* new machine number */
    }
    else {
      /* Add to the existing entry */
      Smptr = m;
      Sflags[0] = 1; /* it's already been copied */
    }
    constate = 0;				/* back to new keyword */
    break;
    
  case CONHOST:					/* also a name */
    destport = 0;
#ifdef	YDEBUG
    printf("conhost (%s) %lp\n",s,strchr(s,':'));
#endif
    if(cp = strchr(s,':')) {
      cp++;
      
      if(isdigit(*cp)) {
	if(*(cp+1) == 'x' || *(cp+1) == 'X')
	  sscanf(cp+2,"%x",&destport);
	else
	  if(*cp == '0')
	    sscanf(cp+1,"%o",&destport);
	  else
	    sscanf(cp,"%u",&destport);
	cp = strchr(s,':');
	*cp = 0;
      }
    }
    if(destport) {
#ifdef	YDEBUG
      printf("port %u\n",destport);
#endif
      Smptr->destport = destport;
      Smptr->flags |= TWIN_FLAGS_CONFIG_PORT;
    }
    Smptr->hname = mem_malloc(strlen(s)+1);
    strcpy(Smptr->hname,s);
    constate = 0;
    Sflags[CONHOST-100] = 1;
    break;
    
  case CONHOSTIP:				/* IP number for host */
    if ( 4 != sscanf(s,"%d.%d.%d.%d",&a,&b,&c,&d)) {
      Serrline(906);
      return(3);
    }
    Smptr->hostip[0]=a; Smptr->hostip[1] =b; 	/* keep number */
    Smptr->hostip[2]=c; Smptr->hostip[3] =d;
    Smptr->mstat = HFILE;
    constate = 0;
    Sflags[CONHOSTIP-100] = 1;
    break;
    
  case CONBKSP:
    if (!ncstrcmp(s,"backspace"))
      Smptr->bksp = 8;
    else
      Smptr->bksp = 127;
    constate = 0;
    Sflags[CONBKSP-100] = 1;
    break;
    
  case CONBKSC:
    Smptr->bkscroll = atoi(s);
    constate = 0;
    Sflags[CONBKSC-100] = 1;
    break;

  case CONDUP:
    if (!ncstrcmp(s,"half")) {
      Smptr->halfdup = 1;
      Sflags[CONDUP-100] = 1;
    }
    constate = 0;
    break;

  case CONWRAP:
    if(islower(s[0]))
      s[0] = toupper(s[0]);
    if ('Y' == s[0])
      Smptr->vtwrap = 1;
    else if ('T' == s[0])	/* vtwrap=T for load measurement */
      Smptr->vtwrap = 2;
    else
      Smptr->vtwrap = 0;
    Sflags[CONWRAP-100] = 1;
    constate = 0;
    break;

  case CONCLMODE:
    if ('N' == toupper(s[0])) 
      Smptr->clearsave = 0;
    else
      Smptr->clearsave = 1;
    Sflags[CONCLMODE-100] = 1;
    constate = 0;
    break;

  case CONWIDE:	       /* aka vtmargin */
    if(s[0] == 'y' || s[0] == 'Y')
      Smptr->vtmargin = 0xff;

    Sflags[CONWIDE-100] = 1;
    constate = 0;
    break;

/*
 *  now the one-time entries
 *  Generally this information goes into the "Scon" structure for later
 *  retrieval by other routines.
 */
  case CONIP:
  case CONMYIP:
    constate = 0;
    if (!ncstrcmp(s,"rarp")) {
      movebytes(Scon.myipnum,s,4);
      netsetip("RARP");
      break;
    }
#ifdef  BOOTP
    if (!ncstrcmp(s,"bootp")) {
      movebytes(Scon.myipnum,"BOOT",4);
      netsetip("BOOT");
      break;
    }
#endif
    if ( 4 != sscanf(s,"%d.%d.%d.%d",&a,&b,&c,&d)) {
      Serrline(908);
      printf("s=[%s]\n",s);
      return(3);
    }
    Scon.myipnum[0]=a; Scon.myipnum[1] =b; 	/* put number back in s */
    Scon.myipnum[2]=c; Scon.myipnum[3] =d;
    netsetip(Scon.myipnum);		/* make permanent set */
    break;

  case CONMASK:
    if ( 4 != sscanf(s,"%d.%d.%d.%d",&a,&b,&c,&d)) {
      Serrline(907);
      return(3);
    }
    Scon.netmask[0]=a; Scon.netmask[1] =b; 	
    Scon.netmask[2]=c; Scon.netmask[3] =d;
    Scon.havemask=1;
    constate = 0;
    break;

  case CONGATE:
    if ( 4 != sscanf(s,"%d.%d.%d.%d",&a,&b,&c,&d)) {
      Serrline(906);
      return(3);
    }
    if(!(Smptr = Smadd(s))) {
      nprintf(CONSOLE,"Out of Memory Adding Gateway - Smadd()\n");
      return(2);
    }
    Smptr->hostip[0]=a; Smptr->hostip[1] =b; 	/* keep number */
    Smptr->hostip[2]=c; Smptr->hostip[3] =d;
    Smptr->mstat = HFILE;
    Smptr->gateway = ++gateways;		/* gateway level */
    constate = 0;
    break;

  case CONNS:
    if ( 4 != sscanf(s,"%d.%d.%d.%d",&a,&b,&c,&d)) {
      Serrline(906);
      return(3);
    }
    if(!(Smptr = Smadd(s))) {
      nprintf(CONSOLE,"Out of Memory Adding Nameserver - Smadd()\n");
      return(2);
    }
    Smptr->hostip[0]=a; Smptr->hostip[1] =b; 	/* keep number */
    Smptr->hostip[2]=c; Smptr->hostip[3] =d;
    Smptr->mstat = HFILE;
    Smptr->nameserv = ++nameservers;
    if (!Sns || (Sns->nameserv > Smptr->nameserv))	/* keep NS */
      Sns = Smptr;
    constate = 0;
    break;

  case CONDOMPATH:                        /* domain name path */
    Scon.domainpath = mem_malloc(position+1);	/* space for path */
    strcpy(Scon.domainpath,s);			/* copy it in */
    removejunk(Scon.domainpath);  /* remove all spaces, leading and trailing commas, 
                                        converts commas to nulls .. defined in util.c */
    constate = 0;
    break;

  case CONMYHOST:				/* what my hostname is  */
    strncpy(Scon.hostname,s,30);
    Scon.hostname[30] = '\0';
    constate = 0;
    break;

  case CONMYUSER:				/* what my username is  */
    strncpy(Scon.username,s,30);
    Scon.username[30] = '\0';
    constate = 0;
    break;

  case CONFTP:
    if (toupper(*s) == 'N') 
      Scon.ftp = 0;
    else if (toupper(*s) == 'Y') 
      Scon.ftp = 1;
    constate = 0;
    break;

  case CONRCP:
    if (toupper(*s) == 'N')
      Scon.rcp = 0;
    else if (toupper(*s) == 'Y')
      Scon.rcp = 1;
    constate = 0;
    break;

  case CONTTYPE:
    Scon.termtype = mem_malloc(position);
    strcpy(Scon.termtype,s);
    constate = 0;
    break;

  case CONCOLORS:
    for (i=0; i<3; i++)
      Scon.color[i] = ((s[i*2]-48)<<4) + (s[i*2+1]-48);
    constate = 0;
    break;

  case CONPASS:
    Scon.pass = mem_malloc(position);	/* space for name */
    strcpy(Scon.pass,s);			/* copy it in */
    constate = 0;
    break;

  case CONCAP:						/* capture file name */
    Snewcap(s);
    constate = 0;
    break;
  case CONFROM:						/* copy the rest from another */
    /* entry in the table */
    if (Scopyfrom(s))
      return(1);
    Sflags[0] = 1;					/* indicate did copy from */
    constate = 0;
    break;

  case CONARPTO:				/* need to lengthen arp time-out (secs) */
    i = atoi(s);
    if (i > 0)
      netarptime(i);
    constate = 0;			/* don't forget me! */
    break;

  case CONRETR:
    Scon.retrans = atoi(s);
    constate = 0;
    break;
    
  case CONTO:
    i = atoi(s);
    if (i > 2) {
      Scon.conto = i;
    }
    constate = 0;
    break;

  case CONWIND:
    Scon.window = atoi(s);
    constate = 0;
    break;
    
  case CONSEG:
    Scon.maxseg = atoi(s);
    constate = 0;
    break;
    
  case CONMTU:
    Scon.mtu = atoi(s);
    constate = 0;
    break;

  case CONDOMTO:				/* DOMAIN timeout value */
    i = atoi(s);
    if (i > 1)
      Scon.domto = i;
    constate = 0;
    break;

  case CONNDOM:				/* DOMAIN number of retries */
    i = atoi(s);
    if (i > 1)
      Scon.ndom = i;
    constate = 0;
    break;

  case CONCLOCK :
#ifndef	CLOCK
    netposterr(912);
#else
    {
      char tbuff[65];
      char *cp;

      cp = strchr(s,':');
      if(cp) {
	*cp = 0;
#ifdef	_MSC_
	cp++;
	if(strlen(cp) > 50)
	  cp[50] = 0;
	sprintf(tbuff,"TZ=%s",cp);
	putenv(tbuff);
	tzset();
#else
	netposterr(913);
#endif
      }
      clockmode = atoi(s);
    }     
#endif
    constate=0;
    break;
  case CONKEYMAP :		/* set the machine keymap */
#ifdef	DEBUG
    cprintf("Keymap for host %s, is %s was %s\n",Smptr->sname,
	    s,Smptr->keymap);
#endif
    if(Smptr)
      Smptr->keymap = mem_strdup(s);
    constate = 0;
    break;
  case CONFLAGS :
    if(Smptr) {
      unsigned rflags = 0;
      sscanf(s,"%x",&rflags);
      Smptr->flags |= rflags;
    }
    constate = 0;
    break;
  case CONNOARPME :
    if(s[0] == 'y' || s[0] == 'Y')
      no_arpme = 1;
    constate = 0;
    break;
  case CONINCLUDE :
    {
      char *yz = mem_strdup(s);
      Shostfile(yz);
    }
    constate = 0;
    return(CONINCLUDE);

  case CONVISBELL :
    if(s[0] == 'y' || s[0] == 'Y')
      Scon.sys_flags |= SYS_FLAGS_VISUAL_BELL;
    constate = 0;
    break;

  case CONSOUND :
    {
      SOUNDS tmp[MAX_STEPS+1],*S;
      int step,sound,duration,freq;
      char	*c,*p;
      static char *tags[]={"bell","badkey","ftp","margin",NULL};
      if(c = strchr(s,':')) {
	*c = 0;
	for(sound=0; tags[sound]; sound++) {
#ifdef	DEBUGXS
	  nprintf(CONSOLE,"P %s, sound %d\n",tags[sound],sound);
#endif
	  if(!stricmp(tags[sound],s))
	    break;
	}
	if(!tags[sound])
	  goto syntax_error;
	for(step=0; c && (step < MAX_STEPS); step++) {
	  c++;
	  freq = duration = -1;
	  sscanf(c,"%d,%d",&duration,&freq);
#ifdef	DEBUGXS
	  nprintf(CONSOLE,"Scanned step %d sound %d %d,%d from (%s)\n",step,sound,duration,freq,c);
#endif
	  if((freq == -1) || (duration == -1))
	    break;
	  tmp[step].s_duration = duration;
	  tmp[step].s_frequency = freq;
	  c = strchr(c,':');
	}
	if(!step)
	  goto syntax_error;
	tmp[step].s_duration = 0;
	tmp[step].s_frequency = 0;
	step++;
	if(S = mem_malloc(step * sizeof(SOUNDS))) {
	  memcpy(S,tmp,step * sizeof(SOUNDS));
	  sounds[sound] = S;
	}
	else
	  nprintf(CONSOLE,"Not enough memory to allocate sound buffer\n");
      }
      else {
      syntax_error:;
	Serrline(914);
      }

    }
    constate = 0;
    break;
  default:
    constate = 0;
    break;
  }

  return(0);
}

/************************************************************************/
/*  Scopyfrom
*   Look at the Sflags array to determine which elements to copy from
*   a previous machine's entries.  If a machine name as been given as
*   "default", the state machine will fill in the fields from that
*   machine's entries.
*
*   If the machine name to copyfrom is not present in the list, set the
*   program default values for each field.
*/
Scopyfrom(s)
     char *s;
{
  struct machinfo *m;
  int i;

  m = Shostlook(s);			/* search list */

  for (i=3; i <= NUMSPECS-100; i++) 		/* through list of parms */
    if (!Sflags[i]) {
      if (m) 					/* copy old value */
	switch (100+i) {
	case CONHOST:
	  Smptr->hname = m->hname;
	  break;
#ifdef	STUPID
	case CONHOSTIP:
	  movebytes(Smptr->hostip,m->hostip,4);
	  Smptr->mstat = m->mstat;
	  break;
#endif
	case CONBKSP:
	  Smptr->bksp = m->bksp;
	  break;
	case CONBKSC:
	  Smptr->bkscroll = m->bkscroll;
	  break;
	case CONCLMODE:
	  Smptr->clearsave = m->clearsave;
	  break;
	case CONDUP:
	  Smptr->halfdup = m->halfdup;
	  break;
	case CONWRAP:
	  Smptr->vtwrap = m->vtwrap;
	  break;
	case CONWIDE:
	  Smptr->vtmargin = m->vtmargin;
	  break;
	default:
	  break;
	}
      else
	switch (100+i) {		/* m=NULL, install default values */
	case CONHOST:
	  Smptr->hname = NULL;
	  break;
	case CONHOSTIP:
	  Smptr->mstat = NOIP;
	  break;
	case CONBKSP:
	  Smptr->bksp = 127;
	  break;
	case CONBKSC:
	  Smptr->bkscroll = 0;
	  break;
	case CONCLMODE:
	  Smptr->clearsave = 1;
	  break;
	case CONDUP:
	  Smptr->halfdup = 0;
	  break;
	case CONWRAP:
	  Smptr->vtwrap = 0;
	  break;
	case CONWIDE:
	  Smptr->vtmargin = -1;
	  break;
	default:
	  break;
	}
    }
  Sflags[0] = 1;			/* set that this machine was copied */
  return(0);
}

/************************************************************************/
/*  Smadd
*   If machine is there, just returns pointer, else
*   Add a machine to the list. Increments machine number of machine.
*   Puts in parameters copied from the "default" entry.
*
*/
struct machinfo 
*Smadd(mname)
     char *mname;
{
  int i;
  struct machinfo *m;
  /*
   *  First, do we have the name already?
   */
  m = Shostlook(mname);
  if (m)
    return(m);
  /*
   *   Don't have name, add another record
   */
  Smptr = (struct machinfo *)mem_calloc(sizeof(struct machinfo),1);
  if (Smptr == NULL)
    return(NULL);

  for (i=0; i < NUMSPECS-99; i++)
    Sflags[i] = 0;					/* we have no parms */
  Scopyfrom("default");

  Smptr->sname = NULL;
  Smptr->hname = mem_malloc(strlen(mname)+1);
  if (Smptr->hname)
    strcpy(Smptr->hname,mname);		/* copy in name of machine */
  Smptr->mno = ++mno;
  Smptr->mstat = NOIP;
  Smptr->destport = 0;
  Smptr->gateway = 0;
  Smptr->nameserv = 0;
  Smptr->next = Smachlist;			/* add to front of machlist */
  Smachlist = Smptr;

  return(Smptr);

}


/************************************************************************/
/* Shostfile
 *   if the user wants to change the host file name from 'config.tel' to
 *   something else.
*/
Shostfile(ptr)
     char *ptr;
{
  Smachfile = ptr;	
  /*
   *  note that the area with the file name must stay allocated for
   *  later reference, typically it is in some argv[] parm.
   */
  return(0);
}

/************************************************************************/
/*  get host by name
*   Given the name of a host machine, search our database to see if we
*   have that host ip number.  Search first the name field, and then the
*   hostname field.  If the IP # is given, returns a ptr to the
*   default machine record with that IP # installed.
*   Returns the pointer to a valid record, or NULL if the IP # cannot
*   be deciphered.  
*/
struct machinfo 
*Sgethost(machine)
     char *machine;
{
  int i,j,k,l;
  unsigned char ipto[4],myipnum[4],xmask[4];
  unsigned long hnum;
  struct machinfo *m;

  m = NULL;
  /*
   *  First, check for the pound sign character which means we should use
   *  the current netmask to build an IP number for the local network.
   *  Take the host number, install it in the ipto[] array.  Then mask
   *  in my IP number's network portion to build the final IP address.
   */

  if ('#' == machine[0]) {		/* on my local network */
    netgetip(myipnum);
    netgetmask(xmask);			/* mask of network portion of IP # */

    sscanf(&machine[1],"%ld",&hnum);/* host number for local network */
    for (i=3; i >= 0; i--) {
      ipto[i] = hnum & 255L;	/* take off a byte */
      hnum >>= 8;				/* shift it over */
    }

    for (i=0; i < 4; i++) 
      ipto[i] |= (myipnum[i] & xmask[i]);		/* mask new one in */

  }
  /*
   *  next, is it an IP number?  We take it if the number is in four
   *  parts, separated by periods.
   */
  else 
    if (4 == sscanf(machine,"%d.%d.%d.%d",&i,&j,&k,&l)) {	/* given ip num */
      ipto[0] = i;
      ipto[1] = j;
      ipto[2] = k;
      ipto[3] = l;
    }
  /*
   *  lastly, it must be a name, first check the local host table
   */
    else {									/* look it up */

      m = Shostlook(machine);
      if (m == NULL) {
#ifdef CONSOLE_VERBOSE
	netposterr(805);			/* informative */
#endif
	return(NULL);
      } 
      if (m->mstat < HAVEIP) {
#ifdef CONSOLE_VERBOSE
	netposterr(806);			/* informative */
#endif
	return(NULL);
      }
    }

  if (!m) {
    /* Use the default entry for this IP address. */
    m = Shostlook("default");
    movebytes(m->hostip,ipto,4);
    m->mstat = HAVEIP;
  }

  return(m);
}

/************************************************************************/
/*  Shostlook
 *   The straightforward list searcher.  Looks for either the
 *   session name matching or the host name matching.  NULL if neither.
*/
struct machinfo 
*Shostlook(hname)
     char *hname;
{
  struct machinfo *m;
  m = Smachlist;
  while (m != NULL) {

    if (m->sname && !ncstrcmp(hname,m->sname)) 
      return(m);

    m = m->next;
  }

  m = Smachlist;
  while (m != NULL) {
    if (m->hname && !ncstrcmp(hname,m->hname))
      return(m);

    m = m->next;
  }

  return(NULL);

}

/************************************************************************/
/*  Slooknum
 *   get the host record by machine number, used primarily in DOMAIN name
 *   lookup.
*/
struct machinfo 
*Slooknum(num)
     int num;
{
  struct machinfo *m;

  m = Smachlist;
  while (m) {
    if (m->mno == num)
      return(m);
    m = m->next;
  }

  return(NULL);

}

/**************************************************************************/
/*  Slookip
 *   For FTP to look up the transfer options to use when running
 *
*/
struct machinfo 
*Slookip(ipnum)
     unsigned char *ipnum;
{
  struct machinfo *m;

  m = Smachlist;
  while (m) {
    if (comparen(m->hostip,ipnum,4))
      return(m);
    m = m->next;
  }

  return(NULL);

}

/**************************************************************************/
/*  Sissep
 *   is the character a valid separator for the hosts file?
 *   separators are white space, special chars and :;=
 *
*/
Sissep(c)
     int c;
{
  if (c < 33)
    return(1);
    if (c == ';' || c == '=')
      return(1);
  return(0);
}

/*********************************************************************/
/*  Snewns()
 *   Rotate to the next nameserver
 *   Chooses the next highest number from the nameserv field
 */
Snewns()
{
  struct machinfo *m,*low;
  int i;

  if (!Sns)					/* safety, should never happen */
    Sns = Smachlist;

  low = Sns;
  i = Sns->nameserv;			/* what is value now? */

  m = Smachlist;
  while (m) {
    if (m->nameserv == i+1) {
      Sns = m;
      return(0);
    }
    if ((m->nameserv > 0) && (m->nameserv < low->nameserv))
      low = m;
    m = m->next;
  }

  if (Sns == low)
    return(1);				/* no alternate */
  else
    Sns = low;

  return(0);
}


/************************************************************************/
/*  setgates
 *   set up the gateway machines and the subnet mask after netinit()
 *   and start up ftp and rcp for them.
*/
Ssetgates()
{
  struct machinfo *m;
  int level,again;

  if (Scon.havemask)					/* leave default unless specified */
    netsetmask(Scon.netmask);
  /*
   *  Search the list of machines for gateway flags.
   *  Invoke netsetgate in increasing order of gateway level #s.
   *  Terminates when it gets through list without finding next higher number.
   */
  level = 0;
  do {
    level++;
    again = 0;
    m = Smachlist;
    while (m != NULL) {
      if (m->gateway == level && m->mstat >= HAVEIP) 
	netsetgate(m->hostip);
      if (m->gateway == level+1)
	again=1;
      m = m->next;
    }
  } while (again);

  Sftpmode(Scon.ftp);
  Srcpmode(Scon.rcp);
  return(0);
}

/* End of confile.c */
