/* $Id: NEWKEYS.C 1.3 1999/01/09 06:07:35 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/APPS/TELNET/RCS/NEWKEYS.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

/* module newkeys.c - routines to handle the new keycode stuff */

#include <alloc.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "windat.h"
#include "newwin.h"
#include "nkeys.h"
#include "vsdata.h"
#include "netevent.h"
#include "hostform.h"
#include "mem.h"
#include "newkeys.h"
#include "def_key.h"

/* #define	DEBUG	1 */

extern	int	Command_Key(Macro *M, struct twin *t, char *arg); 

static	Macro	Macros[]={
#include "commands.h"
  "",0,NULL
};

KeyLib	*KeyLibs;		/* our currently loaded keylibs */
extern int kbcodes;
extern struct config Scon;
KeyLib	*Default_Key;
KeyLib	*Default_Key_Config;	/* from config.tel */
int	Key_silent;		/* true if we are to be quiet */

Key_Init()			/* initializes keys */
{
  struct machinfo *mp;

  n_chkchar();		/* sets kbcodes */

  if(mp = Shostlook("default")) {
    if(mp->keymap) {
      Default_Key_Config = Key_Load_File(mp->keymap);
    }
  }
  if(kbcodes & 0x10) {	/* extended */
    Default_Key = &default_tbl_Ext_KeyLib;
  }
  else {
    Default_Key = &default_tbl__KeyLib;
  }
}


Macro
*Key_Find_Macro(name)		/* looks for macro name */
     char	*name;
{
  int	x;
  Macro *m = Macros;

  for(x=0; x < (sizeof(Macros)/sizeof(Macro)); x++) {
    if(!stricmp(name,m->M_Ident))
      return(m);
    m++;
  }
  return(NULL);
}

KeyLib
*Key_Find_Lib(name)		/*  returns the named lib or NULL */
     char	*name;		/* not case sensitive */
{
  KeyLib *k = KeyLibs;

  while(k) {
    if(!ncstrcmp(k->Key_name, name))
      return(k);
    k = k->Key_next;
  }
  return(NULL);
}

int
Key_Free_Lib(KL)		/* free keymap if appropriate */
     KeyLib *KL;
{
  KeyLib *k = KeyLibs;

  if(!(--KL->Key_Refs)) {
    if(KL->Key_Flags & KEY_FLAG_DYNAMIC) {
      if(KeyLibs == KL) {
	KeyLibs = KL->Key_next;
      }
      else {
	while(k) {
	  if(k->Key_next == KL) {
	    k->Key_next = KL->Key_next;
	    break;
	  }
	  k = k->Key_next;
	}
      }
      mem_free(KL->Key_name);
      mem_free(KL->Key_List);
      mem_free(KL->Key_Defs);
      mem_free(KL);
    }
  }
}

KeyList
*Key_Find_Key(lib, keycode, appl_mode, cursor_mode)
     KeyLib 	*lib;
     unsigned int keycode;
     int	appl_mode;		/* true if in appl mode */
     int	cursor_mode;		/* true if in cursor mode */
{
  KeyList	*kl,*kb,*kt,*best;
  KeyDefs	*kd;
  int	jump,offset;

  kl = kb = lib->Key_List;
  kt = kb + lib->Key_Entries;
  jump = lib->Key_Entries;
  if(jump < 10) {			/* a linear search is better */
  linear:;
    while(kl->Key_keycode < keycode && kl < kt)
      kl++;
    if(kl == kt || kl->Key_keycode != keycode)
      return(NULL);		/* not found */
    best = NULL;
    while(kl->Key_keycode == keycode && kl < kt) {
      switch (kl->Key_mode) {

      case KEYMODE_ANY :
	if(!best)
	  best = kl;
	break;
      case KEYMODE_APPL :
	if(appl_mode)
	  best = kl;
	break;
      case KEYMODE_NOTAPPL :
	if(!appl_mode)
	  best = kl;
	break;
      case KEYMODE_CURSET :
	if(cursor_mode)
	  return(kl);

      } /* end switch */
      kl++;
    }	/* end while */
    return(best);
  }

  /* else do a binary search to get in the vicinity */
  kt--;
  while(kb <= kt) {
    kl = kb + ( (kt - kb) >> 1);
    if(keycode < kl->Key_keycode)
      kt = kl - 1;
    else if(keycode > kl->Key_keycode)
      kb = kl + 1;
    else {		/* found it */
      kb = lib->Key_List;
      while(kl->Key_keycode == keycode && kl > kb)
	kl--;	/* find first occurance */
      kt = kb + lib->Key_Entries;
      kb = kl;
#ifdef	JUNK
      while(kb < kl && kb->Key_keycode == keycode)
	kb++;
      kt = kb;
#endif
      goto linear;

    }
  }	/* end while */
  return(NULL);			/* not found */
	       	
}

void
vt100key(keycode)			/* our VT100 key */
     unsigned int keycode;
{
  KeyLib	*KL;
  KeyList	*kl;
  KeyDefs	*kd;
  int	choices = 4;
  if(VSvalids(current->vs))
    return;

  KL = kl = NULL;
#ifdef	TRASH
  if(current->key_prefix) {
    if((current->key_prefix & KEY_NOPREFIX_MASK) != keycode)
      keycode |= (current->key_prefix & KEY_PREFIX_MASK);
    current->key_prefix = 0;
  }
#endif
  while(!kl && --choices)  {
    switch	(choices) {
    case 1 :	/* select vt100 internal mode */
      KL = Default_Key;
      break;
    case	2 :	/* default from default in config */
      KL = Default_Key_Config;
      break;
    case	3 :	/* the user's default map */
      KL = current->key_map;
      break;

    } /* end switch */
    if(KL != NULL) {

      kl = Key_Find_Key(KL, keycode, VSIw->DECPAM, VSIw->DECCKM);
    }
  }	/* end while */
 out:;
  if(kl) {
    if(kl->Key_Is_char) {
      unsigned char c = kl->Key_char;
      netwrite(current->pnum, &c,1);
    }
    else {
      kd = ((KeyDefs*) (((char *) KL->Key_Defs) + (kl->Key_offset & KEY_OFFSET_MASK)));

      if(kl->Key_Macros) {
	Key_Macro_Process(kd,current);
	return;
      }
      netwrite(current->pnum, kd->Key_data, kd->Key_length);
    }
  }
  else {
  check:;
    if(keycode > 255) {	/* its an error for expanded keys to not
			   be mapped */
      n_play(sounds[SOUND_BADKEY]);
      return;
    }
    if(current->flags & TWIN_FLAGS_MARGIN_BELL)
      VSmarginbell(current->vs,72);
    netwrite(current->pnum, &keycode, 1);
  }
}


static
void
dumpstring(unsigned char *c, int count, struct twin *t)
{
  {
    netwrite(t->pnum, c, count);
  }


}

int
Key_Macro_Process(KeyDefs *kd, struct twin *t)
{
  Macro *M;
  unsigned char *base = kd->Key_data;
  unsigned char *c;
  int	count = kd->Key_length;
  int	macsize;
#define	MAC_MAXSIZE	64
  char	macbuff[MAC_MAXSIZE];

  c = base;
  while(count > 0) {
    switch(*c) {
    default :;
      break;
	       
    case '\\' :
      if(count > 3 && *(c + 1) == '"') { /* macro */
	unsigned char *d;

	dumpstring(base,c - base, t);
	c += 2;
	count -= 2;
	d = strchr(c,'"');
	if(!d)  {/* wow, a big bug! */
	  nprintf(CONSOLE,"Unterminated macro expansion\n");
	  return(-1);
	}
	macsize = d - c;
	if(macsize > MAC_MAXSIZE) {
	  nprintf(CONSOLE,"Oversize macro label\n");
	  return(-2);
	}
	strncpy(macbuff,c,macsize);
	macbuff[macsize] = 0;
	if(M = Key_Find_Macro(macbuff)) {
	  if((M->M_code & MCODE_FUNCTION) &&
	     M->M_func) { /* function call */
	    char argbuff[64];
	    char *i,*z;
	    int l;

	    z = NULL;
	    if(*(d+1) == '(') {
	      if((i  = strchr(d+1,')')) &&
		 ((i - kd->Key_data) <= kd->Key_length) &&
		 ((l = i - (d + 2)) < 64)  &&
		 l) {
		strncpy(argbuff,d+2,l);
		argbuff[l] = 0;
		count -= (l + 2);
		z = argbuff;
		d = i;
	      }
	    }
	    ((int (*)()) M->M_func)(M,t,z);

	  }
	  else if(M->M_code & MCODE_STRING) {
	    dumpstring((char *) M->M_func, strlen( (char *) M->M_func), t);
	  }

	}
	count -= (macsize + 1);
	c = base = d + 1;
	continue;
      }
      break;
    } /* end switch */
    c++;
    count--;
  }
  if(c - base) {	/* chars trailing macro */
    dumpstring(base, c - base, t);	        
  }
  return(0);
}

/* End of newkeys.c */
