hcD      D     ]65	.  Reads and displays one byte from port.
	 # Like Trace, but executes a call,loop, interrupt, or
repeated string instruction as one instruction.
=addr : where to start the trace. Default is CS:IP
value : no. of instructions to "proceed"
	, $ Quit DEBUG without saving the file

	 where range is range to compare and address is where to
start (default is DS). 
E.G. C CS:100 L0F CS:110 (compare 16 bytes starting at
CS:100 with the next 16 bytes.)

Along the same lines of Dump and Search commands, we have the Compare command.  Compare will take two blocks of memory and compare them, byte for byte. If the two addresses do not contain the same information, both addresses are displayed, with their respective data bytes.  As an example, we will compare DS:0100 with DS:0200 for a length of 8.

   -d 0100 l 8 0200
   6897:0100 E9 65 6897:0200
   6897:0101 6B 70 6897:0201
   6897:0102 01 74 6897:0202
   6897:0103 43 65 6897:0203
   6897:0104 4C 6D 6897:0204
   6897:0105 4F 62 6897:0205
   6897:0106 43 65 6897:0206
   6897:0107 4B 72 6897:0207

None of the eight bytes compared, so we got output for each byte.  If we had gotten a match on any of the bytes, DEBUG would have skipped that byte. if all of the locations requested matched, DEBUG would have simply responded with another prompt.  No other message is displayed.  This is useful for comparing two blocks of 
data from a file, or a program with the BIOS ROM.  Otherwise, I have not found a great amount of use for it.
	F
 Replaces bytes at address with bytes in list or allows
sequential editing of bytes starting at address
E.G. E DS:10'HP 95LX'0 will enter the string followed by
a null byte.

The Enter command is used to place bytes of data in
memory.  It has two modes: Display/Modify and Replace.
The difference is in where the data is specified - in
the Enter command itself, or after the prompt.

If you enter E address alone, you are in
display/modify mode. DEBUG will prompt you one byte at
a time, displaying the current byte followed by a
period.  At this time, you have the option of entering
one or two hexadecimal characters.  If you hit the
space bar, DEBUG will not modify the current byte, but
go on to the next byte of data.  If you go too far,
the hyphen (-) will back up one byte each time it is
pressed.

   E 103
   6897:0103 43.41  4C.42  4F.43  43.   4B.45
   6897:0108 2E.46  41.40  53.-
   6897:0109 40.47  53.

In this example, we entered E 103.  DEBUG responded
with the address and the information at that byte
(43).  We entered the 41 and DEBUG automatically
showed the next byte of data (4C). Again, we entered
42, debug came back. The next byte was 4F, we changed
it to 43. At 106, 43 was fine with us, so we just hit
the space bar. DEBUG did not change the data, and went
on to the following bytes. After entering 40 at
location 109, we found we had entered a bad value. The
hyphen key was pressed, and DEBUG backed up one byte,
displaying the address and current contents. Note that
it has changed from the original value (41) to the
value we typed in (40).  We then type in the correct
value and terminate by pressing the ENTER key.

As you can see, this can be very awkward, especially
where large amounts of data are concerned.  Also, if
you need ASCII data, you have to look up each
character and enter its hex value.  Not easy, to be
sure.  That's where the Replace mod of operation comes
in handy.  Where the Display/Modify mode is handy for
changing a few bytes at various offsets, the Replace
mode is for changing several bytes of information at
one time.  Data can be entered in hexadecimal or
character format, and multiple bytes can be entered at
one time without waiting for the prompt. If you wanted
to store the characters 'My name' followed by a
hexadecimal 00 starting at location 103, you would
enter:

   E 103 'My name' 0

As in the Search command, data can be entered in
character (in quotes) or hexadecimal forms and can be
mixed in the same command.  This is the most useful
way of entering large amounts of data into memory.

	 The Fill command is useful for storing a lot of data
of the same data. It differs from the Enter command in
that the list will be repeated until the requested
amount of memory is filled. If the list is longer than
the amount of memory to be filled, the extra items are
ignored.  Like the Enter command, it will take
hexadecimal or character data.  Unlike the Enter
command, though, large amounts of data can be stored
without specifying every character.  As an example, to
clear 32K (8000h) of memory to 00h, you only need to
enter:

   F 0 L 8000 0

Which translates into Fill, starting at DS:0000 for a
Length of 32K (8000) with 00h.  If the data were
entered as '1234', the memory would be filled with the
repeating string '123412341234', etc.  Usually, it is
better to enter small amounts of data with the Enter
command, because an error in the length parame-ter of
the Fill command can destroy a lot of work. The Enter
command, however, will only change the number of bytes
actually entered, minimizing the effects of a
parameter error.

E.G. to fill the video ram with '+' use
F B000:0 Laf0 '+'07
-- to fill it with white on black use
F B000:0 Laf0 '+'70

	d [=addr] : if specified, execution starts at CS:addr
[addr[addr...]] : breakpoints--up to 10
E.G. G=200 240 starts running the program at CS:200 and stops(breaks) when it gets to CS:240.

The Go command is used to start program execution.  A
very versatile command, it can be used to start the
execution at any point in the program, and optionally
stop at any of ten points (breakpoints) in the
program.  If no breakpoints are set (or the
breakpoints are not executed), program execution
continues until termination, in which case the message
"Program terminated normally" is sent.  If a
breakpoint is executed, program execution stops, the
current registers are displayed, and the DEBUG prompt
is displayed. Any of the DEBUG commands can be
executed, including the Go command to continue
execution. Note that the Go command CANNOT be
terminated by Cntl-break.  This is one of the few
commands which cannot be interrupted while executing.

   -g =100

The Go command without breakpoints starts program
execution at the address (in this case CS:0100) in the
command.  The equal sign before the address is
required.  (Without the equal sign, the address is
taken as a breakpoint.) If no starting address is
specified, program execution starts at CS:IP.  In this
case, since no breakpoints are specified, CLOCK.COM
will continue execution until the cntl-break key is
pressed and the program terminates.  At this time, you
will get the message "Program terminated normally".
Note that, after the termination message, the program
should be reloaded before being executed. Also, any
memory alterations (storing data, etc.) will not be
restored unless the program is reloaded.

   -g 276 47c 528 347

This version of the control command will start the
program and set breakpoints at CS:276, CS:47C, CS:528
and CS:347.  These correspond to locations in
CLOCK.COM after the screen is cleared, and the day,
date and time are dis-played, respectively.  The
program will stop at whichever breakpoint it hits
first.  Note that the second and third breakpoints
will only be displayed at two times - when the program
is started and at midnight.  If you care to stay up
(or just change the time in the computer), and set a
breakpoint at 47C, t will stop when the program is
started, and again at midnight.

Some notes about breakpoints. The execution stops just
before the instruc-tion is executed. Setting a
breakpoint at the current instruction address will not
execute any instructions. DEBUG will set the
breakpoint first, then try to execute the instruction,
causing another breakpoint. Also, the breakpoints use
Interrupt 3 to stop execution.  DEBUG intercepts
interrupt 3 to stop the pro-gram execution and display
the registers.  Finally, breakpoints are not saved
between Go commands. Any breakpoints you want will be
have to be set with each Go command.
	
 Shows sum and difference of the 2 values.
E.G. -H ace 123 yields 0BF1 09AB

The Hexarithmetic command is handy for adding and
subtracting hexadecimal numbers. It has just two
parameters - the two numbers to be added and
subtrac-ted.  DEBUG's response is the sum and
difference of the numbers.  The numbers can be one to
four hexadecimal digits long.  The addition and
subtraction are unsigned, and no carry or borrow is
shown beyond the fourth (high order) digit.

   -h 5 6
   000B FFFF
   -h 5678 1234
   68AC 4444
   -

In the first example, we are adding 0005 and 0006.
The sum is 000B, the difference is -1.  However, since
there is no carry, we get FFFF.  In the second
example, the sum of 5678 and 1234 is 68AC, and the
difference is 4444.

	 addr : where to load--default is CS
Loads disk sectors into memory.
E.G. L DS:0 0 5 1
loads first directory sector of drive A
-OR-
L addr 
uses Name to tell debug to load the file.

The Load command has two formats. The first one will
load a program which has been specified by the Name
command into storage, set the various registers, and
prepare for execution.  Any program parameters in the
Name command will be set into the Program Segment
Prefix, and the program will be ready to run. If the
file is a .HEX file, it is assumed to have valid
hexadecimal characters representing memory values, two
hexadecimal characters per byte. Files are loaded
starting at CS:0100 or at the address specified in the
command.  For .COM. .HEX and .EXE files, the program
will be loaded, the registers set, and CS:IP set to
the first instruction in the program. For other files,
the registers are undetermined, but basically, the
segment registers are set to the segment of the PSP
(100h bytes before the code is actually loaded), and
BX and CX are set to the file length. Other registers
are undetermined

   -n clock.com
   -l


This sequence will load clock.com into memory, set IP
to the entry point of 0100, and CX will contain 0446,
the hexadecimal size of the file. The program is now
ready to run.

The second form of the Load command does not use the
Name command. It is used to load absolute sectors from
the disk (hard or soft) into memory.  The sector count
starts with the first sector of track 0 and continuing
to the end of the track.  The next sector is track 0,
second side (if double sided), and continues to the
end of that sector.  Then, back to the first side,
track 1, and so on, until the end of the disk.  Up to
80h (128d) sectors can be loaded at one time.  To use,
you must specify starting address, drive (0=A, 1=B,
etc.), starting sector, and number of sectors to load.

   -l 100 0 10 20

This instruction tells DEBUG to load, starting at
DS:0100, from drive A, sector 10h for 20h sectors.
drive (0=A, 1=B, etc.), starting sector, and number of
sectors to load.

This instruction tells DEBUG to load, starting at
DS:0100, from drive A, sector 10h for 20h sectors.
DEBUG can sometimes be used this way to recover part
of the information on a damaged sector.  If you get an
error, check the memory location for that data.  Often
times, part of the data has been transferred before
the error occurs and the remainder (especially for
text files) can be manually entered.  Also, repetitive
retrys will sometimes get the information into memory.
This can then be rewritten on the same diskette (see
the Write command below), or copied to the same sector
on another diskette. In this way, the data on a
damaged disk can sometimes be recovered.
	
 COPIES bytes of range to address
range: range to COPY from
addr : address to COPY to
E.G. M B000:0 LDF B000:A0 
Copies the first three lines of the 95LX screen down one
line.
The Move command does just what it says - it moves
data around inside the machine.  It takes bytes from
with the starting address and moves it to the ending
address.  If you need to add an instruction into a
program, it can be used to make room for the
instruction.  Beware, though.  Any data or labels
referenced after the move will not be in the same
place.  Move can be used to save a part of the program
in free memory while you play with the program, and
restore it at any time.  It can also be used to copy
ROM BIOS into memory, where it can be written to a
file or played with to your heart's content.  You can
then change things around in BIOS without having to
worry about programming a ROM.

   M 100 L 200 ES:100

This will move the data from DS:0100 to DS:02FF
(Length 200) to the address pointed to by ES:0100.
Later, if we want to restore the data, we can say:

   M ES:100 L 200 100

which will move the data back to its starting point.
Unless the data has been changed while at the
temporary location (ES:0100), we will restore the data
to its original state.
	  Changes the current filename

There are two ways to start DEBUG with a file. Both
ways produce the same results, and either can be used.

In the Command Line:  A>debug clock.com <ENTER>

Separate from the command line:  A>debug <ENTER>
                                 -n clock.com
                                 -l

With either method, you will get the DEBUG prompt of a
hyphen (-). DEBUG has loaded your program and is ready
to run.  The description of each instruc-tion will
assume this as a starting point, unless otherwise
mentioned.  If at any time you get different results,
check your procedure carefully. The Name command has
just one purpose - specifying the name of a file which
DEBUG is going to Load or Write. It does nothing to
change memory or execute a program, but does prepare a
file control block for DEBUG to work with. If you are
going to load a program, you can specify any
parameters on the same line, just like in DOS.  One
difference is, the extension MUST be specified.  The
default is no extension.  DEBUG will load or write any
file, but the full file name must be entered.

   -n chkdsk.com /f

This statement prepares DEBUG for loading the program
CHKDSK.COM passing the /f switch to the program.  When
the Load (see below) command is executed, DEBUG will
load CHKDSK.COM and set up the parameter list (/f) in
the program's input area.


	8( range: range to search
list : bytes to search for
E.G. : S CS:100 L100 'Switch' searches the first 256
bytes of a program for the word 'Switch'.
S 100 27F A "like" searches for char(10)+like between
offsets 100h and 27Fh

Search is used to find the occurrence of a specific
byte or series of bytes within a segment.  The address
parameters are the same as for the Dump command, so we
will not duplicate them here. However, we also need
the data to be searched for.  This data can be entered
as either hexadecimal or character data. Hexadecimal
data is entered as bytes, with a space or a comma as
the separator.  Character data is enclosed by single
or double quotes.  Hex and character data can be mixed
in the same request, i.e. S 0 l 100 12 34 'abc' 56 is
valid, and requests a search from DS:0000 through
DS:00FF for the sequence of 12h 34h a b c 56h, in that
order. Upper case characters are different than lower
case characters, and a match will not be found if the
case does not match.  For instance, 'ABC' is not the
same as 'abc' or 'Abc' or any other combination of
upper and lower case characters. However, 'ABC' is
identical to "ABC", since the single and double quotes
are separators only.

An example is looking for the string 'Sat'. Here's
what would happen:

   -S 0 l 0 'Sat'
    6897:0235
   -
Again, the actual segment would be different in your
system, but the offset should be the same.  If we then
displayed the data, we would find the string
'Saturday' at this location. We could also search on
'turda', or any other combination of characters in the
string.  If we wanted to find every place we did an
Int 21h (machine code for Int is CD), we would do the
following:

   -S 0 l 0 cd 21
   6897:0050
   6897:0274
   6897:027F
   6897:028B
   6897:02AD
   6897:02B4
   -
	* =addr: where to start the trace. Default is CS:IP
value: no of instructions to trace
E.G. : T = 102 3 
traces three instructions starting at CS:102

Along the same lines as Go is the Trace command.  The
difference is that, while Go executes a whole block of
code at one time, the Trace command executes
instructions one at a time, displaying the registers
after each instruction. Like the Go instruction,
execution can be started at any address.  The start
address again must be preceeded by an equal sign.
However, the Trace command also has a parameter to
indicate how many instructions are to be executed.

   -t =100 5

This Trace command will start at CS:100 and execute
five instructions. Without the address, execution will
start at the current CS:IP value and continue for five
instructions. T alone will execute one instruction.

When using Trace to follow a program, it is best to go
around calls to DOS and interrupts, as some of the
routines involved can be lengthy.  Also, DOS cannot be
Traced, and doing so has a tendency to hang the
system.  Therefore, Trace to the call or interrupt and
Go to the next address after the call or interrupt.
	[- OR W[addr]
Writes to disk or file
addr: where to write from. Def=CS
E.G.: W DS:0 0 5 1 writes first directory sector of 
Drive A:
If just addr, then BX:CX must contain the number of bytes
to write.

The write command is very similar to the Load command.
Both have two modes of operation, and both will
operate on files or absolute sectors. As you have
probably guessed, the Write command is the opposite of
the Load command. Since all the parameters are the
same, we will not cover the syntax in detail. However,
one thing worth mentioning: When using the file mode
of the Write command, the amount of data to be written
is specified in BX and CX, with BX containing the
high-order file size.  The start address can be
specified or is defaulted to CS:0100.  Also, files
with an extension of .EXE or .HEX cannot be written
out, and error message to that effect will be
displayed. If you do need to change a .EXE or .HEX
file, simply rename and load it, make your changes,
save it and name it back to its original filename.

   -

This is the Line input port for the first Asynchronous
adapter. Your data may be different, as it depends on
the current status of the port.  It indicates the data
in the register at the time it was read was 7Dh.
Depending on the port, this data may change, as the
ports are not controlled by the PC.

	U 8088 MPU can access 1 Meg of CONVENTIONAL MEMORY but 
only 640K is allowed.

80286 has 2 operating modes. 1) mimics the 8088 [This 
is called PROTECTED MODE]. 2) REAL MODE which can 
access 16 Meg of memory. Since this chip extends the 
memory beyond 1 meg, it is called EXTENDED MEMORY.

MEMORY ADDRESSES:

  0...640K     640...1024K    1024...1408k
Conventional  384K High Mem  Extended Memory

High mem is used for BIOS, video, etc.

EXPANDED MEMORY

Lotus,Intel, Microsoft(LIM) devised a standard to get 
around the 640k barrier. LIM ExPANDED MEMORY SPECIFI- 
CATION (EMS)

Expanded Memory (EMS) is on add-in boards. EMS is 
divided into 16k groups (pages). Four "pages" = a 64K 
page frame. The page frame is a) switched with the 
base memory or b) mapped into available space in the 
HIGH memory area. This is called page swapping. This 
tricks DOS  into using up to 32M of memory. The 
program that does the swapping is called an EMM 
(Expanded Memory Manager).

Since EMM can use memory below 640k, it can run on an 
8088 machine. EXTENDED memory will only operate on a 
'286 or greater.

The 100LX should be able to use BLOC's Above640 to 
increase base memory by 96K (if it had an EGA card), 
and PopDrop to manage TSR's in base memory, and 
AboveDisc to turn "hard disk" into EMS. (Expanded 
Memory Simulator).	
 N TODAY.COM
A 100
MOV AH,2A
INT 21
MOV AL,DL
MOV AH,4C
INT 21

R CX
A
W
Q

CREATES AN ERRORLEVEL FROM 1 TO 31 BASED ON DATE

REM BATCH FILE
TODAY
IF ERRORLEVEL 15 IF NOT ERRORLEVEL 16 GOTO 15TH
REM OTHER COMMANDS HERE
:15TH
REM COMMANDS FOR 15TH
	 / N SHOWCMD.COM
A 100
MOV BX,80
INC BX
MOV DL,BYTE [BX]
MOV AH,02
INT 21
CMP DL,D
JNE 103
MOV AH,4C
INT 21

R CX
13
W
Q

SHOWS WHAT IS ON THE DOS COMMANDLINE.	 0 N KBDFLUSH.COM
A 100
MOV AX,C06
MOV DL,FF
INT 21
MOV AH,4C
INT 21

R CX
B
W
Q

FLUSHES THE KBD BUFFER. USEFUL IN BATCH FILES IN WHICH A USER MIGHT PRESS MORE KEYS THEN NEEDED AND THUS SCREW UP EXECUTION OF THE BATCH FILE.	2 N TODAYIS.COM
A 100
MOV AH,2A
INT 21
MOV AH,4C
INT 21

R CX
8
W
Q

RETURNS ERRORLEVEL 0..6 WITH SUNDAY=0

@ECHO OFF
TODAYIS
IF ERRORLEVEL 0 IF NOT ERRORLEVEL 1 ECHO TODAY IS SUNDAY
IF ERRORLEVEL 1 IF NOT ERRORLEVEL 2 ECHO TODAY IS MONDAY
IF ERRORLEVEL 2 IF NOT ERRORLEVEL 3 ECHO TODAY IS TUESDAY
IF ERRORLEVEL 3 IF NOT ERRORLEVEL 4 ECHO TODAY IS WEDNESDAY
IF ERRORLEVEL 4 IF NOT ERRORLEVEL 5 ECHO TODAY IS THURSDAY
IF ERRORLEVEL 5 IF NOT ERRORLEVEL 6 ECHO TODAY IS FRIDAY
IF ERRORLEVEL 6 ECHO TODAY IS SATURDAY
	 3 N AM_PM.COM
A 100
MOV AH,2C
INT 21
CMP CH,C
JGE 10D
MOV AL,0
JMP 10F
MOV AL,1
MOV AH,4C
INT 21

R CX 
13
W
Q

RETURNS 0 IF AM

@ECHO OFF
AM_PM
IF NOT ERRORLEVEL 1 ECHO GOOD MORNING
IF ERRORLEVEL 1 ECHO GOOD DAY
	U4 N MONTH.COM
A 100
MOV AH,2A
INT 21
MOV AL,DH
MOV AH,4C
INT 21

R CX
A
W
Q

RETURNS 1..12 DEPENDING ON MONTH

@ECHO OFF
IF ERRORLEVEL 1 IF NOT ERRORLEVEL 2 TYPE EVENTS.JAN
IF ERRORLEVEL 2 IF NOT ERRORLEVEL 3 TYPE EVENTS.FEB
IF ERRORLEVEL 3 IF NOT ERRORLEVEL 4 TYPE EVENTS.MAR
...
IF ERRORLEVEL 12 TYPE EVENTS.DEC

	 5 N YEAR.COM
A 100
MOV AH,2A
INT 21
SUB CX,76C
MOV AX,CX
MOV AH,4C
INT 21

R CX
E
W
Q

RETURNS LAST 2 DIGITS IN CURRENT YEAR

	6 N NEWPAUSE.COM
A 100
JMP 123
DB A,D,'Press any key to continue...',A,D,'$'
MOV Cl,[80]
MOV BX,82
CMP CL,1
JE 139
MOV AH,2
MOV DL,[BX]
INT 21
DEC CX
INC BX 
JMP 12A
MOV AH,9
MOV DX,102
INT 21
MOV AH,8
INT 21
CMP AL,0
JE 141
MOV AH,4C
INT 21

R CX
4C
W
Q

THE PAUSE COMMAND SHOULD ALLOW FOR A MESSAGE, BUT IF ECHO OFF IS IN EFFECT, THAT WON'T HAPPEN. INSTEAD YOU GET "PRESS ANY KEY..."

@ECHO OFF
NEWPAUSE message
rem other commands

	7 N PAWSE.COM
A 100
JMP 120
DB A,D,'$'
DB 'Press Enter to continue...$'
MOV AH,9 
MOV DX,105
INT 21
MOV AH,8
INT 21
CMP AL,D
JNE 127
MOV AH,9
MOV DX,102
INT 21
MOV AH,4C
INT 21

R CX
3A
W
Q

CREATES A PAUSE COMMAND THAT ALLOWS FOR _ONLY_ ENTER TO BE PRESSED.
	 E N CHECKKEY.COM
A 100
MOV AH,B
INT 21
AND AL,1
MOV AH,4C
INT 21

R CX
A
W
Q

SIMILAR TO KEYPRESSED

@ECHO OFF
:LOOP
DIR
CHECKKEY
IF NOT ERRORLEVEL 1 GOTO LOOP

REPEATEDLY DOES DIR UNTIL KEY PRESSED
	 G N CKDOSKEY.COM
A 100
MOV AX,4800
INT 2F
CMP AL,0
JE  10B
MOV AL,1
MOV AH,4C
INT 21

R CX
F
W
Q

CHECKS TO SEE IF DOSKEY IS LOADED

	 H N DISKFLSH.COM
A 100
MOV AH,0D
INT 21
MOV AH,4C
INT 21

R CX
8
W
Q

USEFUL IN A BATCH FILE THAT PROGRAMMATICALLY
DOES A WARM BOOT

@ECHO OFF
DISKFLSH
WARMBOOT

PUTS EVERYTHING IN THE BUFFER TO THE DISK.
	 I N DOSMAJOR.COM
A 100
MOV AX,3000
INT 21
MOV AH,4C
INT 21

R CX
9
W
Q

RETURNS THE MAJOR VERSION OF DOS AS AN
ERRORLEVEL
	 J N DOSMINOR.COM
A 100
MOV AX,3000
INT 21
MOV AL,AH
MOV AH,4C
INT 21

R CX
B
W
Q

RETURNS THE MINOR VERSION OF DOS AS
AN ERRORLEVEL

	 M N HP_LAND.COM
A 100
JMP 108
DB 1B,'&l1O$'
MOV AH,9
MOV DX,102
INT 21
MOV AH,4C
INT 21

R CX
13
W
Q

SENDS LANDSCAPE CODE TO HP LJ
	 N N HP_PORT.COM
A 100
JMP 108
DB 1B,'&l0O$'
MOV AH,9
MOV DX,102
INT 21
MOV AH,4C
INT 21

R CX
13
W
Q

SENDS ESCAPE CODE FOR PORTRAIT
PRINTING TO HP LJ (MAYBE DJ,TOO).

	 O N KBDTYPE.COM
A 100
MOV AX,40
MOV DS,AX
MOV AL,[96]
AND AL,10
JZ  10E
MOV AL,1
MOV AH,4C
INT 21

R CX
12
W
Q

@ECHO OFF
KBDTYPE
IF ERRORLEVEL 1 GOTO ENHANCED_KEYBOARD
GOTO STANDARD_KEYBOARD
REM OTHER COMMANDS HERE
	P N LOCKOUT.SYS
A 100
DB FF, FF, FF, FF
DW 8000, 16, 21
DB "LOCKOUT "
DB 0,0,0,0
CS:
MOV WORD PTR [12], BX
CS:
MOV WORD PTR [14], ES
RETF
PUSHF
PUSH AX
PUSH SI
PUSH DI
PUSH DS
PUSH BP
PUSH CS
POP DS
LES DI, [12]
ES:
CMP BYTE PTR [DI+2], 0
JNZ 14B
CALL 152
ES:
MOV BYTE PTR [DI+0D], 0
ES:
MOV BYTE PTR [DI+0E], 0
ES:
MOV WORD PTR [DI+10], CS
ES:
MOV WORD PTR [DI+3], 100
POP BP
POP DS
POP DI
POP SI
POP AX
POPF
RETF
MOV AH, 0
INT 16
CMP AH,44
JNE 152
RET

R CX
5C
W
Q

USE DEVICE=C:\LOCKOUT.SYS

WHEN YOU BOOT YOUR SYSTEM IT WILL APPEAR TO STOP.
PRESS THE F10 KEY TO CONTINUE.

CHANGE THE CMP AH,44 TO SOME OTHER SCANCODE FOR A
DIFFERENT HOTKEY....

NOT VERY GOOD ON THE 100LX BUT MIGHT BE USEFUL.	EQ N LOWER.COM
A 100
JMP 103
DB '?'
MOV AH,3F
MOV BX,0
MOV CX,1
MOV DX,102
INT 21
CMP AX,0
JE  12A 
MOV AL,[102]
CMP AL,41
JL  122
CMP AL,5A
JG  122
ADD AL,20 
MOV DL,AL
MOV AH,02
INT 21
JMP 103
MOV AH,4C
INT 21

R CX 
2E
W
Q

DISPLAYS REDIRECTED INPUT IN LOWERCASE

LOWER < FILENAME.ASC

	 S N SHTOGGLE.COM
A 100
MOV AX,40
MOV DS,AX
XOR BYTE [17],1
MOV AH,4C
INT 21

R CX
E
W
Q

SOME PROGRAMS MAY NEED TO GET INPUT SUCH AS @, # $

USE
@ECHO OFF
SHTOGGLE
SOMEPROGRAM
SHTOGGLE

	`T N SIREN.COM
A 100
IN AL, 61 
OR AL, 3
OUT 61, AL
MOV CH, 10  
MOV AL, B6
OUT 43, AL
MOV AL, 0
OUT 42, AL
MOV AL, CH
OUT 42, AL
MOV BX, 8000  
DEC BX
CMP BX, 0
JNE 117
MOV DL, FF    
MOV AH, 6
INT 21
JNZ 12E
DEC CH   
CMP CH, 0
JNE 108
JMP 106
IN AL, 61    
AND AL, FC
OUT 61, AL
MOV AH, 4C  
INT 21

R CX
38
W
Q
	FV N UPPER.COM
A 100
JMP 103
DB '?'
MOV AH,3F
MOV BX,0
MOV CX,1
MOV DX,102
INT 21
CMP AX,0
JE  12A 
MOV AL,[102]
CMP AL,61
JL  122
CMP AL,7A
JG  122
SUB AL,20 
MOV DL,AL
MOV AH,02
INT 21
JMP 103
MOV AH,4C
INT 21

R CX 
2E
W
Q

CONVERTS REDIRECTED INPUT TO UPPER CASE

UPPER < TEXTFILE.DOC

	| W A STARTING AND ENDING ADDRESS OR

A STARTING ADDRESS WITH A LENGTH PRECEDED BY L

E.G. D 100 110
     D 100 L10
	 X A LIST OF HEX BYTE VALUES SEPARATED BY A SPACE,COMMA, OR 
TAB;  E DS:100 1 2 3

OR A STRING OF ASCII CHARACTERS ENCLOSED IN SINGLE OR DOUBLE QUOTES  E DS:100 "HELLO"

	Y PROGRAM SEGMENT PREFIX (PSP) a 256 byte header at the start of 
each file.

CONTENTS

 01 INT 20 INSTRUCTION
 02 TOP OF MEMORY SEGM ADDRESS
 04 RESERVED
 05 FAR CALL TO DOS DISPATCHER
 0A INT 22 VECTOR
 0E INT 23 VECTOR
 12 INT 24 VECTOR
 16 PARENT PSP SEGM
 18 SYSTEM FILE TABLE ENTRIES
 2C ENVIRONMENT COPY SEGM ADDRESS
 2E DOS SS:SP STORAGE
 32 FILE HANDLE COUNT
 34 POINTER TO FILE TABLE
 38 SHARE'S PREVIOUS PSP
 3C RESERVED
 50 FAR CALL TO DOS DISPATCHER
 52 RESERVED
 5C DEFAULT FCB 1
 6C DEFAULT FCB 2
 7C RESERVED
 80 COMMAND LINE BYTE LENGTH
 81 COMMAND LINE
 FF END OF COMMAND LINE

TO SEE THIS, USE  debug SAMPLE COMMAND LINE   

AT THE - PROMPT:

-D 0 L 100

          /  1 \ / 2 \    /     3      \ /    4    \ /   5
1889:0000  CD 20 00 A0 00 9A EE FE-1D F0 4F 03 ED 12 8A 03   . ........O.....
               \ /    6    \ / 7 \ /     8      \ /   9
1889:0010  ED 12 17 03 ED 12 18 12-04 05 01 00 02 FF FF FF   ................
             9        9           9          \ / 10\ /11
1889:0020  FF FF FF FF FF FF FF FF-FF FF FF FF C4 12 4E 01   ..............N.
           11  \/12\   /    13   \ /    14   \
1889:0030  AD 17 14 00 18 00 89 18-FF FF FF FF 00 00 00 00   ................
1889:0040  05 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00   ................
           /  15  \                           /16\/  17
1889:0050  CD 21 CB 00 00 00 00 00-00 00 00 00 00 43 4F 4D   .!...........COM
           17     \                           /18\/  19
1889:0060  4D 41 4E 44 20 20 20 20-00 00 00 00 00 4C 49 4E   MAND    .....LIN
           19     \     
1889:0070  45 20 20 20 20 20 20 20-00 00 00 00 00 00 00 00   E       ........
          /20\/                      21                   1889:0080  0F 20 43 4F 4D 4D 41 4E-44 20 4C 49 4E 45 20 20   . COMMAND LINE  
                              \/22\
1889:0090  0D 4C 49 4E 45 20 20 0D-0D 00 00 00 00 00 00 00   .LINE  .........
1889:00A0  00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00   ................
1889:00B0  00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00   ................
1889:00C0  00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00   ................
1889:00D0  00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00   ................
1889:00E0  00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00   ................
1889:00F0  00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00   ................

 1. Call to terminate vector
 2. Segm address of program's top of memory
 3. Call to int 21H dispatcher
 4. int 22h vector
 5. int 23h vector
 6. int 24h vector
 7. parent psp segment
 8. standard file handlers
 9. unusued file handlers
10. environment copy segment address
11. DOS SS:PP storage
12. Number of file handles (hex 14=20)
13. pointer to file table
14. share's previous PSP
15. far call to DOS dispatcher
16. Drive for FCB 1
17. Filename for FCB 1
18. Drive for FCB 2
19. Filename for FCB 2
20. Length of command line
21. Command line
22. Carriage return
	 ? N loud.com
A 100
MOV AH,48
MOV AL,3
INT 15
MOV AH,4C
INT 21

R CX
B
W
Q

SETS 100LX SPEAKER TO MAX VOLUME AND DOES NOT EFFECT SETUP SCREEN
	> n pull.com
A100
mov dx,0040
mov ds,dx
mov al,[00cc]
mov al,01
xor [00cc],al
int 20
MOV AH,4C
int 21

rcx
13
w
q

SIMULATES CARD BEING PULLED ON 95LX

echo off
ren apname.lst apname.1st
ren apname.2nd apname.lst
ren apname.1st apname.2nd
pull.com

	 @ N SOFT.COM
A 100
MOV AH,48
MOV AL,1
INT 15
MOV AH,4C
INT 21

R CX
B
W
Q

SETS 100LX VOLUME TO 1 LEVEL ABOVE 0
	^ N SHFTLOCK.COM
A100
JMP  13C                 ; JUMP TO INSTALLATION
NOP
NOP                      ;  STORAGE SPACE FOR
NOP                      ;  OLD KEYBOARD VECTOR
NOP
STI                      ; INTERRUPTS ON
PUSH AX
MOV  AH,2                ; GET SHIFT STATUS
INT  16                  ; FROM BIOS
TEST AL,3                ; IS EITHER SHIFT PRESSED?
JZ   114                 ; NO, EXIT TO BIOS
TEST AL,40               ; IS CAPSLOCK ALREADY ON?
JNZ  11A                 ; YES, DO OUR ROUTINE
POP  AX                  ; CLEAN UP STACK AND
CS:                      ; EXIT TO BIOS ROUTINE
JMP  FAR [102]
PUSH DS                  ; SAVE CALLER'S DATA SEG
MOV  AX,40               ; ADDRESS BIOS DATA AREA
MOV  DS,AX
AND  BYTE PTR [17],BF    ; MASK OFF CAPSLOCK BIT
POP  DS
POP  AX
PUSHF                    ; LET BIOS PROCESS
CS:                      ;  THIS KEYSTROKE
CALL FAR [102]
PUSH AX                  ; WHEN IT'S DONE...
PUSH DS
MOV  AX,40               ; GO TO BIOS DATA AREA
MOV  DS,AX
OR   BYTE PTR [17],40    ; MASK CAPSLOCK ON AGAIN
POP  DS                  ; CLEAN UP STACK
POP  AX
IRET                     ; AND EXIT (END OF RAM-RESIDENT CODE)
MOV  AX,3509             ; INSTALLATION: GET OLD
INT  21                  ;  KEYB VECTOR THROUGH DOS
MOV  [102],BX            ; SAVE OFFSET LOCALLY
MOV  [104],ES            ; AND SEGMENT TOO
MOV  AX,2509             ; REROUTE KEYB VECTOR CHAIN
MOV  DX,106              ; TO POINT TO OUR CODE
INT  21                  ; USING DOS
MOV  DX,13C              ; POINT TO END OF HANDLER
INT  27                  ; TERMINATE, STAY RESIDENT

RCX
56
W
Q

GOOD EXAMPLE OF A TSR WRITTEN IN DEBUG

MAINTAINS UPCASE WHEN CAPSLOCK IS ON NO MATTER IF YOU PUSH SHIFT OR NOT
	B] N WHATNDP.COM
A
JMP       0136
DB        0D,0A,"No NDP installed",0D,0A,"$"
DB        0D,0A,"NDP is an 80$"
DB        "87$"
DB        "287$"
DB        "387$"
DB        0D,0A,"$"
DB        0,0
FINIT                              ;Check for coprocessor
FSTCW     [0134]                   ;  by initializing it
CMP       BYTE PTR [0135],3        ;  and looking at the
JZ        014B                     ;  bits 8 and 9 of the
MOV       AH,9                     ;  control word
MOV       DX,0102                  ;Exit if there's nothing
INT       21                       ;  there
RET
MOV       AH,9                     ;Print opening message
MOV       DX,0117
INT       21
MOV       DX,0126                  ;Test for 8087 by seeing
AND       WORD PTR [0134],FF7F     ;  if the FDISI instruction
WAIT                               ;  sets the IEM bit in the
FLDCW     [0134]                   ;  coprocessor control word
WAIT
FDISI
WAIT
FSTCW     [0134]
TEST      WORD PTR [0134],80
JNZ       018F                     ;Branch if NDP is an 8087
MOV       DX,0129                  ;Distinguish between 287
FINIT                              ;  and 387 by determining
FLD1                               ;  whether the NDP is
FLDZ                               ;  initialized to affine
FDIVP     ST(1),ST                 ;  (387) or projective
FLD       ST(0)                    ;  (287) infinity
FCHS
FCOMPP
FSTSW     [0134]
WAIT
MOV       AX,[0134]
SAHF
JZ        018F                     ;Branch if 287
MOV       DX,012D                  ;It's a 387!
MOV       AH,9                     ;Print NDP type and exit
INT       21
MOV       AH,9
MOV       DX,0131
INT       21
RET

RCX
9B
W
Q


A GOOD EXAMPLE OF HOW TO HANDLE DB STATEMENTS IN DEBUG

TELLS WHAT, IF ANY MATH COPROCESSOR IS IN THE SYSTEM	b N SPEAKER.COM
A 100
IN   AL,61    ;GET SPEAKER STATUS
PUSH AX       ;SAVE STATUS
OR   AL,03    ;SET LOWEST 2 BITS
OUT  61,AL    ;TURN SPEAKER ON
MOV  AL,60    ;STARTING PITCH
; L2          ;DUMMY LABEL
OUT  42,AL    ;TIMER PORT: PULSES SPEAKER
MOV  CX,D000  ;HOLD THE NOTE
; L3          ;DUMMY LABEL
LOOP 0123 ; L3;DUMMY JUMP
SUB  AL,1     ;RAISE THE PITCH
JNZ  0123 ; L2;DUMMY JUMP ;PLAY ANOTHER NOTE
POP  AX       ;GET ORIGINAL STATUS
AND  AL,FC    ;CLEAR LOWEST 2 BITS
OUT  61,AL    ;SHUT OFF SPEAKER.
MOV  AX,4C00  ;RETURN TO DOS
INT  21
;END          ;DUMMY END

RCX
NN            ;DUMMY BYTE COUNT
W
Q

Clip off the comments. Push this through
deb2scr

debug < speaker.scr | deb2scr > spkr.scr
and then assemble

debug < spkr.scr

N SPEAKER.COM
A 100
IN   AL,61
PUSH AX
OR   AL,03
OUT  61,AL
MOV  AL,60
;<0109>  L2
OUT  42,AL
MOV  CX,D000
;<010E>  L3
LOOP 010E ; L3
SUB  AL,1
JNZ  0109 ; L2
POP  AX
AND  AL,FC
OUT  61,AL
MOV  AX,4C00
INT  21
;<011E> END

RCX
1E
W
Q

and play it.	<\ you can use Int 15h to detect on which machine you are running:

   mov ax, 4dd4h
   int 15h

   return:
   bh = 'H'
   bl = 'P'
   ch = Family type (= 1)
   cl = Model type  (= 1 for 95LX, 2 for 100LX)
   dl = Code revision
   int 15h

If you don't gee these values, you are running on a desktop.	)8 N DELAY10.COM
A 100
JMP 103
DB 0
MOV AH,2C
INT 21
ADD DH,A
CMP DH,3C
JL  112
SUB DH,3C
MOV [102],DH
INT 21
CMP DH,[102]
JNE 116
MOV AH,4C
INT 21

R CX
22
W
Q

DELAY10.COM WILL WAIT FOR 10 SECONDS...OR UNTIL THE USER
PRESSES A KEY BEFORE CONTINUING WITH A BATCH FILE.
		d The following batch file will grab a text or graphics
screen and save it in binary format. PROVIDED THE
SCREEN IS IN CGA 80 x 25 MODE.

@ECHO OFF
REM SAVE.BAT
ZOOM C8
REM self displaying PCX file
AMAZING /w00 /dis
BSAVE PICTURE.BIN

@ECHO OFF
REM LOAD.BAT
ZOOM C8
BLOAD PICTURE.BIN
PAUSE > NUL

ONCE YOU HAVE PICTURE.BIN, YOU CAN USE HAX ON IT TO
CONVERT IT TO AN OBJECT OR ELSE YOU CAN CREATE A
STRING OF HEX NUMBERS. EITHER WAY IT MAY BE PUT INTO
A C OR PASCAL PROGRAM .


BSAVE.SCR

N    BSAVE.COM
A
XOR  BH,BH
MOV  BL,[80]            ;get argument length
MOV  BYTE PTR [BX+81],0 ;convert arg to ascii-z
MOV  DX,82
MOV  CX,0
MOV  AH,3C              ;create a normal file
INT  21
JB   140                ;exit if error
MOV  BX,AX              ;else filehandle in BX
MOV  AX,40
MOV  DS,AX              ;BIOS data segment
MOV  AX,B000            ;monochr buffer address
MOV  CX,1000            ;4K buffer
CMP  WORD PTR [63],3B4  ;is it mono?
JZ   133                ;if yes, skip
ADD  AX,800             ;else,CGA buffer addr.
ADD  CX,3000            ;16K buffer
MOV  DS,AX              ;point to segment
MOV  DX,0               ;point to offset
MOV  AH,40              ;write image to file
INT  21
MOV  AH,3E              ;close the file
INT  21
INT  20                 ;terminate

RCX
42
W
Q

N LOWRES.COM
A 100
MOV  AX,4
INT  10
INT  20

RCX
7
W
Q

N HIGHRES.COM
A 100
MOV  AX,6
INT  10
INT  20

RCX
7
W
Q

N    BLOAD.COM
A
XOR  BH,BH    
MOV  BL,[80]            ;get arg length
MOV  BYTE PTR [BX+81],0 ;convert to asciiz
MOV  DX,82
MOV  AX,3D00            ;open file for reading
INT  21                 ;
JB   13E                ;exit if not found
MOV  BX,AX              ;else, filehandle in BX
MOV  AX,40
MOV  DS,AX              ;BIOS data segm
MOV  AX,B000            ;mono buffer addr.
MOV  CX,1000            ;4K buffer
CMP  WORD PTR [63],3B4  ;is it mono?
JZ   131                ;yes:skip
ADD  AX,800             ;else, CGA buffer addr
ADD  CX,3000            ;16K buffer
MOV  DS,AX              ;point to segment
MOV  DX,0               ;point to offset
MOV  AH,3F              ;read in file image
INT  21
MOV  AH,3E
INT  21                 ;close file
INT  20                 ;terminate

RCX
48
W
Q
	 e SEE BSAVE
	
 where addr is the address to display. Defaults to address
after prior D command. Initial default addr is CS:100
E.G. D 0 L50 means dump 80 bytes starting at DS:0.

One of the other main features of DEBUG is the ability
to display areas of storage.  Unless you are real good
at reading 8088 machine language, the Dump command is
mostly used to display data (text, flags, etc.). To
display code, the Unassemble command below is a better
choice.  If we enter the Dump command at this time,
DEBUG will default to the start of the program.  It
uses the DS register as it's default, and, since this
is a .COM file, begins at DS:0100. It will by default
display 80h (128d) bytes of data, or the length you
specify. The next execution of the Dump command will
display the following 80h bytes, and so on. For
example, the first execution of D will display DS:0100
for 80h bytes, the next one DS:0180 for 80h bytes,
etc.  Of course, absolute segment and segment register
overrides can be used, but only hex numbers can be
used for the offset,e D will display DS:0100 for 80h
bytes, the next one DS:0180 for 80h bytes, etc.  Of
course, absolute segment and segment register
overrides can be used, but only hex numbers can be
used for the offset. That is, D DS:BX is invalid.
Notice that the output from the Dump command is
divided into three parts. On the left, we have the
address of the first byte on the line. This is in the
format Segment:Offset.

Next comes the hex data at that location.  Debug will
always start the second line at a 16 byte boundary;
that is, if you entered D 109, you would get 7 bytes
of information on the first line (109-10F), and the
second line would start at 110.  The last line of data
would have the remaining 9 bytes of data, so 80h bytes
are still displayed.

The third area is the ASCII representation of the
data. Only the standard ASCII character set is
displayed.  Special characters for the IBMPC are not
displayed; rather periods (.) are shown in their
place.  This makes searching for plain text much
easier to do.

   Dump can be used to display up to 64K bytes of
data, with one restriction: It cannot cross a segment
boundary.  That is, D 0100 l f000 is valid (display
DS:0100 to DS:F0FF), but D 9000 l 8000 is not (8000h
+9000h = 11000h and crosses a segment boundary).

Since 64K is 10000h and cannot fit into four hex
characters, Dump uses 0000 to indicate 64K. To display
a complete segment, enter D 0 l 0. This will display
the total 64K segment.

If, at any time you want to suspend the display of
data, Cntl-NumLock works as usual.  If you want to
terminate the display, Cntl-Break will stop it and
return you to the DEBUG prompt.
	Z N EDPATH.COM
A
MOV  BX,0368                      ;above top of program
MOV  SP,BX                        ;new stack pointer
ADD  BX,+0F
MOV  CL,04
SHR  BX,CL                        ;convert BX to segment
MOV  AH,4A                        ;deallocate memory
INT  21
PUSH ES
MOV  ES,[002C]                    ;point to environment
SUB  DI,DI
MOV  SI,016A                      ;point to PATH=
CLD
ES:                               ;search:
CMP  BYTE PTR [DI],00             ;see if end
JZ   0133                         ;jz transfer
PUSH SI
MOV  CX,0005                      ;5 bytes to compare
REPZ                              ;compare them.
CMPSB
POP  SI
JZ   0133                         ;jz transfer
SUB  AL,AL                        ;search for next 0
MOV  CX,8000
REPNZ
SCASB
JMP  011B                         ;jump SEARCH
MOV  BX,016F                      ;transfer:                                       
MOV  CL,05                        ;number of chars already
ES:                               ;transloop:
MOV  AL,[DI]                      ;get byte
INC  DI                           ;incr pointer
OR   AL,AL
JZ   0147                         ;jz done
INC  CL                           ;incr counter
MOV  [BX],AL                      ;save byte
INC  BX
JMP  0138                         ;jump transloop:
MOV  BYTE PTR [BX],0D             ;CR at end
MOV  [0169],CL                    ;save count                    
POP  ES
MOV  DX,0168                      ;let user edit it.
MOV  AH,0A
INT  21
MOV  SI,0168                      ;fix it up
MOV  AL,[SI+01]
INC  AL
MOV  [SI],AL
MOV  BYTE PTR [SI+01],20
INT  2E                           ;execute new path
INT  20                           ;old terminate.
DB   80,00
DB   "PATH="

RCX
6F
W
Q



USAGE: at the DOS prompt, type EDPATH and press ENTER. Then use the DOS editing keys (F1...F6) to bring up the current path and insert, delete or modify anything and then store it back. For more on DOS editing keys, see any, complete, DOS Manual.

--after "PC Tutor" PCM Apr. 28,1987

DOESN'T MODIFY THE PATH ON THE 100LX WHEN RUN FROM FILER
MUST EXIT SYSMGR TO AFFECT THE MASTER ENVIRONMENT
	& Display all registers or display and modify one.
E.G.: RCX displays and edits the value of CX and prompts
for new data with ":" To change the value, enter a new 4
digit hex number. For Debug script files, use
Rregistername ^Z replacement value.

If you type in an R with no parameters, the registers
should be displayed  as so:

AX=0000 BX=0000 CX=0446 DX=0000 SP=FFFE BP=0000
SI=0000 DI=0000 DS=6897 ES=6897 SS=6897 CS=6897
IP=0100  NV UP DI PL NZ NA PE NC 6897:0100 E96B01
JMP   026E

CX contains the length of the file (0446h or 1094d).
If the file were larger than 64K, BX would contain the
high order of the size. This is very important to
remember when using the Write command, as this is the
size of the file to be written.  Remember, once the
file is in memory, DEBUG has no idea how large the
file is, or if you may have added to it.  The amount
of data to be written will be taken from the BX and CX
registers.

If we want to change one of the registers, we enter R
and the register name. Let's place 1234 (hexadecimal)
in the AX register:

   -R AX     R and AX register
   AX 0000   Debug responds with register and contents
   : 1234    : is the prompt for entering new
contents.  We respond 1234
   -         Debug is waiting for the next command.

Now if we display the registers, we see the following:

AX=1234 BX=0000 CX=0446 DX=0000 SP=FFFE BP=0000
SI=0000 DI=0000 DS=6897 ES=6897 SS=6897 CS=6897
IP=0100  NV UP DI PL NZ NA PE NC 6897:0100 E96B01
JMP   026E

Note that nothing has changed, with the exception of
the AX register. The new value has been placed in it,
as we requested. One note. The Register command can
only be used for 16 bit registers (AX, BX, etc.). It
cannot change the 8 bit registers (AH, AL, BH, etc.).
To change just AH, for instance, you must enter the
the data in the AX register, with your new AH and the
old AL values.

                   SEGMENT REGISTERS
 REGULAR
 REGISTERS   CS       SS       DS       ES
         Ŀ
    IP      YES     NO      NO      NO   
         Ĵ
    SP      NO      YES     NO      NO   
         Ĵ
            YES             YES     YES  
           with            with    with  
    BP     over-  DEFAULT  over-   over- 
           ride            ride    ride  
         Ĵ
            YES     YES             YES  
           with    with            with  
    BX     over-   over-  DEFAULT  over- 
           ride    ride            ride  
         Ĵ
            YES     YES             YES  
           with    with            with  
    SI     over-   over-  DEFAULT  over- 
           ride    ride            ride  
         Ĵ
            YES     YES   DEFAULT DEFAULT
           with    with  for non-  for   
    DI     over-   over-  string  string 
           ride    ride  operatnsoperatns
                                         
         


	F N CHKCTRL.COM
A 100
MOV AX,40
MOV DS,AX
MOV AL,[17]
AND AL,4
JZ  10E
MOV AL,1
MOV AH,4C
INT 21

R CX
12
W
Q

CHECKS TO SEE IF THE CTRL KEY WAS PRESSED.

REM
CHKCTRL
IF ERRORLEVEL 1 GOTO DONE
REM OTHER COMMANDS HERE
:DONE

CHANGE THE VALUE 4 IN LINE 6 TO USE WITH OTHER
KEY STATES.

RIGHT SHIFT 1
LEFT SHIFT  2
ALT         8
SCR LOCK   10
NUM LOCK   20
CAPS LOCK  40
INS        80

	bR N MARGIN.COM
A 100
JMP 103
DB '?'
MOV DL,9
MOV AH,2
INT 21 
MOV AH,3F
MOV BX,0
MOV CX,1
MOV DX,102
INT 21
CMP AX,0
JE  134 
MOV DL,[102]
CMP DL,A
JNE 12E
MOV AH,2
MOV DL,9
INT 21
MOV DL,[102]
MOV AH,2
INT 21
JMP 109
MOV AH,4C
INT 21

R CX 
38
W
Q

ADDS A 1-TAB MARGIN TO REDIRECTED INPUT

MARGIN < TEXTFILE.DOC

	 = N A_OR_B.COM
A 100
MOV AX,440E
MOV BL,1
INT 21
MOV AH,4C
INT 21

R CX
B
W
Q

USED IN BATCH FILE. ACCEPTS ONLY A OR B RETURNS ERRORLEVEL 0 OR 1
	B N VIDEOMOD.COM
A 100
MOV AH,F
INT 10
MOV AH,4C
INT 21

R CX
8
W
Q

RETURNS VIDEO MODE AS ERRORLEVEL 

USE FOR %%I IN (0 1 2 3 4 5 6 7 13 14 15 16 17 18 19 ) DO IF ERRORLEVEL %%I SET VMODE=%%I

WHERE
0   25X40 MONO
1   25X40 COLOR
2   25X80 MONO
3   25X80 COLOR
4   320X200 4-COLOR GRAPH
5   320X200 MONO GRAPH
6   640X200 MONO GRAHICS
7   25X80 MONO TEXT
13  320X200 COLOR GRAPH
14  640X200 16-COLOR GRAPH
15  640X350 MONO GRAPH
16  640X350 16-COLOR GRAPH
17  640X480 MONO GRAPH
18  640X480 VGA 16-COLOR GRAPH
19  320X200 VGA 256-COLOR GRAPH

NON STD

80H 640X200 2-COLOR (64X18 TEXT OF 10X11 CHARS)
81H 640X200 4-COLOR (64X18 TEXT OF 10X11 CHARS)
82H 320X200 2-COLOR (40X25 TEXT OF 8X8   CHARS)
83H 320X200 4-COLOR (40X25 TEXT OF 8X8   CHARS)
84H 640X200 2-COLOR (40X16 TEXT OF 16X12 CHARS)
85H 640X200 4-COLOR (40X16 TEXT OF 16X12 CHARS)


SEE DEVNOTES VIDEOMODE
 	f Brief explanation of DASM.BAT file

DASM.BAT (Small DISassembler) will let you take 
small .COM files apart and put them into a 
modified DEBUG script file so that you may further 
modify them and then reassemble them with DBG.BAT.

DASM.BAT requires the use of the MS-DOS programs 
DEBUG.EXE, FIND.EXE, EDLIN.EXE. These must be 
supplied by the user.

Also needed, and included in this archive, are the 
files TRIM.COM, DASM.SCR, DASM.EDL, DETAB.EDL. 
These files are explained, by way of comments in 
the following document.

TO RUN DASM.BAT, you simply type DASM and the name 
of the COM file that you want to disassemble. DO 
NOT add the COM extension: just the file name will 
do.

A word of warning: Often a small COM file will 
generate an exceptionally large script file. Make 
sure that you have plenty of room on your disk to 
accommodate the resulting script file. DASM.BAT 
does not do any error trapping for out-of-disk- 
space-errors.

@echo off
CLS
@ECHO WORKING
if /%1==/ goto error               
REM Check if commandline is empty.

if not exist find.exe goto error   
REM Check if find.exe exists.

if not exist debug.exe goto error  
REM Check if debug.exe exists.

if not exist edlin.exe goto error  
REM Check if Edlin.exe exists.

if not exist trim.com goto error   
REM Check if Trim.com exists .
REM These should all be in the same
REM directory as DASM.BAT or else you
REM could change them lines to include
REM the drive:\path\filename.exe. But
REM make sure the files are somewhere
REM in the DOS path statement.

CLS
if not exist dasm.scr goto error   
REM These files _should_ all be in the

if not exist dasm.edl goto error   
REM same directory as DASM.BAT.

if not exist detab.edl goto error
if not exist %1.com goto error     
REM Check if the .COM file exists and
REM was not entered as FLNM.COM

@ECHO WORKING

DEBUG %1.COM < DASM.SCR > DASM.TMP 
REM Now disassemble the .COM file using
REM the DASM.SCR file and send the output
REM to DASM.TMP

EDLIN DASM.TMP < DASM.EDL > NUL    
REM Fix up DASM.TMP using the DASM.EDL
REM file and send the output to NUL.
REM Note that EDLIN will still save the
REM fixed up file, as well as a back up
REM file.

     **DASM.EDL**

     4R-                
     REM Eliminate dash in line 4 of input

     2RCX U 100 L      
     REM Replace RCX in line 2 with U 100 L

     3D                 
     REM delete line 3

     1D                 
     REM delete line 1

     E                  

     REM Save and exit
     REM THIS FILE must end with a blank line
     REM or ^Z otherwise the computer will hang.

CLS
DEL DASM.BAK                       
REM Delete the DASM.BAK file.

@ECHO WORKING

DEBUG %1.COM < DASM.TMP > %1.SCR   
REM Once again, run debug on the .COM file
REM using the DASM.TMP commands and send
REM the output to the new script file.

CLS
DEL DASM.TMP                       
REM Get rid of the .TMP command file.

@ECHO WORKING

FIND ":" < %1.SCR > %1.TMP         
REM Look for ":" in the script file and
REM send this to a new .TMP file.

REM if you want line numbers, use  
REM the REM directive from this line....
REM TRIM 1 -5 "<" %1.TMP "|" TRIM 6 -18 ">" %1.SCR
REM otherwise use (quote above,unquote below)

TRIM 1 -24 < %1.TMP > %1.SCR       
REM ...and put a REM at the start of this
REM line.

echo N %1.COM > flnm               
REM Start building the script file.

EDLIN %1.scr < detab.edl >NUL      
REM Modify the script file using DETAB.EDL
REM and send the display to nul.

     DETAB.EDL
     T flnm             

     REM Prepend the first line from FLNM

     2i                 
     REM Insert "A 100" on line 2

     A 100
                       
     REM CTRL-C and ENTER

     #                  
     REM Jump to EndOfFile and insert ";END"

     i
     ;END
     REM Enter a blank line

     RCX                
     REM Append "RCX nn ;W and q"
     nn
     ;W
     q
                       
     REM CTRL-C and ENTER

     1,R               
     REM From line 1 to the EOF, replace TAB

     e                  
     REM characters with 4 spaces.
     REM Save and exit.
     REM This file MUST end with a blank line

CLS
IF EXIST %1.BAK DEL %1.BAK         
REM Delete the BAK file created by EDLIN.

DEL FLNM
IF EXIST %1.TMP DEL %1.TMP
EDLIN %1.scr
goto quit

:error
echo Needs EDLIN.EXE, FIND, TRIM.COM and DEBUG.EXE,
echo as well as DASM.SCR, DASM.EDL, DETAB.EDL,
echo and just the filename for a .COM file

:quit
	 h SEE VIDEOMODE9  	     MEMORY MEMORY EMS TSRs LIM REAL PROTECTED ' 
 	   
  TODAY DEBUG SCRIPT FILE =  	     Compare       DEBUG Command: -C range address A  	     Dump          DEBUG Command: -D[addr] or D[range] >  	     Enter         DEBUG Command: -E address[list]  :  	     Fill          DEBUG Command: -F range list B  	     Go            DEBUG Command: -G[=addr][addr[addr]] ;  	     Hex Arithm    DEBUG Command: -H value value 8  	     Input         DEBUG Command: -I portaddr @  	     Load          DEBUG Command: -L addr drv sec sec :  	     Move          DEBUG Command: -M range addr B   	      Name          DEBUG Command: -N[d:][path[flnm[.ex] < # 	   #  Proceed       DEBUG Command: -P[=add][value] / $ 	   $  Quit          DEBUG Command: -Q = & 	   &  Registers     DEBUG Command: -R[registername] : ( 	   (  Search        DEBUG Command: -S range list = * 	   *  Trace         DEBUG Command: -T[=addr][value] @ - 	   -  Write         DEBUG Command: -W addr drv sec sec ) / 	   /  SHOWCMD DEBUG SCRIPT FILE * 0 	   0  KBDFLUSH DEBUG SCRIPT FILE ) 2 	   2  TODAYIS DEBUG SCRIPT FILE ' 3 	   3  AM_PM DEBUG SCRIPT FILE ' 4 	   4  MONTH DEBUG SCRIPT FILE & 5 	   5  YEAR DEBUG SCRIPT FILE * 6 	   6  NEWPAUSE DEBUG SCRIPT FILE ' 7 	   7  PAWSE DEBUG SCRIPT FILE ) 8 	   8  DELAY10 DEBUG SCRIPT FILE ( = 	   =  A_OR_B DEBUG SCRIPT FILE & > 	   >  PULL DEBUG SCRIPT FILE & ? 	   ?  LOUD DEBUG SCRIPT FILE & @ 	   @  SOFT DEBUG SCRIPT FILE * B 	   B  VIDEOMOD DEBUG SCRIPT FILE * E 	   E  CHECKKEY DEBUG SCRIPT FILE ) F 	   F  CHKCTRL DEBUG SCRIPT FILE * G 	   G  CKDOSKEY DEBUG SCRIPT FILE * H 	   H  DISKFLSH DEBUG SCRIPT FILE * I 	   I  DOSMAJOR DEBUG SCRIPT FILE * J 	   J  DOSMINOR DEBUG SCRIPT FILE ) M 	   M  HP_LAND DEBUG SCRIPT FILE ) N 	   N  HP_PORT DEBUG SCRIPT FILE ) O 	   O  KBDTYPE DEBUG SCRIPT FILE ) P 	   P  LOCKOUT DEBUG SCRIPT FILE ' Q 	   Q  LOWER DEBUG SCRIPT FILE ( R 	   R  MARGIN DEBUG SCRIPT FILE * S 	   S  SHTOGGLE DEBUG SCRIPT FILE ' T 	   T  SIREN DEBUG SCRIPT FILE ' V 	   V  UPPER DEBUG SCRIPT FILE ) W 	   W  RANGE DEBUG COMMAND FIELD ( X 	   X  LIST DEBUG COMMAND FIELD 0 Y 	 
  Y  PSP DEBUG PROGRAM SEGMENT PREFIX ( Z 	   Z  EDPATH DEBUG SCRIPT FILE ( ] 	   \  Which  DEBUG SCRIPT FILE ) ^ 	   ]  WHATNDP DEBUG SCRIPT FILE * _ 	   ^  SHFTLOCK DEBUG SCRIPT FILE ) b 	   b  SPEAKER DEBUG SCRIPT FILE ' d 	   d  BSAVE DEBUG SCRIPT FILE ' e 	   e  BLOAD DEBUG SCRIPT FILE 4 f 	   f  Dasm.bat DEBUG Doc file for DASM.BAT ' h 	   h  FONTS DEBUG SCRIPT FILE j       
 N +    \L p
           
 
7           ! z X    v  6 v} V              &Cmnd        &Prog                &Name   
     &Descr 	: N F1TOF10.COM
A 100
MOV AH,0 
INT 16
CMP AH,3B
JL  100
CMP AH,44
JG  100
SUB AH,3A 
MOV AL,AH
MOV AH,4C
INT 21

R CX
17
W
Q

RETURNS ERRORLEVEL 1..10 AND FORCES THE USER TO PRESS A FUNCTION KEY ONLY.

USEFUL FOR BATCH MENU PROGRAMS
) : 	   :  F1TOF10 DEBUG SCRIPT FILE 	  To specify an address using DEBUG,use 

1)Segment register plus offset, e.g. CS:1000 
2)Segment plus offset,e.g. B800:0 
3)Offset only using default seg.

,  	     Arguments-1   DEBUG address: 	  N ENTER.COM
A 100
MOV AX,0500
MOV CX,1c0d
INT 16
MOV AH,4C
INT 21

R CX
C
W
Q

Stuffs an ENTER into the kbd buffer.
+  	     ENTER.SCR DEBUG SCRIPT FILE 	K N ESCAPE.COM
A 100
MOV AH,2
MOV DL,1B
INT 21
MOV BX,80
INC BX
CMP BYTE [BX],D
JNE 109
MOV BYTE [BX],24
MOV AH,9
MOV DX,82
CMP DX,BX 
JG  11D
INT 21
MOV AH,4C
INT 21

R CX
21
W
Q

ALLOWS PUTTING THE ESC CHAR INTO THE STREAM.

E.G. ESC [44M

( K 	   K  ESCAPE DEBUG SCRIPT FILE 	 TO: Robert Roney 72257,714
FROM: Ed Keefe
SUBJ: SHOW.COM

Pull this into MEMO (or any ASCII editor). Delete everthing but what is between the dotted lines. Save the remainder as SHOW.SCR.
At the DOS prompt enter

 DEBUG < show.scr       and press Enter. 
 --------------------------------------------------------
  e 0100  E9 87 00 55 73 61 67 65 3A 20 53 48 4F 57 20 20
  e 0110  6D 65 73 73 61 67 65 0A 0D 6D 65 73 73 61 67 65
  e 0120  20 69 73 20 75 70 20 74 6F 20 31 30 20 63 68 61
  e 0130  72 61 63 74 65 72 73 20 DB 20 00 00 00 00 00 00
  e 0140  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  e 0150  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  e 0160  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  e 0170  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  e 0180  00 00 00 00 00 00 00 00 00 00 BE 80 00 AC 0A C0
  e 0190  75 01 C3 AC 3C 0D 74 10 3C 2F 75 F7 AC A2 38 01
  e 01A0  AC 3C 0D 74 03 A2 39 01 BE 6E FA B8 00 F0 8E D8
  e 01B0  BF 3A 01 BB 82 00 2E 8A 07 3C 0D 74 1C 3C 2F 74
  e 01C0  18 32 E4 D1 E0 D1 E0 D1 E0 56 03 F0 B9 08 00 F3
  e 01D0  A4 5E 43 81 FB 8C 00 7C DD 0E 1F B4 02 33 ED BE
  e 01E0  3A 01 03 F5 B9 0A 00 AC B3 80 50 8A 16 39 01 22
  e 01F0  C3 74 04 8A 16 38 01 CD 21 D0 CB 58 80 FB 80 75
  e 0200  E9 83 C6 07 E2 E1 45 83 FD 08 7C D3 C3 13 74 26
  
  N SHOW.COM
  
  RCX
  10D
  w
  q
    
  -------------------
 The resulting file, SHOW.COM (269 bytes) may be used in place of the DOS "echo" command, for example in the SEEK.BAT program. The only limitation is that it works only for 10 characters and will not use any character whose ASCII value is > 127.

I await feedback and give the usual disclaimer: I don't say that the program does anything. Use it at your own risk. It's public domain, freeware, from Ed Keefe.

(  	     SHOWFB DEBUG SCRIPT FILE 	k e 0100  E9 84 00 55 73 61 67 65 3A 20 53 48 4F 57 20 73
e 0110  74 72 69 6E 67 20 3A 20 73 74 72 69 6E 67 20 69
e 0120  73 20 75 70 20 74 6F 20 31 30 20 63 68 61 72 61
e 0130  63 74 65 72 73 DB 20 00 00 00 00 00 00 00 00 00
e 0140  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
e 0150  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
e 0160  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
e 0170  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
e 0180  00 00 00 00 00 00 00 BE 6E FA B8 00 F0 8E D8 BF
e 0190  37 01 BB 82 00 2E 8A 07 3C 0D 74 18 32 E4 D1 E0
e 01A0  D1 E0 D1 E0 56 03 F0 B9 08 00 F3 A4 5E 43 81 FB
e 01B0  8C 00 7C E1 0E 1F B4 02 33 ED BE 37 01 03 F5 B9
e 01C0  0A 00 AC B3 80 50 8A 16 36 01 22 C3 74 04 8A 16
e 01D0  35 01 CD 21 D0 CB 58 80 FB 80 75 E9 83 C6 07 E2
e 01E0  E1 45 83 FD 08 7C D3 C3 26

n show.com

rcx
e8
w
q


&  	     SHOW DEBUG SCRIPT FILE 	U N STUFCMD.COM
A 100
MOV BX,80
INC BX
INC BX
MOV CX,BYTE [BX]
MOV AX,0500
INT 16
CMP CH,0D
JNE 104
MOV AX,0500
MOV CX,1C0D
INT 16
INT 20
MOV AH,4C
INT 21

R CX
20
W
Q

GETS THE COMMANDLINE AND STUFFS IT INTO THE KEYBOARD 
BUFFER. WITH X.SYS, THIS COULD HANDLE THE FULL 127 KEY 
COMMAND LINE.

MAY BLOW UP AND CRASH IF THE COMMAND LINE IS EMPTY.

SEE PUTS FOR A MORE BULLETPROOF VERSION.
) U 	   U  STUFCMD DEBUG SCRIPT FILE 	_ PUTS A: CHKDSK AND C: CHKDSK in kbd buffer
DO NOT RUN FROM WITHIN FILER..!!!
N CHK.COM
A  100
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AX,0500
MOV CX,1E61
INT 16
MOV AX,0500
MOV CX,273A
INT 16
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AX,0500
MOV CX,2E63
INT 16
MOV AX,0500
MOV CX,2368
INT 16
MOV AX,0500
MOV CX,256B
INT 16
MOV AX,0500
MOV CX,2064
INT 16
MOV AX,0500
MOV CX,1F73
INT 16
MOV AX,0500
MOV CX,256B
INT 16
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AX,0500
MOV CX,2E63
INT 16
MOV AX,0500
MOV CX,273A
INT 16
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AX,0500
MOV CX,2E63
INT 16
MOV AX,0500
MOV CX,2368
INT 16
MOV AX,0500
MOV CX,256B
INT 16
MOV AX,0500
MOV CX,2064
INT 16
MOV AX,0500
MOV CX,1F73
INT 16
MOV AX,0500
MOV CX,256B
INT 16
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AH,4C
INT 21
;END

R CX
AC
W
Q

%  	 
    CHK DEBUG SCRIPT FILE 	 ; N 0_THRU_9.COM
A 100
MOV AH,8
INT 21
CMP AL,30
JL  102
CMP AL,39
JG  102
SUB AL,30
MOV AH,4C
INT 21

R CX
12
W
Q

USE AS GETKEY IN BATCH FILES. ACCEPTS ONLY 0..9 AS INPUT
SEE ALSO F1TOF10 AND A_THRU_Z

* ; 	   ;  0_THRU_9 DEBUG SCRIPT FILE 	0c TO TOGGLE THE SCREEN TO/FROM REVERSE
Try the following:

Mov  dx, 22h    ;set GPIO index register
Mov  al, 2ch    ;set shade reg
Out  dx, al     ;set it
Mov  dx, 23h    ;set GPIO data register
In   al, dx     ;get current setting
Xor  al, 1      ;set to inverse
Out  dx, al     ;set it

( c 	   c  SCREEN DEBUG SCRIPT FILE 	 D N CAPSLOCK.COM
A 100
MOV AX,40
MOV DS,AX
XOR BYTE [17],40
MOV AH,4C
INT 21

R CX
E
W
Q

TOGGLES THE CAPSLOCK KEY PROGRAMMATICALLY

* D 	   D  CAPSLOCK DEBUG SCRIPT FILE 	s  n capson.com
a 100
pop ds
or by [417],40
int 20

rcx
8
w
q

Turns on the Caps Lock Key.  8 Bytes
(  	     CAPSON DEBUG SCRIPT FILE 	u " n capsoff.com
a 100
pop ds
and by [417],0
int 20

rcx
8
w
q

Turns off the Caps Lock key.  8 Bytes
) " 	   "  CAPSOFF DEBUG SCRIPT FILE 	 + n nopscr.com
a 100
pop ds
or by [500],1
int 20

rcx
8
w
q

Disables the Print Screen, or Shift Print Screen. Very handy to avoid lockups on computers with no printer attached, or Lan workstations using shared printers.  8 Bytes 
( + 	   +  NOPSCR DEBUG SCRIPT FILE 	 . n pscr.com
a 100
pop ds
and by [500],0
int 20

rcx
8
w
q


Re-enables Print Screen, or Shift Print Screen.  
8Bytes.  
& . 	   .  PSCR DEBUG SCRIPT FILE 	j 1 N BELL.COM
A 100
MOV AH,2
MOV DL,7
INT 21
MOV AH,4C
INT 21

R CX
A
W
Q

SOUNDS THE BELL* 1 	   1  BELL SND DEBUG SCRIPT FILE 	6A N BCALC.COM
A 100
MOV AX,0500
MOV CX,C600
INT 16
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AX,0500
MOV CX,1352
INT 16
MOV AX,0500
MOV CX,1950
INT 16
MOV AX,0500
MOV CX,0A39
INT 16
MOV AX,0500
MOV CX,0635
INT 16
MOV AX,0500
MOV CX,1C0D
INT 16
INT 20
MOV AH,4C
INT 21

RCX
3d
W
Q

' A 	   A  BCALC DEBUG SCRIPT FILE 	a i n flush.com
a 100
mov ax,c06
mov dl,ff
int 21
mov ah,4c
int 21

r cx
b
w
q


' i 	   i  FLUSH DEBUG SCRIPT FILE 	7j N GOCALC.COM
A 100
MOV AX,0500
MOV CX,1265
INT 16
MOV AX,0500
MOV CX,2d78
INT 16
MOV AX,0500
MOV CX,1769
INT 16
MOV AX,0500
MOV CX,1474
INT 16
MOV AX,0500
MOV CX,1c0d
INT 16
MOV AX,0500
MOV CX,1c0d
INT 16
MOV AX,0500
MOV CX,c000
INT 16
INT 20
MOV AH,4C
INT 21

RCX
3D
W
Q

( j 	   j  GOCALC DEBUG SCRIPT FILE 	sl N SNDON.COM
A 100
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AX,0500
MOV CX,AE00
INT 16
MOV AX,0500
MOV CX,C800
INT 16
MOV AX,0500
MOV CX,184F
INT 16
MOV AX,0500
MOV CX,1F53
INT 16
MOV AX,0500
MOV CX,4400
INT 16
MOV AX,0500
MOV CX,4D00
INT 16
MOV AX,0500
MOV CX,4400
INT 16
MOV AX,0500
MOV CX,1000
INT 16
MOV AH,4C
INT 21

R CX
4C
W
Q

' l 	   l  SNDON DEBUG SCRIPT FILE 	m N SNDOFF.COM
A 100
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AX,0500
MOV CX,AE00
INT 16
MOV AX,0500
MOV CX,C800
INT 16
MOV AX,0500
MOV CX,184F
INT 16
MOV AX,0500
MOV CX,1F53
INT 16
MOV AX,0500
MOV CX,4400
INT 16
MOV AX,0500
MOV CX,4B00
INT 16
MOV AX,0500
MOV CX,4B00
INT 16
MOV AX,0500
MOV CX,4B00
INT 16
MOV AX,0500
MOV CX,4400
INT 16
MOV AX,0500
MOV CX,1000
INT 16
MOV AH,4C
INT 21

R CX
5C
W
Q

( m 	   m  SNDOFF DEBUG SCRIPT FILE 	&' N KEYSTICK.COM
E 0100 EB 6D 00 00 00 00 B8 9D
E 0108 AA B6 38 1D 2A 36 00 50
E 0110 51 57 06 0E 07 BF 06 01
E 0118 B9 08 00 FC FB E4 60 2E
E 0120 80 3E 0E 01 E0 2E A2 0E
E 0128 01 74 3A F2 AE 75 36 80
E 0130 F9 04 73 1B B8 40 00 8E
E 0138 C0 B0 01 D2 E0 26 30 06
E 0140 17 00 3C 04 72 09 D0 E8
E 0148 D0 E8 26 30 06 18 00 E4
E 0150 61 8A E0 0C 80 E6 61 8A
E 0158 C4 E6 61 FA B0 20 E6 20
E 0160 07 5F 59 58 CF 07 5F 59
E 0168 58 FA 2E FF 2E 02 01 B8
E 0170 09 35 CD 21 89 1E 02 01
E 0178 8C 06 04 01 B8 09 25 BA
E 0180 0F 01 CD 21 BA 6F 01 CD
E 0188 27
RCX
0089
W
Q

KEYSTICK.COM                PC_Compng
November 1993               Jeff Prosise

Cause keys to become "sticky". Designed for
physically challeneged people to use keyboards
requiring multikey keypresses.

* ' 	   '  KEYSTICK DEBUG SCRIPT FILE 	j n N kbhit().com
A 100
MOV AH,B
INT 21
AND AL,1
MOV AH,4C
INT 21
;<010A> end

RCX
A
w
Q

) n 	   n  KBHIT() DEBUG SCRIPT FILE 	o N SETVOL.COM
A 100
MOV BX,80     ; point at commandline
MOV CX,0031   ; put default (1) in CL, 0 in CH
INC BX        ; point at 81 in cmdline
MOV DL, BYTE [BX] ; put the byte in DL
MOV CH,CL     ; put CL in CH
MOV CL,DL     ; put DL in CL
CMP DL,D      ; compare DL to Enter
JNE 0106      ; jump to INC BX
MOV AH,48     ; put 48H in AH
MOV AL,CH     ; put CH in AL
SUB AL,30     ; subtract 30H
INT 15        ; call  intr 15
MOV AH,4C     ; quit
INT 21

R CX
1E
W
Q

FOR HP 100LX ONLY


( o 	   o  SETVOL DEBUG SCRIPT FILE    DEBUG w  M  All Fields                      Cmnd: 
@o   	
Prog: 
@o  	
Name: 
@o  	
Descr: 
@o  	
a   7  DataCard                        
@o   	
=

@o  	

@o  	

@o  	
	Lk N KSTUF.COM
A 100
MOV AX,0500
MOV CX,1C0D
INT 16
MOV AX,0500
MOV CX,011B
INT 16
MOV AH,4C
INT 21

R CX
14
W
Q

This is just a template for your own keystuff routines. It stuffs Enter and Escape. You'll need to figure out what keys you want to stuff and code them in with
MOV AX,0500
MOV CX,scancode
INT 16
' k 	   k  KSTUF DEBUG SCRIPT FILE 	W_ N TRUE.COM
A100
JMP 170                  ;jump over data area to START

F 102 16F '$'
E 150 'Bad parameter'
E 160 'I need DOS 3!'
A170
MOV  AX,3000             ;:START
INT  21                  ;get DOS version
CMP  AL,3
JAE  17E                 ;if it's 3 or greater, go to OK
MOV  DX,160              ;otherwise complain and ..
JMP  19C                 ;.. go to DONE
XOR  BX,BX               ;:OK
MOV  BL,[0080]
ADD  BL,81               ;make filename on command line into
MOV  BYTE PTR [BX],00    ;an ASCIIZ string
MOV  SI,0082             ;point SI at filename
MOV  DI,0102             ;point DI at result area
MOV  DX,DI               ;point DX at result too
MOV  AX,6000
INT  21                  ;call true name function
JNC  019C                ;If the call succeeded, goto DONE
MOV  DX,0150             ;otherwise point to error message
MOV  AX,0900             ;:DONE
INT  21                  ;print the message pointed to by DX
INT  20

RCX
A3
W
Q


ANOTHER WAY TO HANDLE DATA IN DEBUG

THIS ONE CREATES A FULLY QUALIFIED FILENAME GIVEN JUST THE FILENAME.
& ` 	   _  TRUE DEBUG SCRIPT FILE 	9 N yorn.COM 
A 100
XOR    AH,AH
INT    16                                 
XOR    AL,AL
CMP    AH,15 ; Y sets el=1
JZ     0112
CMP    AH,31 ; N keeps el=0
JZ     0114
JMP    0100                               
MOV    AL,01
MOV    AH,4C                              
INT    21                                 

RCX
18
W
q

  
YESORNO STOPS BATCH FILE AND WAITS FOR ONLY Y OR N 

Y GIVES ERRORLEVEL 1, N GIVES 0

Use DEBUG < YORN.SCR  to beget YORN.COM (24bytes).

Here's a simple use

::INPUTYN.BAT
 @echo off
 echo 00t1tL!>yn.com
 del yn.com
 echo Ed Keefe requests that you press Y or N
 yn
 if errorlevel 1 goto 1
 if errorlevel 0 echo You pressed N, thank you.
 goto end
 :1
 echo You pressed Y, thanks.
 :end
 :: This batch program contains an embedded Yes/No input   :: device. 
 :: At the DOS command line type TEST; press Enter.At the
 :: prompt, enter Y or N. Note that most keys are inoper-  :: ative (however, shift, alt, ctrl Y or N will work as   :: well).
 :: The strange looking line actually creates a 24 byte    :: file YN.COM which is then run. YN.COM accepts either   :: y or n and returns an errorlevel of 1 or 0,            :: respectively.
 :: Note that "if errorlevel" looks for an errorlevel      :: Greater than or equal to the number specified.
 :: If you want to keep YN.COM for other uses, just        :: comment out the line "del yn.com".

A MORE COMPLICATED EXAMPLE

NOW write BUILD.BAT and SUB.BAT

@echo off
REM BUILD.BAT
echo @echo off > DO.BAT
for %%i in ( *.* ) do call sub.bat %%i

@echo off
REM SUB.BAT
echo echo %%1 %1 %%2 [Y\N] >> DO.BAT
echo yorn >> DO.BAT
echo if errorlevel 1 %%1 %1 %%2 >> DO.BAT
echo %%3 >> DO.bat

RUN BUILD.BAT to generate DO.BAT and then try a 
command like

DO COPY A:\FOO PAUSE    and see what happens.

You should be prompted for each copy command. If you 
press "y" then 1 file(s) will be copied, otherwise it 
won't. The pause command will let you press CTRL-BREAK 
and Y to exit the batch file after any operation.
) 9 	   9  YESORNO DEBUG SCRIPT FILE 	! Sends a byte to the portaddress

The Output command is the reverse of the Input command.  You can use the Output command to send a single byte of data to a port.  Note that certain ports can cause the system to hang (especially those dealing with system interrupts and the keyboard), so be careful with what you send where!

   -o 3fc 1
   -

Port 3FCh is the modem control register for the first
asynchronous port. Sending a 01h to this port turns
on the DTR (Data Terminal Ready) bit.  A 00h will turn
all the bits off. If you have a modem which indicates
this bit, you can watch the light flash as you turn
the bit on and off.
= ! 	   !  Output        DEBUG Command: -O portaddr byte 	$[ TO PERFORM A QUICK FIND, AT THE ALL DATABASE ITEMS SCREEN, TYPE IN THE NAME OF THE COMMAND.

TO LIST ALL THE SCRIPT FILES, USE THE F6 [SUBSETS] KEY AND HIGHLIGHT THE SCRIPT FILES ENTRY AND PRESS F10 OR 
ENTER.

TO CONVERT A SCRIPT FILE TO A .COM FILE HIGHLIGHT THE NOTE FIELD STARTING WITH THE FIRST LINE AND CONTINUING TO THE LINE AFTER "Q".

USE THE Fn COPY KEY AND THEN PASTE THE TEXT INTO MEMO. MAKE SURE THERE IS AT LEAST ONE BLANK LINE AFTER THE Q LINE.

SAVE THIS MEMO FILE AS AN ASCII TEXT WITH A NAME THAT CORRESPONDS TO THE NAME SHOWN IN THE FIRST LINE OF THE TEXT

FOR EXAMPLE, IF THE FIRST LINE SAYS N LOUD.COM, YOU WOULD SAVE THE FILE AS LOUD.SCR

EXIT MEMO AND USE FILER TO GO TO DOS.    [FILER]OD 

AT THE DOS PROMPT, TYPE SET AND PRESS ENTER. DETERMINE IF THE DIRECTORY  D:\DOS IS IN THE PATH. IF NOT, EITHER
MODIFY YOUR PATH STATEMENT (SEE EDPATH.SCR FOR THE EASY WAY TO DO THIS) OR COPY D:\DOS\DEBUG.EXE TO THE DIRECTORY
THAT CONTAINS THE .SCR FILE.

AT THE DOS PROMPT, TYPE 

DEBUG < FILENAME.SCR

AND PRESS ENTER. IF ALL GOES WELL, YOU SHOULD NOT SEE ANY ERROR MESSAGES. IF THE COMPUTER HANGS, THIS MEANS THAT YOU ONLY THOUGHT THERE WAS A BLANK LINE AFTER THE "Q" COMMAND. RESET THE 100LX AND FIX THE SCR FILE AND TRY AGAIN.

MANY OF THE COM FILES THAT MAY BE CREATED WITH THIS METHOD ARE BATCH FILE ENHANCERS. THEY NEED TO BE RUN FROM WITHIN A BATCH FILE THAT CONTAINS TESTS FOR ERRORLEVELS.

THE NOTES FOR THE PARTICULAR SCRIPT FILE MAY CONTAIN A SAMPLE BATCH FILE OR FURTHER INSTRUCTIONS ON HOW TO USE THE COM FILE.

MOST OF THESE SCRIPT FILES ARE MODOFIED VERSIONS OD SIMILAR FILES THAT APPEARED IN JAMSA'S 1001 DOS & PC TIPS, OSBORNE MCGRAW HILL, 1992. OTHER SCRIPT FILES 
ARE EITHER ORIGINAL OR HAVE BEEN FLOATING AROUND IN THE PUBLIC DOMAIN FOR UP TO TEN YEARS.

& \ 	   [  HELP DEBUG HELP RECORD       SCRIPT FILE et ems                      
$                                DEBUG  SCRIPT FILE Prog#"DEBUG"&Name#"SCRIPT FILE"        DEBUG W/O SCR FILES                                                    DEBUG  SCRIPT FILE 	Prog#"DEBUG"&Name<>"SCRIPT FILE" 	 < N A2Z.COM
A 100
MOV AH,8
INT 21
OR  AL,20 ; LOCASE
CMP AL,61
JL  102
CMP AL,7A
JG  102
SUB AL,61 
MOV AH,4C
INT 21

R CX
14
W
Q


USED IN BATCH FILES. ACCEPTS ONLY A..Z(a..z) AND RETURNS 0..25.
SEE ALSO 0_THRU_9

* < 	   <  A_THRU_Z DEBUG SCRIPT FILE 	  No Carriage Return Echo 
SEE BELOW FOR LATEST VERSION
N echonl.com 
A 100
MOV    BX,0081        ; POINT AT COMMANDLINE+1BYTE
MOV    DL,BYTE [BX]   ; IS IT 0X0D
CMP    DL,0D          ; IF YES THEN
JZ     11A            ; JUMP TO BYE
;<010A>       LOOP
INC    BX             ; INCREMENT THE POINTER
MOV    DL,BYTE [BX]   ; PUT WHAT'S POINTED AT BY BX INTO DL
CMP    DL,0D          ; IS IT 0X0D?
JZ     011A           ; YES: THEN  GOTO BYE
MOV    AH,02          ; ELSE SVC 2
MOV    DH,0
INT    21
JMP    010A           ; GOTO LOOP
;<011A>       BYE
MOV    AH,4C                              
INT    21                                 
;<011E> END

RCX
1E
W
Q


The following version has no zero bytes nor any 0A or 
0D bytes.

N echonl.COM 
A 100
xor    Bh,bh
mov    bl,81                            
MOV    DL,[BX]                            
MOV    AL,0C                              
INC    AL                                 
CMP    DL,AL                              
JZ    0121                              
;<010E>
INC    BX
MOV    DL,[BX]                            
MOV    AL,0C                              
INC    AL                                 
CMP    DL,AL                              
JZ    0121                               
MOV    AH,02                              
XOR    DH,DH                              
INT    21
JMP    010e                               
;<0121>
MOV    AH,4C
INT    21                                 
;<0125>

RCX
25
W
q

and the com file can be used like this

echo 0 8tC8t0!L!>echonl.com
echonl This is a test.
del echonl.com(   	      ECHONL DEBUG SCRIPT FILE 	_ Takes command line and stuffs keyboard with characters.
Actually, just stuffs whatever...
SEE BELOW FOR THE LATEST VERSION
N PUTS.COM 
A 100
MOV    BX,0081        ;POINT AT COMMAND LINE + 1 BYTE
MOV    CL,BYTE [BX]   ;IS IT 0X0D?
CMP    CL,0D
JZ     11B            ;THEN JUMP TO BYE
;<010A> LOOP          ;ELSE
INC    BX             ;INCR POINTER
MOV    CL,BYTE [BX]   ;MOVE WHAT'S POINTED AT INTO CL
CMP    CL,0D          ;IS IT 0X0D
JZ     011B           ;YES: THEN GOTO BYE
MOV    AX,0500        ;SVC 0500
MOV    CH,0           ;FILL IN CH
INT    16             ;INTERRUPT 16
JMP    010A           ;GOTO LOOP
;<011B> BYE
MOV    AH,4C          ;QUIT
INT    21
;<011F> END

RCX
1F
W
q

This version has no 0, A or D bytes.

N puts.COM 
A 100
xor    bh,bh
MOV    Bl,81                            
MOV    CL,[BX]                            
mov    al,0c
inc    al
CMP    CL,AL                              
JZ    0125                               
;<010E> loop
INC    BX                                 
MOV    CL,[BX]                            
mov    al,0c
inc    al
CMP    CL,AL                              
JZ    0125                               
MOV    Ah,05
xor    al,al
xor    CH,ch                              
INT    16                                 
JMP    010E
xor    al,al
;<0125> bye                           
MOV    AH,4C                              
INT    21                                 
;<0129> END

RCX
29
W
q

It may be used like this

echo 0 8tC8t000L!>puts.com
puts %0 this is a test
del puts.com&  	     PUTS DEBUG SCRIPT FILE 	Kq Actually, an ASM file. REPLACES X.SYS to set up an extended keyboard buffer in Autoexec.bat rather than Config.sys

Head		EQU	01ah
Tail		EQU	01ch
OrigBuff	EQU	01eh
BuffStart	EQU	080h
BuffEnd		EQU	082h
NewBuff		EQU	200h
NewEnd		EQU	300h

		.MODEL	small
		.STACK		;default 1K stack is OK
		.CODE
		.STARTUP

BUFFMOVE	PROC
		PUSH	DS
		MOV	AX,040H
		MOV	DS,AX
		MOV	AX,NEWBUFF
		MOV	BX,BUFFSTART
		MOV	[BX],AX
		MOV	BX,HEAD
		MOV	[BX],AX
		MOV	BX,TAIL
		MOV	[BX],AX
		MOV	AX,NEWEND
		MOV	BX,BUFFEND
		MOV	[BX],AX
		POP	DS
		.EXIT
BUFFMOVE	ENDP
		END

. q 	   q  BUFFMOVE.ASM DEBUG SCRIPT FILE 	% Superseded by BATCHMAN Cursortype
N BLOCKCUR.COM
E 0100 B4 12 B3 10 CD 10 B1 07
E 0108 80 FB 10 74 0D 33 C0 8E
E 0110 C0 26 8A 0E 85 04 FE C9
E 0118 EB 00 B4 01 32 ED CD 10
E 0120 B4 4C CD 21
RCX
24

W

Q

BLOCKCUR                PC_COMP
October 1993            Jeff Prosise

BLOCKCUR enlarges your computer's cursor to a
large block, making it easier to see and use.

Run BLOCKCUR from your AUTOEXEC.BAT file, or
directly from the DOS command line.

To disable BLOCKCUR, simply type MODE 80<enter>
to restore the cursor to an underline cursor.

Remarks:
This program may not work with all video adapters.


* % 	   %  BLOCKCUR DEBUG SCRIPT FILE 	bg CAUTION: BEFORE USING THIS FILE, YOU MUST ISSUE THE COMMAND SET EDIT=VDE.COM to put the name of your favorite text editor in the environment variable EDIT.

ALSO: You should prepare the DEBUG script file by changing the Write command to  ;W to comment out the write command. Make sure there is one blank line before RCX and at least one blank line after the Q.

DEB2SCR.COM is a way to get around the "guess-the-jump- to-numbers" when writing a debug.scr file.

DEB2SCR.SCR is the actual code that was generated using DEB2SCR.COM on itself, after some cleanup at the end of the listing.

TO USE DEB2SCR (or DBG.BAT which contains DEB2SCR 
calls)....

Begin by writing a script file, but insert labels at the  destination of every jump and at the end of the code. these labels are comment lines starting with a (;). the script file should look like the following

N SAMPLE.COM
A 100
lines of code
;LABEL1
lines of code
;LABELn
lines of code
;END

RCX
nn
;W
Q

At this point, the addresses of the assembled code aren't known.

Use the command DBG SAMPLE and press ENTER.

The DBG.BAT program will call DEB2SCR.COM and modify the script file. See DBG-BAT.DOC for the details.

When running DBG, the first thing you'll notice is that the modified SAMPLE.SCR will appear in your editor of choice.

Therein you should note if there are any errors. Often DEBUG will not be able to interpret the code correctly. This is especially true if the code contains data. DEBUG has no way of knowing what is data and what is code. (If this is the case, you're on your own. Perhaps it's time to move up to a real disassembler.)

Thus:

N SAMPLE.COM
A 100
lines of code
;<XXXX> LABEL1
lines of code
;<YYYY> LABELn
lines of code
;<ZZZZ> END

RCX
nn
-;W
-Q

Where XXXX, YYYY, ZZZZ are the offsets of the lines following the labels.  the offset appearing with the end label determines the length of the code.

At this point, you should change the nn to ZZZZ - 100h. For example if ZZZZ is 0114, then nn would be 14h.

(The number at the END label shows the length of the code.. however, the actual length is the end address minus 100h, since most assembly begins at hex 100.)

Delete the "-;" in front of the W and the "-" in front of the Q and save the file and exit the text editor.

The DBG.BAT program will let you continue or quit at this point.

================================================

Here's a brief explanation of the DBG.BAT file


@echo off
if /%1==/ goto usage
REM Check for existence of argument
if not exist %1.SCR goto usage
REM Make sure the file exists AND
REM that it was not entered as FLNM.SCR
if not exist DEBUG.EXE goto usage
REM Make sure DEBUG is in the directory
REM or else change this to d:\path\DEBUG.EXE
if not exist DEB2SCR.COM goto usage
REM Check for existence of DEB2SCR.COM
if /%EDIT%==/ goto usage
REM Make sure the EDIT env. variable is
REM set. This is in lieu of using another
REM command line argument.

DEBUG < %1.SCR > %1.NEW
REM Run DEBUG using FLNM.SCR and output
REM to FLNM.NEW

deb2scr < %1.NEW > %1.SCR
REM Run DEB2SCR from FLNM.NEW and output
REM to FLNM.SCR (overwriting the old
REM version)

del %1.NEW
REM Delete FLNM.NEW (this avoids the use
REM of the pipe symbol.

%EDIT% %1.SCR
REM Edit the new script file. Look for
REM any errors and fixup the end of the
REM file.

echo Press any key to continue
echo press Ctrl-Brk and Y to STOP

pause > nul
REM If the file is too messed up, quit
REM now with ^BREAK and Y.

if exist %1.COM ren %1.COM %1.OLD
REM Otherwise, rename the older version
REM of the COM file, if one exists.

debug < %1.SCR > nul
REM Assemble the new version of the COM file
REM and send the display to NUL.

echo DONE 

if exist %1.BAK del %1.BAK
REM Delete backup file if there is one.
goto quit
REM jump to :QUIT

:usage
REM ERROR messages.
echo USAGE:  DBG script_filename only.
echo Converts Debug .SCR file to .COM file
echo while adding jump labels to .SCR file.
echo .
Requires DEBUG.EXE, DEB2SCR.COM,
echo and SET EDIT=VDE.COM or editor of
echo .                     your choice.
:quit

2 g 	   g  Dbg.bat DEBUG Doc file for DBG.BAT 	` N DEB2SCR.COM
A
MOV      DX,0187              ; address of buffer
MOV      CX,F000              ; size of buffer
XOR      BX,BX
MOV      AH,3F                ; read text into buffer
INT      21
OR       AX,AX               ; number of bytes read = 0 ?
JNZ      0112                 ; no --> PROCEED
;<0110> FINISH:
INT      20                   ; end
;<0112> PROCEED:
MOV      CX,AX
ADD      CX,DX               ; CX = end of data in buffer
MOV      SI,DX    ; SI = address of byte read from buffer
;<0118> NEWLINE:
CMP      SI,CX                ; end of data reached ?
JNB      0110                 ; yes --> FINISH
MOV      AL,[SI]             ; read character from buffer
CMP      AL,2D                ; is it a '-' ?
JNZ      0125                 ; no --> CONTINUE1
INC      SI                   ; skip the '-'
JMP      016E                 ; --> OUTPUTLINE
;<0125> CONTINUE1:
CMP      AL,3A                ; is it a ':' ?
JNZ      012C                 ; no --> CONTINUE2
INC      SI                   ; skip the ':'
JMP      016E                 ; --> OUTPUTLINE
;<012C> CONTINUE2:
CMP      AL,43                ; is it a 'C' ?
JNZ      0135                 ; no --> CONTINUE3
ADD      SI,09                ; skip 'CX XXXX',CR,LF
JMP      0118                 ; --> NEWLINE
;<0135> CONTINUE3:
CMP      AL,57                ; is it a 'W' ?
JNZ      013E                 ; no --> CONTINUE4
ADD      SI,14        ; skip 'Writing XXXX bytes',CR,LF
JMP      0118                 ; --> NEWLINE
;<013E> CONTINUE4:
CMP      BYTE PTR [SI+04],3A  ; line begins with address ?     (XXXX:YYYY)
JNZ      016B                 ; no --> CONTINUE5
CMP      BYTE PTR [SI+0A],3B  ; does a comment follow ?        (XXXX:YYYY ;)
JNZ      016B                 ; no --> CONTINUE5
CMP      BYTE PTR [SI+0B],3C  ; does comment contain address ? (XXXX:YYYY ;<)
JZ       015F                 ; yes --> CHANGEADDRESS
MOV      WORD PTR [SI+03],3C3B; write ';<' before 'YYYY'
MOV      WORD PTR [SI+09],203E; write '> ' after  'YYYY'
ADD      SI,03                ; skip 'XXX'
JMP      016E                 ; --> OUTPUTLINE
;<015F> CHANGEADDRESS:
MOV      AX,[SI+05]          ; replace address in comment
MOV      [SI+0C],AX
MOV      AX,[SI+07]
MOV      [SI+0E],AX
;<016B> CONTINUE5:
ADD      SI,0A                ; skip 'XXXX:YYYY '
;<016E> OUTPUTLINE:
CLD
LODSB                   ; read character and increment SI
MOV      DL,AL
CMP      DL,0D                ; is it a CR ?
JNZ      017C                 ; no --> CONTINUE6
CMP      [SI],DL              ; a second CR follows ?
JNZ      017C                 ; no --> CONTINUE6
INC      SI                   ; skip it
;<017C> CONTINUE6:
MOV      AH,02                ; output character
INT      21
CMP      DL,0A                ; was it a LF ?
JNZ      016E                 ; no  --> OUTPUTLINE
JMP      0118                 ; yes --> NEWLINE
;<0187> BUFFER:

RCX
87
W
Q


THIS IS A WAY TO GET AROUND GUESS THE JUMP TO NUMBERS 
WHEN WRITING A DEBUG.SCR FILE.

BEGIN BY WRITING A SCRIPT FILE, BUT INSERT LABELS AT THE DESTINATION OF EVERY JUMP AND AT THE END OF THE CODE. THESE LABELS ARE COMMENT LINES STARTING WITH A (;). THE SCRIPT FILE SHOULD LOOK LIKE THE FOLLOWING

N SAMPLE.COM
A 100
lines of code
;LABEL1
lines of code
;LABELn
lines of code
;END

RCX
nn
W
Q

AT THIS POINT, THE ADDRESSES OF THE ASSEMBLED CODE AREN'T KNOWN.

USE THE COMMAND DEBUG < SAMPLE.SCR | DEB2SCR > SAMPLE.SCR
(SEE BELOW)

DEB2SCR.COM IS A FILTER THAT MODIFIES THE SCRIPT FILE AND WRITES IT BACK TO ITSELF, RETAINING ONLY THE ADDRESSES OF THE LABELS.

THUS:
N SAMPLE.COM
A 100
lines of code
;<XXXX> LABEL1
lines of code
;<YYYY> LABELn
lines of code
;<ZZZZ> END

RCX
nn
;W
Q

WHERE XXXX, YYYY, ZZZZ ARE THE OFFSETS OF THE LINES 
FOLLOWING THE LABELS.  THE OFFSET APPEARING WITH THE END LABEL DETERMINES THE LENGTH OF THE CODE.

NOW, REDIRECT THE NEW SAMPLE.SCR FILE INTO DEBUG AND YOU SHOULD BE DONE....

ADDENDA:

PUT COMMENTS ON THE LINES CONTAINING JUMP INSTRUCTIONS, E.G.

JNZ 0123 ; JUMP TO LABEL1 IF NOT ZERO

THE NUMBER AT THE END LABEL FINDS THE LENGTH OF THE CODE.. HOWEVER, THE ACTUAL LENGTH IS THE END ADDRESS MINUS 100H.  USE DEBUG'S  H NNNN 100 TO DO THE HEX ARITHMETIC AND STICK THE SECOND RESULT (THE MINUS PART) AFTER RCX

WARNING... THE ABOVE REDIRECTION CODE CAN DESTROY YOUR 
ORIGINAL CODE WITH GARBAGE CHARACTERS.

RATHER: USE DEBUG < SAMPLE.SCR | DEB2SCR > SAMPLE.NEW

SOURCE: PCM V10N17

COMMENTING OUT THE Write COMMAND SEEMS TO ELIMINATE THE
GARBAGE STRING IN PLACE OF Q

HERE'S A BETTER BATCH FILE :

REM DEB2.BAT
@echo off
IF /%1==/ GOTO QUIT
DEBUG < %1.SCR > %1.NEW 
if exist %1.com del %1.com
deb2scr < %1.new > %1.scr
del %1.new
VDE %1.scr 
echo CONTINUE? Anykey (Ctrl-Brk to abort)
pause > nul
debug < %1.scr
;QUIT

THIS AVOIDS CREATING PIPE FILES AND ALLOWS FOR USE OF
TMP FILE WHICH IS DELETED AND THEN GOES TO DEBUG <
COMMAND.
) [ 	   `  DEB2SCR DEBUG SCRIPT FILE 	t to get a file containing the unassembled version of a
COM, READ THE FOLLOWING AND SEE UNASSEMBLE

DISASSEMBLING A SMALL COM FILE WITH DEBUG AND EDLIN
To get an unsassembled listing of a com file using DEBUG, you can use the U command. If you want to redirect the output to a new text file, you need to know the exact size of the file.

To find the exact size do the following. Use the command

DEBUG flnm < DISASM.SCR > DISASM.TMP where DISASM.SCR is a script file 
RCX

Q

(blank lines after the RCX and After the Q.)

Disasm.tmp will look something like 
-RCX
CX 0018
:
-Q

The file size would thus be 0018h bytes.

Step2: Use EDLIN to modify DISASM.TMP. Then Issue the command
EDLIN DISASM.EDL and get the new file prompt
*1i
   1* 4R-            ;eliminates dash in line 4 of input
   2* 2RCX^Z U 100 L ;replaces RCX in line 2 with U 100 L
   3* 3D             ;delete line 3
   4* 1D             ;delete line 1
   5* E
   6* ^Z ;very important
E to exit

Now issue the command EDLIN DISASM.TMP < DISASM.EDL

This will modify DISASM.TMP to be U 100 L 0018
Q

Finally use the command 
DEBUG flnm.com < disasm.tmp > flnm.lst

and be patient...this is slow for even very small files.
The LST file will be 15-20 larger than the COM file.

DISASM.BAT combines all of the above. It assumes that EDLIN and DEBUG are available on the path and that DISASM.SCR and DISASM.EDL are already prepared.

DEBUG %1.COM < DISASM.SCR > DISASM.TMP
EDLIN DISASM.TMP < DISASM.EDL
DEBUG %1.COM < DISASM.TMP | FIND ":" > %1.LST
DEL DISASM.TMP

DISASM.EDL
4R-
2RCX U 100 L
3D
1D
E

DISASM.SCR
RCX

Q

You will need to get a copy of edlin from the DOS 5.0
disk that came with your PC. 

Be careful using this command on the 100lx  COM FILES 
WILL USUALLY PRODUCE .SCR OR .ASM TEXT FILES THAT ARE 
UP TO TEN TIMES THE SIZE OF THE CORRESPONDONG COM FILE.
L  	     Disassemble   DEBUG Technique to go from a com to a scr file 	
, addr : where to start. Defaults to addr of prior U
command. Otherwise defaults to CS:100
range: range to unassem. Def=CS
E.G. : U CS:100 
Unassembles from beginning of program.

SEE DISASSEMBLE ABOVE

For debugging, one of the main commands you will use is the Unassemble command.  This command will take machine code and convert it to instructions. Addressing is the same as for previous commands with one exception:  Since we are now working with code (the previous commands are mainly for data), the default register is the CS register. In a .COM program, this makes very little difference, unless you reset the DS register yourself. However, in a .EXE file, it can make a lot of difference, as the CS and DS registers are set to different values.

Unassemble data can lead to some interesting results. For instance, in our example, CS:IP is set to 6897:0100.  If we look at the program, we see a JMP as the first instruction, followed by data.  If we just enter U, we will start at CS:IP (6897:0100) and start unassembling data.  What we will get is a good instruction, followed by more or less nonsense. For instance:

   -U
   6897:0100 E96B01  JMP   026E
   6897:0103 43      INC   BX
   6897:0104 4C      DEC   SP
   6897:0105 4F      DEC   DI
   6897:0106 43      INC   BX
   6897:0107 4B      DEC   BX


And so on, through 6897:011D.  We know the INC BX, DEC
SP, etc. are not valid instructions, but DEBUG doesn't, so we do have to look at the code.  After working with DEBUG a little, you will be able to spot code versus data with the Unassemble command. For now, suffice to say that the first instruction will take us to CS:026E and we can start from there. 

If we Unassemble CS:026E, we will find something which
looks a little more like what we expect. We get:

   -U 26E
   6897:026E 8D167802 LEA   DX,[0278]
   6897:0272 B409     MOV   AH,09
   6897:0274 CD21     INT   21
   6897:0276 EB05     JMP   027D
   6897:0278 1B5B32   SBB   BX,[BP+DI+32]
   6897:027B 4A       DEC   DX
   6897:027C 24B4     AND   AL,B4
   6897:027E 30CD     XOR   CH,CL
   6897:0280 213C     AND   [SI],DI
   6897:0282 027D0A   ADD   BH,[DI+0A]
   6897:0285 8D167C01 LEA   DX,[017C]
   6897:0289 B409     MOV   AH,09
   6897:028B CD21     INT   21
   6897:028D CD20     INT   20
The first few instructions look fine.  But, after the 
JMP 027D, things start to look a little funny. Also, note that there is no instruction starting at 027D. We have instructions at 027C and 027E, but not 027D. This is again because DEBUG doesn't know data from instructions. At 027C, we should (and do) have the end of our data.  But, this also translates into a valid AND instruction, so DEBUG will treat it as such. If we wanted the actual instruction at 027D, we could enter U 027D and get it, but from here, we don't know what it is.  what I'm trying to say is, DEBUG will do what ever you tell it.  If you tell it to Unassemble data, it will do so to the best of its ability. So, you have to make sure you have instructions where you think you do.

? , 	   ,  Unassemble    DEBUG Command: -U[addr] | [range] 		a N VOL_IS.COM
A 100
MOV AL,1E         ;set offset
OUT 22,AL         ;point to offset
IN  AL,23         ;read in the value from the port
MOV CL,6          ;put 6 in CL
SHR AL,CL         ;shift AL 6 bits to the right
AND AL,3          ;mask AL with 0011b
MOV AH,4C         ;quit
INT 21            ;return errorlevel in AL

RCX
10
W
Q

N SETVOL.COM
A 100
MOV BX,80          ;point at the commandline
MOV CX,0031        ;stuff 31h in CL as default value (1 dec)
INC BX             ;move into the commandline
MOV DL, BYTE [BX]  ;put the byte in DL
MOV CH,CL          ;put CL in CH
MOV CL,DL          ;put DL in CL
CMP DL,D           ;is DL the ENTER keystroke?
JNE 0106           ;NO: goto INC BX
MOV AH,48          ;else, put 48h in AH
MOV AL,CH          ;put CH in AL
SUB AL,30          ;subtract 30h from AL
INT 15             ;call the BIOS 
MOV AH,4C          ;
INT 21             ;quit

R CX
1E
W
Q

VOL_IS.COM
PURPOSE : Determine the current volume (sound level) 
          on the HP 100LX.

RETURNS : The program, when run, returns an errorlevel
          in the range 0 to 3, where 0 is no sound and
          3 is the loudest sound currently attainable
          on the HP 100LX

USAGE   : To see a number representing the current
          sound level, use the following batch file.

 @ECHO OFF
 REM WHATVOL.BAT
 VOL_IS
 FOR %%I IN (0 1 2 3) DO IF ERRORLEVEL %%I SET VOL=%%I
 ECHO %VOL%

The WHATVOL.BAT program runs VOL_IS and uses the errorlevel to set an environment variable (VOL) to one
of the values 0 to 3. The ECHO command displays this value. (You could also use SET to  see what else is in
your environment space.)

SETVOL.COM
PURPOSE : Set the volume level, from DOS.

USAGE   : SETVOL n

          where n is a number in the range 0 to 3
          inclusive.

          If SETVOL is run, without any commandline
          value, the volume defaults to 1 (the soft
          sound).

          If n is greater than 3, the BIOS function
          used, in SETVOL.COM, forces the value to 3,
          the loudest sound.

LIMITATIONS: This command changes the volume level. It
          does not set the volume histogram in the
          SETUP program to the corresponding value.
EXAMPLE :

@ECHO OFF
REM TESTVOL.BAT
FOR %%I IN (3 0 2 0 1) DO CALL RING %%I

@ECHO OFF
REM RING.BAT
SETVOL %1
ECHO ^G^G^G^G^G^G^G^G
REM ^G is the bell sound
REM entered by pressing CTRL+G
( a 	   a  VOLUME DEBUG SCRIPT FILE 	gC N A_EMPTY.COM
A 100
MOV AX,2524
MOV DX,113
INT 21
MOV AH,1C
MOV DL,1
INT 21
MOV AX,4C00
INT 21
MOV AX,4C01
INT 21

R CX
18
W
Q

Tests whether A: drive is empty

REM A_EMPTY
if errorlevel 1 goto no_disk
copy filename.ext a:
goto done
other commands

Change lines 1 and 7 to B_EMPTY.COM and DL,2
to use with a different drive.
) C 	   C  A_EMPTY DEBUG SCRIPT FILE 	) N MAKETREE.COM
E 100 EB 7C 00 00 00 00 00 0D 
E 108 0A 43 72 65 61 74 65 64 
E 110 20 24 0D 0A 4D 41 4B 45 
E 118 44 49 52 20 2D 20 6D 61 
E 120 6B 65 73 20 61 6C 6C 20 
E 128 64 69 72 65 63 74 6F 72 
E 130 69 65 73 20 69 6E 20 70 
E 138 61 74 68 0D 0A 55 73 61 
E 140 67 65 3A 20 4D 41 4B 45 
E 148 44 49 52 20 5B 64 72 69 
E 150 76 65 3A 5D 5B 70 61 74 
E 158 68 5D 0D 0A 0A 2A 2A 2A 
E 160 20 4E 6F 20 44 69 72 65 
E 168 63 74 6F 72 69 65 73 20 
E 170 43 72 65 61 74 65 64 20 
E 178 2A 2A 2A 0D 0A 24 BE 80 
E 180 00 AC A3 03 01 83 F8 00 
E 188 75 03 E9 B1 00 8B FE 03 
E 190 F8 88 25 AC 3C 20 74 FB 
E 198 3C 00 75 03 E9 9F 00 4E 
E 1A0 8B FE AC 3C 00 74 1F 3C 
E 1A8 20 75 F7 B0 00 88 04 8B 
E 1B0 CE 2B CF 89 0E 03 01 B8 
E 1B8 80 00 8A 0E 80 00 B5 00 
E 1C0 03 C1 3B F0 75 78 B0 24 
E 1C8 88 04 4E 88 24 89 3E 05 
E 1D0 01 8B 3E 05 01 B0 5C 8B 
E 1D8 0E 03 01 FC F2 AE 75 2F 
E 1E0 8B 16 05 01 4F B0 00 88 
E 1E8 05 B4 39 CD 21 72 19 B1 
E 1F0 01 88 0E 02 01 B4 09 BA 
E 1F8 07 01 CD 21 B0 24 88 05 
E 200 B4 09 8B 16 05 01 CD 21 
E 208 B0 5C 88 05 47 EB C6 8B 
E 210 16 05 01 B4 39 CD 21 72 
E 218 13 B1 01 88 0E 02 01 B4 
E 220 09 BA 07 01 CD 21 8B 16 
E 228 05 01 CD 21 BA 07 01 B9 
E 230 02 00 B4 40 CD 21 80 3E 
E 238 02 01 00 74 01 C3 B4 09 
E 240 BA 12 01 CD 21 C3 
RCX
146
W
Q

MAKETREE.COM		PC_Computing
November 1993		 Michael Lew
			     and Greg Martin

Create Multiple Directories With One Command

To use MAKETREE, simply type MAKETREE followed by the directory tree you want to create. For example, the command 

MAKETREE NOVEMBER\BUDGET\RESEARCH 

creates the nested directory tree \NOVEMBER\BUDGET\RESEARCH below the current directory.

When you've got to create a complicated directory tree, don't waste time typing one MD command after another. Instead, use this simple program, MAKETREE.COM, to create 
complex directory trees, such as \NOVEMBER\BUDGET\RESEARCH, with a single command.

* ) 	   )  MAKETREE DEBUG SCRIPT FILE 	r Tests for only R,V,E,and Esc : returns the scan codes of the letter.

N RVEesc.com   ;Run,View,Edit,Esc
A 100
XOR    AH,AH                
INT    16      ;get a key                           
XOR    AL,AL   ;AL=0                 
CMP    AH,13   ;is it r (19d)
JZ     011c    ;jump 
CMP    AH,2f   ;is it v (47d)
JZ     011c    ;jump
CMP    AH,12   ;is it e (18d)
JZ     011c    ;jump
cmp    AH,01   ;esc
jz     011c    ;jump
JMP    0100    ;try again
;<011C>
mov    al,ah
MOV    AH,4C                              
INT    21      ;back to DOS with EL=scancode                    
;<0122> END

RCX
22
W
q

SAMPLE USE in Batch File, CHOICE.BAT called from FILER.INI.

@echo off
echo 00t/tttL!>rve.com
echo BatchFile Options: R)un, V)iew, E)dit, ESC
rve
del rve.com
for %%e in (1 18 19 47) do if errorlevel %%e goto %%e
:1
goto end
:18 edit
vde %1
goto end
:47 view
vu %1
goto end
:19 run
%1
:end
( r 	   r  RVEESC DEBUG SCRIPT FILE 	s Reads from STDIN, writes to STDOUT
N RW.COM
A 100
xor  ax,ax          ;clear out registers
mov  bx,ax
mov  cx,ax
mov  dx,ax
mov  ah,3f          ;DOS read from handle function #
mov  cl,72          ;read up to maximum number of characters
mov  dl,82          ;store the string in the PSP @ 82h
int  21             ;get the string
mov  bl,al          ;put al in bl
;<0112> loop        ;The loop is to flush the keyboard
mov  ah,01          ;buffer in the same way that readln.pas
int  16             ;does. However, it doesn't seem to work.
jz   011e ;skip     ;Goto skip if there's no key waiting
xor  ah,ah          ;otherwise read the key and
int  16
jmp  0112 ;loop     ;jump to the start of the loop
;<011E> skip
cmp  bl,2           ;CMP AL,2 is 3C02 which puts "<2" in the
jz   0131           ;echo command. CMP BL,2 will not.
mov  cx,bx          ;put string length in CX
mov  ah,40          ;DOS write from handle function #
xor  bh,bh          ;Use xor so no " " appears in echo command
mov  bl,1           ;standard output handle for service 40
xor  dh,dh          ;just to be sure, reset DX
mov  dl,82          ;print the string
int  21
;<0131>       
mov  ah,4c          ;DOS terminate program function #
int  21             ;terminate the program
;<0135> END

rcx
35
w
q


@echo off
if exist $.bat del $.bat
echo 1É´?r!Àtٴ@0 0!L!>rw.com
:loop
rw >>$.bat
if errorlevel 3 goto loop
del rw.com
call $
del $.bat
$ s 	   s  RW DEBUG SCRIPT FILE 	t Tests for L,V,X,ESC : returns scancode of key pressed.
N lvxesc.com ;List,View,EXtract,Esc
A 100
XOR    AH,AH                
INT    16      ;get a key                           
XOR    AL,AL   ;AL=0                 
CMP    AH,26   ;is it l (38d)
JZ     011c    ;jump 
CMP    AH,2f   ;is it v (47d)
JZ     011c    ;jump
CMP    AH,2d   ;is it x (45d)
JZ     011c    ;jump
cmp    AH,01   ;esc
jz     011c    ;jump
JMP    0100    ;try again
;<011C>
mov    al,ah
MOV    AH,4C                              
INT    21      ;back to DOS with EL=scancode                    
;<0122> END

RCX
22
W
q

SAMPLE: LZH-OPT.BAT, called from FILER.INI

@echo off
echo 00&t/t-ttL!>lvx.com
echo LZH Options: L)ist, V)iew, eX)tract,ESC
lvx
del lvx.com
for %%e in (1 38 45 47) do if errorlevel %%e goto %%e
:1 
goto end
:38
echo Working...
lha l /n %1 | more
echo.
pause 
goto end
:45
echonl lha x %1 > $.bat
echo Which files?
readln >>$.bat
if errorlevel 1 call $
goto end
:47
echonl set fn=> $.bat
echo Which File?
readln >>$.bat
if not errorlevel 1 goto end
echo lha x %1 %%fn%% >> $.bat
echo vu %%fn%% >> $.bat
echo del %%fn%% >> $.bat
echo set fn= >>$.bat
call $
:end
if exist $.bat del $.bat( t 	   t  LVXESC DEBUG SCRIPT FILE 	L N GETSCAN.COM
A 100
XOR AH,AH
INT 16
CMP AH,0
JE 100
MOV AL,AH
MOV AH,4C
INT 21

R CX
10
W
Q

RETURNS THE SCANCODE AS AN ERRORLEVEL NUMBER

@ECHO OFF
ECHO DO YOU WANT TO PRINT A DIRECTORY (Y/N)?
:LOOP
GETSCAN
IF ERRORLEVEL 21 IF NOT ERRORLEVEL 22 GOTO YES
IF ERRORLEVEL 49 IF NOT ERRORLEVEL 50 GOTO NO
GOTO LOOP
:YES
DIR
:NO

SEE ALSO: RBEESC AND LVXESC.SCR
) L 	   L  GETSCAN DEBUG SCRIPT FILE 	 N ENV.COM
;rem only works on current environment
;USAGE: ENV > XSET.BAT
;lets you use xset to recreate the current
;env variables from a batch file.
A 100
MOV BX,0001     ;FILE HANDLE FOR STDOUT
MOV AX,[002C]   ;SEGM ADDR OF ENVIRONMENT
MOV DS,AX       ;GET IT INTO DS
XOR DI,DI       ;ZERO OUT DI
MOV DX,DI       ;ZERO OUT DX
XOR CX,CX       ;ZERO OUT CX
MOV AL,[DI]     ;BEGIN LOOP TO FINE ONE E-VAR
TEST AL,AL      ;ASCII ZERO?
JZ  0118        ;IF SO, JUMP OUT OF LOOP
INC DI          ;ELSE, POINT TO NEXT CHARACTER
INC CX          ;...INCR CX
JMP 010E        ;LOOP AGAIN
PUSH DX         ;
PUSH CX
PUSH DS
PUSH CS
POP  DS         ; SET DS TO CS
MOV  AH,40      ; SELECT WRITE FILE OR DEVICE FUNCTION
MOV  CX,0006    ; WRITE 6 CHARS
MOV  DX,013A    ; FROM ADDRESS CS:13A
INT  21         ; CALL DOS FUNCTION
POP  DS         ; RESTORE REGISTERS(DS POINTS TO ENV)
POP  CX         ; CX CONTAINS SIZE OF E-VAR
POP  DX         ; DX IS OFFSET OF START OF E-VAR
MOV  AH,40      ; WRITE FILE OR DEVICE
INT  21
INC  DI
MOV  AL,[DI]
TEST AL,AL      ; IF IT'S NOT ASCII #0
JNZ  10A        ; GET NEXT E-VAR
MOV  AX,4C00
INT  21
DB   0D,0A,'SET '

RCX
40
W
Q

%  	 
    ENV DEBUG SCRIPT FILE 	v Another way to get Y or N
N YN.COM
A 100
XOR AH,AH
INT 16    ;get a key
CMP AH,15 ;is it a y
JZ  0110  ;jump to exit
CMP AH,31 ;is it n
JZ  0110  ;jump to exit
JMP 0100  ;else try again
;0110
MOV AL,AH 
MOV AH,4C
INT 21
;0116

RCX
16
W
q

The batch file ....

@echo off
::testyn.bat
:Again
echo Quit? [y/n]
YN
if errorlevel 49 goto again
if errorlevel 21 goto end
:end
echo Quitting
$ v 	   v  YN DEBUG SCRIPT FILE 	  byte:  hex num 0-FFh
drive: 1-byte value: 0 for A:, 1 for B:
filespec:drive,path,filename,extension
list:  1 or more byte or string values
portaddress: hex value for an 8 or 16 bit 
port address

.  	     Arguments-2 DEBUG definitions: 	  range:  
1)addr addr e.g. B800:0 100. (The second addr
must use offset only.)
2) addr L value, where value is the length of the
range starting at addr. e.g. B800:100 L 100). 

IF the segment is not specified, it defaults to DS.

.  	     Arguments-3 DEBUG definitions: 	  Registername: AX,BX,CX,DX,SP,BP,SI,DI,
              DS,ES,SS,CS,IP,F
Sector Sector:starting relative sector number followed by
the number of sectors to be loaded or written.
String:       String of chars in quotes
              e.g. "HP 95LX"
.  	     Arguments-4 DEBUG definitions: 	  The PC stores values of greater than one byte in reverse
order. 
E.G. A03BDC is broken into A0 3B DC and is stored as DC
3B A0. Be careful of this one.
9  	     Arguments-5 DEBUG Data storage convention 	  The PC can use 1M of memory, but the CPU can't directly
address this. It uses two numbers SEG:OFFS with ranges
0-FFFFh. The absolute address is given as 10h*SEG+OFFS. Remember A0F3:9378 is stored as 78 93 F3 A0.
2  	     Arguments-6 DEBUG Memory addresses 	 AX: accumulator-most arith operations
BX: base-used for XLAT command which converts chars from
one code to another
CX: counter-used for string ops,loops, bit operations
DX: data-arithmetic ops
Each register is 16 bits (2 bytes) with
corresponding _L and _H one byte regs.
0  	     Arguments-7 DEBUG Data Registers 	  BP: Base Pointer-used with BX to con- vert from one char
code to another
DI: Destination Index-used to store destination of
strings.
SI: Source Index-stores starting location of strings
SP: Stack Pointer

;  	     Arguments-8 DEBUG Pointer & Index Registers 	 	 CS: Code Segment-stores segment # of the current command.
DS: Data Segment-stores segment of active data
ES: Extra Segment-stores segment of special parts of
memory
SS: Stack Segment-stores segment of active stack
3 	 	   	  Arguments-9 DEBUG Segment Registers 	 
 IP: or PC(program counter): contains the offset in the
code segment (CS)of the next command the CPU is to
execute.
When the command is executed, IP is updated to show next
command location.

: 
 	   
  Arguments-A DEBUG Command Pointer Register 	= AF: Aux Carry Flag(bit 4 of F)set to 1
if there's a carry or borrow; else 0
CF: Carry Flag(bit 0 of F) set to 1 for 
a carry or borrow; else 0
OF: Overflow flag(bit 11 of F) set to 1 
for overflow PF: Parity flag(bit 2 of F)
set to 1 for even parity: 0 for odd   
SF: Sign flag(bit 7 of F) set to 1 if 
operation result is negative;else set 
to 0.
ZF: Zero flag(bit 6 of F) set to 1 if 
result of op is 0; else 1
DF: Direction flag (bit 10 of F) is set 
to 1, all string cmds start with lowest 
numbered location and go to highest. 
If set to 1, the order is reversed
IF: Interrupt flag (bit 9 of F): 
if 1, then respond to maskable ints.
If 0 then ignore. 
//TF: Trap flag (bit 8 of F):if 1 
then pause after each command.

The PC uses the flags register and its 
ability to indicate various machine 
states.

e.g.

-r
AX=0000  BX=0000  CX=0000  DX=0000  SP=FFEE  BP=0000   SI=0000  DI=0000  
DS=1880  ES=1880  SS=1880  CS=1880  IP=0100   NV UP EI PL NZ NA PO NC 
1880:0100 32E2          XOR  AH,DL           \ flags regs settings   /                   

FLAG              Symbol if set   Symbol if clear
----              -------------   ---------------
overflow          OV              NV
direction         DN              UP
interrupt         EI              DI
sign              NG              PL
zero              ZR              NZ
auxiliary carry   AC              NA
parity            PE              PO
carry             CY              NC

As you use debug to trace the instructions, watch how each  instruction affects the flags.

7  	     Arguments-B DEBUG Flag Status Registers 	 where address is the start of assembly.
Default is CS:0100.  
Enter lines of standard 8086/88 assembly language. When
done, enter a blank line to return to the DEBUG prompt.

I purposely left the Assemble command to the end, as
it is the most complex of the data entry commands.  It
will take the instructions in the assembler language
and convert them to machine code directly.  Some of
the things it can't do, however, are: reference
labels, set equates, use macros, or anything else
which cannot be translated to a value. Data locations
have to be referenced by the physical memory address,
segment registers, if different from the defaults,
must be specified, and RET instructions must specify
the type (NEAR or FAR) of return to be used.  Also, if
an instruction references data but not registers (i.e.
Mov [278],5), the Byte ptr or Word ptr overrides must
be specified. One other restriction:  To tell DEBUG
the difference between moving 1234h into AX and moving
the data from location 1234 into AX, the latter is
coded as Mov AX,[1234], where the brackets indicate
the reference is an addressed location. The
differences between MASM and DEBUG are as follows:

MASM             DEBUG               Comments

Mov AX,1234     Mov AX,1234       Place 1234 into AX
Mov AX,L1234    Mov AX,[1234]     Contents of add. 1234 to AX
Mov AX,CS:1234  CS:Mov AX,[1234]  Move from offset of CS.
Movs Byte ptr ...  Movesb         Move byte string
Movs Word ptr ...  Movsw          Move word string
Ret             Ret               Near return
Ret             Retf              Far return

Also, Jmp instructions will be assembled automatically
to Short, Near, or Far Jmps. However, the Near and Far
operands can be used to override the displacement if
you do need them. Let's try a very simple routine to
clear the screen.

   -A 100
   6897:0100 mov ax,600
   6897:0103 mov cx,0
   6897:0106 mov dx,184f
   6897:0109 mov bh,07
   6897:010B int 10
   6897:010D int 20
   6897:010F
   -

We are using BIOS interrupt 10h, which is the video
interrupt. (If you would like more information on the
interrupt, there is a very good description in the
Technical Reference Manual.) We need to call BIOS with
AX=600, BH=7, CX=0, and DX=184Fh. First we had to load
the registers, which we did at in the first four
instructions.  The statement at offset 6897:010B
actually called BIOS.  The INT 20 at offset 010D is
for safety only. We really don't need it, but with it
in, the program will stop automatically.  Without the
INT 20, and if we did not stop, DEBUG would try and
execute whatever occurs at 010F.  If this happens to
be a valid program (unlikely), we would just execute
the program.  Usually, though, we will find it to be
invalid, and will probably hang the system, requiring
a cntl- alt-del (maybe) or a power-off and on again
(usually). So, be careful and double check your work!

Now, we need to execute the prograAoihead, and will
probably hang the system, requiring a cntl-alt-del
(maybe) or a power-off and on again (usually). So, be
careful and double check your work!

Now, we need to execute the program. To do this, enter
the G command, a G followed by the enter key.  If you
have entered the program correctly, the screen will
clear and you will get a message "Program terminated
normally". (More on the Go command later).

Again, I cannot stress the importance of checking your
work when using the Assemble command.  The commands
may assemble correctly, but cause a lot of problems.
This is especially important for the Jmp and Call
commands; since they cause an interruption in the flow
of the program, they can cause the program to jump
into the middle of an instruction, causing VERY
unpredictable results.
3  	     Assemble DEBUG Command: -A[address] 	p Returns errorlevels 0,1,2 for R,B, Esc respctively.

N RBESC.COM ;Recover,Bkup,Esc
A 100
XOR    AH,AH                
INT    16      ;get a key                           
XOR    AL,AL   ;AL=0                 
CMP    AH,13   ;is it r
JZ     011d    ;jump 
CMP    AH,30   ;is it b
JZ     011b    ;jump
cmp    AH,01   ;esc
jz     0117    ;jump
JMP    0100    ;try again
;<0117>
inc    AL      ;al=1
;<011b>
xor    ah,ah   ;nop
inc    AL      ;al=2
;<011d>
MOV    AH,4C                              
INT    21      ;back to DOS                      
;<0121> END

RCX
21
W
q

The Tricky Part: Originally "b" jz'd to 0119. The opcode was 74 09. But the 09 (tab) turned into 20 (space) and the program became 74 20 or JZ 130, which was beyond the
program's end. CRASH!. The fix: put in XOR AH,AH as a NOP to avoid using 74 09.

This will work with any two keys. Just use the first byte from the Keys part of PROHLP in place of 13 or 30. Just be careful of 00, 0A, 0D, 09 op codes.

::TEST.BAT
@echo off
RBESC
if errorlevel 2 goto 2
if errorlevel 1 goto 1
if errorlevel 0 goto 0
:2
echo you pressed r
goto end
:1
echo you pressed b
goto end
:0
echo you pressed esc
:end( p 	   p  RB_ESC DEBUG Script File 	M
u From Dave Vickers: a new RW routine that works from FILER and SYSMGR as well as the DOS prompt. The loop is in the asm code rather than the batch file. The output is direc-
tly to a file.

;-------------------------------------------------------- ; NEWRW.ASM
;
; Assemble with ML.EXE (from MASM 6.0), not MASM.EXE:
;
;   ML RW.ASM
;-------------------------------------------------------- 
	.MODEL tiny
        .CODE
        org 100h

Main proc near
	assume ds:_TEXT, ss:_TEXT, es:_TEXT

;--- Create the output file specified in the command tail
        xor  ah, ah
        mov  al, 80H
        mov  si, ax 
;SI now points to th Length of command tail
        lodsb
        add  si, ax
        mov  byte ptr [si], ah  
;Terminate file name with a null

        mov  ax, 3C00H - 2      
; mov AX,3C00H - CREAT a file
        add  ax, 2              ; ...
        xor  cx, cx             ; Normal attribue
        xor  dh, dh
        mov  dl, 82H            ; Ptr to file name
        int  21H
;*** Should add code here to check for open errors if 
; Carry Flag set ***
        mov  di, ax             ; Save file handle

; Use DOS function C,A to read a string from the keyboard
BigLoop:
        xor  dh, dh
        mov  dl, 082h           
;store the string in the PSP @ 82h
        mov  si, dx
        mov  byte ptr [si],072h 
;read up to maximum number of characters

        mov  ax, 0C0AH + 4040H  
;mov AX, 0C0AH-Clear Kyboard buffer & Do a Buffered Input
        sub  ax, 4040H          ;...
        int  21H

;-------- If user simply hit Enter, terminate the program
        inc  si                 
;Point to number of characters read
        lodsb
        and  al, al             
;If AL is 0, no characters were read
        jz   Terminate

;-------- String is currently terminater with a CR
; Append a LF
        xor  ch,ch
        mov  cl,al              ;Put string length in CX
        inc  cx                 
;To include ending Carriage Return

        add  si, cx
        mov  byte ptr [si], 09H            
        inc  byte ptr [si]      
;mov [SI], 0AH (Line Feed)
        inc  cx                 ;To include Line Feed

;Write the string and ending CR, LF to the output file
        mov  ah, 040h           
;DOS write from handle function #
        mov  bx, di             ;File handle
        xor  dh, dh             
;just to be sure, reset DX
        mov  dl, 084h           ;print the string
        int  21h
        
;Output CR,LF to screen to start a new screen line
        dec  si                 
;SI now points to the terminating CR,LF
        mov  ah, 040h           
;DOS write from handle function #
        sub  bh, bh
        mov  bl, 1              ;File handle (stdout)
        xor  ch, ch
        mov  cl, 2              ;Number of bytes to write
        mov  dx, si             ;String to output
        int  21h

        jmp  BigLoop

Terminate:
        mov  ah,04ch            
;DOS terminate program function #
        xor  al,al              ;Errorlevel 0
        int  021h               ;terminate the program

Main    endp

        end Main

SAMPLE batch file NEWRWTST.BAT

@echo off
echo 2䰀$;32!2rJL-@@!F"t(2A 	A@2!N@* 2!L2!>newrw.com
newrw $.bat
del newrw.com
call $
del $.bat
+ u 	   u  NEWRW.ASM DEBUG Script file 
P          	 
    f g      \   X     ! # Y $ W & ( * , - 	 w SEE RVEESC and LVXEsc

Produces an old fashioned menu by accepting only certain key codes and returning an errorlevel.
& w 	   w  MENU DEBUG SCRIPT FILE b         All Database Items                                                       
  ; 3 C = < A 1 e % d q D "  E  F G [ 8 H I J   Z   K : i h L j M N 0 O n ' k P ? Q t ) R w 4 6 u + 7 . >  p r s c o _  /  S T m l @ b U 
 2 ` V B a ^ ] 5 9 v 
   ; 3         	 
   C = < A 1 e % d q D "  E  F G  f g [ 8  H I J    Z    K :  i h L  j \  M N  0 O n ' k X  P ? Q t ) R  w 4    6 u + ! 7 # . Y >  $ W p & r s c ( o _  /  S T m l @ b U 
 2 * ` , V B a ^ ] - 5 9 v        j     f  d   w          b    /        W  V  w       ܘ    = 
U >J  O  ~ A _ #k  t S
       F
   Q d  
 c  .     _ M  m# 
 x. s    3  u     K  ,    ,  & V 8 9  s >@   2 
 f[[ D   Q   P   WQ j    GR   cT U SU   V  :W  Y ) m  :           Qu   t   fv 6    g q  7   2Z  ܴ   [   [   \   ]  q    ]   O^   
_  _ E b b    9d ` e   F lf |  g   .h  h  p $ F< 1 B }  v W  ?	 g  0  	       b C/  7 a   7 } L Js   v j    9  K * z ~ M
 z   B  P    J(  o#,   .  (.  I.  w9  G2  ]0  ;  3  Қ:  Л7  G9  J '   3  `=   &  )&  Y L  [A   (   +  F >  ( :  f B   ;   8   %  i%   @  U :   (  l B   =  	)  	 <   /  M *  /=  | *  | :   *  z=   (  ) ?  pg@  0 &   )  p *   *  n )   '   '   &  : *  ` '   )   )  W)   *   *  (   &   &  ( &  N '   *  t )  r*   *   )   *   *   *  E *  o (   )  )   )   )   )   '  = (  d *   '   )  $ '   )   (  - 0  U (   )  }S&  j(   )   *   &  (  _q)  ( (   '  Q '  x 4   2  ?'   '  V (   '  '  O (  . )   (  >(  R.  g,(  ~$  ̄(  +  $  3&  a  w  r                                 